/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.examples.Archiver;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SevenZArchiverTest
extends AbstractTestCase {
    private File target;

    private void assertDir(String expectedName, ArchiveEntry entry) {
        Assertions.assertNotNull((Object)entry, () -> expectedName + " does not exists");
        Assertions.assertEquals((Object)(expectedName + "/"), (Object)entry.getName());
        Assertions.assertTrue((boolean)entry.isDirectory(), (String)(expectedName + " is not a directory"));
    }

    private void assertHelloWorld(String expectedName, String suffix, ArchiveEntry entry, SevenZFile z) throws IOException {
        Assertions.assertNotNull((Object)entry, () -> expectedName + " does not exists");
        Assertions.assertEquals((Object)expectedName, (Object)entry.getName());
        Assertions.assertFalse((boolean)entry.isDirectory(), (String)(expectedName + " is a directory"));
        byte[] expected = ("Hello, world " + suffix).getBytes(StandardCharsets.UTF_8);
        byte[] actual = new byte[expected.length];
        Assertions.assertEquals((int)actual.length, (int)z.read(actual));
        Assertions.assertEquals((int)-1, (int)z.read());
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void channelVersion() throws IOException, ArchiveException {
        try (FileChannel c = FileChannel.open(this.target.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            new Archiver().create("7z", (SeekableByteChannel)c, this.dir);
        }
        this.verifyContent();
    }

    @Test
    public void fileVersion() throws IOException, ArchiveException {
        new Archiver().create("7z", this.target, this.dir);
        this.verifyContent();
    }

    @Test
    public void outputStreamVersion() throws IOException {
        try (OutputStream os = Files.newOutputStream(this.target.toPath(), new OpenOption[0]);){
            Assertions.assertThrows(StreamingNotSupportedException.class, () -> new Archiver().create("7z", os, this.dir));
        }
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        File c = new File(this.dir, "a/b/c");
        c.mkdirs();
        try (OutputStream os = Files.newOutputStream(new File(this.dir, "a/b/d.txt").toPath(), new OpenOption[0]);){
            os.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
        }
        os = Files.newOutputStream(new File(this.dir, "a/b/c/e.txt").toPath(), new OpenOption[0]);
        var3_3 = null;
        try {
            os.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (os != null) {
                if (var3_3 != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    os.close();
                }
            }
        }
        this.target = new File(this.resultDir, "test.7z");
    }

    @Test
    public void unknownFormat() throws IOException {
        try (FileChannel c = FileChannel.open(this.target.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            Assertions.assertThrows(ArchiveException.class, () -> new Archiver().create("unknown format", c, this.dir));
        }
    }

    private void verifyContent() throws IOException {
        try (SevenZFile z = new SevenZFile(this.target);){
            this.assertDir("a", (ArchiveEntry)z.getNextEntry());
            this.assertDir("a/b", (ArchiveEntry)z.getNextEntry());
            SevenZArchiveEntry n = z.getNextEntry();
            Assertions.assertNotNull((Object)n);
            if (n.getName().endsWith("/")) {
                this.assertDir("a/b/c", (ArchiveEntry)n);
                this.assertHelloWorld("a/b/c/e.txt", "2", (ArchiveEntry)z.getNextEntry(), z);
                this.assertHelloWorld("a/b/d.txt", "1", (ArchiveEntry)z.getNextEntry(), z);
            } else {
                this.assertHelloWorld("a/b/d.txt", "1", (ArchiveEntry)n, z);
                this.assertDir("a/b/c", (ArchiveEntry)z.getNextEntry());
                this.assertHelloWorld("a/b/c/e.txt", "2", (ArchiveEntry)z.getNextEntry(), z);
            }
        }
    }
}

