/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import com.github.marschall.memoryfilesystem.MemoryFileSystemBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TarMemoryFileSystemTest {
    @Test
    public void checkUserInformationInTarEntry() throws IOException, ArchiveException {
        String user = "commons";
        String group = "compress";
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().addUser("commons").addGroup("compress").build();){
            Throwable throwable;
            Path source = fileSystem.getPath("original-file.txt", new String[0]);
            Files.write(source, "Test".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.setAttribute(source, "posix:owner", () -> "commons", new LinkOption[0]);
            Files.setAttribute(source, "posix:group", () -> "compress", new LinkOption[0]);
            Path target = fileSystem.getPath("original-file.tar", new String[0]);
            try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
                throwable = null;
                try (ArchiveOutputStream tarOut = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out);){
                    TarArchiveEntry entry = new TarArchiveEntry(source);
                    tarOut.putArchiveEntry((ArchiveEntry)entry);
                    Files.copy(source, (OutputStream)tarOut);
                    tarOut.closeArchiveEntry();
                }
                catch (Throwable entry) {
                    throwable = entry;
                    throw entry;
                }
            }
            var8_10 = null;
            try (InputStream input = Files.newInputStream(target, new OpenOption[0]);){
                throwable = null;
                try (TarArchiveInputStream tarIn = new TarArchiveInputStream(input);){
                    TarArchiveEntry nextTarEntry = tarIn.getNextTarEntry();
                    Assertions.assertEquals((Object)"commons", (Object)nextTarEntry.getUserName());
                    Assertions.assertEquals((Object)"compress", (Object)nextTarEntry.getGroupName());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                var8_10 = throwable3;
                throw throwable3;
            }
        }
    }

    @Test
    public void tarFromMemoryFileSystem() throws IOException, ArchiveException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path p = fileSystem.getPath("test.txt", new String[0]);
            Files.write(p, "Test".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            File f = File.createTempFile("commons-compress-memoryfs", ".tar");
            try (OutputStream out = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                 ArchiveOutputStream tarOut = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out);){
                TarArchiveEntry entry = new TarArchiveEntry(p);
                tarOut.putArchiveEntry((ArchiveEntry)entry);
                Files.copy(p, (OutputStream)tarOut);
                tarOut.closeArchiveEntry();
                Assertions.assertEquals((long)f.length(), (long)tarOut.getBytesWritten());
            }
        }
    }

    @Test
    public void tarToMemoryFileSystem() throws IOException, ArchiveException {
        try (FileSystem fileSystem = MemoryFileSystemBuilder.newLinux().build();){
            Path p = fileSystem.getPath("target.tar", new String[0]);
            try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);
                 ArchiveOutputStream tarOut = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("tar", out);){
                String content = "Test";
                TarArchiveEntry entry = new TarArchiveEntry("test.txt");
                entry.setSize((long)"Test".length());
                tarOut.putArchiveEntry((ArchiveEntry)entry);
                tarOut.write("Test".getBytes(StandardCharsets.UTF_8));
                tarOut.closeArchiveEntry();
                Assertions.assertTrue((boolean)Files.exists(p, new LinkOption[0]));
                Assertions.assertEquals((long)Files.size(p), (long)tarOut.getBytesWritten());
            }
        }
    }
}

