/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.BinaryTree;
import org.apache.commons.compress.archivers.zip.BitStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BinaryTreeTest {
    @Test
    public void testDecode() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{2, 66, 1, 19});
        BinaryTree tree = BinaryTree.decode((InputStream)in, (int)8);
        Assertions.assertNotNull((Object)tree);
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-115, -59, 17, 0}));
        Assertions.assertEquals((int)0, (int)tree.read(stream));
        Assertions.assertEquals((int)1, (int)tree.read(stream));
        Assertions.assertEquals((int)2, (int)tree.read(stream));
        Assertions.assertEquals((int)3, (int)tree.read(stream));
        Assertions.assertEquals((int)4, (int)tree.read(stream));
        Assertions.assertEquals((int)5, (int)tree.read(stream));
        Assertions.assertEquals((int)6, (int)tree.read(stream));
        Assertions.assertEquals((int)7, (int)tree.read(stream));
    }

    @Test
    public void testExceptions() {
        BinaryTree binaryFinary = new BinaryTree(4);
        binaryFinary.addLeaf(0, 0, 0, 1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> binaryFinary.addLeaf(0, 0, 0, 1));
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        Assertions.assertThrows(IOException.class, () -> BinaryTree.decode((InputStream)is, (int)0));
        Assertions.assertThrows(IOException.class, () -> new BinaryTree(4).read(new BitStream((InputStream)new ByteArrayInputStream(new byte[]{0}))));
    }
}

