/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Date;
import org.apache.commons.compress.archivers.zip.X000A_NTFS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class X000A_NTFSTest {
    @Test
    public void simpleRountrip() throws Exception {
        X000A_NTFS xf = new X000A_NTFS();
        xf.setModifyJavaTime(new Date(0L));
        xf.setAccessJavaTime(new Date(-11644473601000L));
        xf.setCreateJavaTime(null);
        byte[] b = xf.getLocalFileDataData();
        X000A_NTFS xf2 = new X000A_NTFS();
        xf2.parseFromLocalFileData(b, 0, b.length);
        Assertions.assertEquals((Object)new Date(0L), (Object)xf2.getModifyJavaTime());
        Assertions.assertEquals((Object)new Date(-11644473601000L), (Object)xf2.getAccessJavaTime());
        Assertions.assertNull((Object)xf2.getCreateJavaTime());
    }

    @Test
    public void simpleRountripWithHighPrecisionDatesWithBigValues() throws Exception {
        X000A_NTFS xf = new X000A_NTFS();
        xf.setModifyFileTime(FileTime.from(Instant.ofEpochSecond(123456789101L, 123456700L)));
        xf.setAccessFileTime(FileTime.from(Instant.ofEpochSecond(-11644473601L)));
        xf.setCreateFileTime(FileTime.from(Instant.ofEpochSecond(-11644473600L, 765432100L)));
        byte[] b = xf.getLocalFileDataData();
        X000A_NTFS xf2 = new X000A_NTFS();
        xf2.parseFromLocalFileData(b, 0, b.length);
        Assertions.assertEquals((Object)FileTime.from(Instant.ofEpochSecond(123456789101L, 123456700L)), (Object)xf2.getModifyFileTime());
        Assertions.assertEquals((Object)new Date(123456789101123L), (Object)xf2.getModifyJavaTime());
        Assertions.assertEquals((Object)FileTime.from(Instant.ofEpochSecond(-11644473601L)), (Object)xf2.getAccessFileTime());
        Assertions.assertEquals((Object)new Date(-11644473601000L), (Object)xf2.getAccessJavaTime());
        Assertions.assertEquals((Object)FileTime.from(Instant.ofEpochSecond(-11644473600L, 765432100L)), (Object)xf2.getCreateFileTime());
        Assertions.assertEquals((Object)new Date(-11644473599235L).toInstant(), (Object)xf2.getCreateJavaTime().toInstant());
    }

    @Test
    public void simpleRountripWithHighPrecisionDatesWithSmallValues() throws Exception {
        X000A_NTFS xf = new X000A_NTFS();
        xf.setModifyFileTime(FileTime.from(Instant.ofEpochSecond(0L, 1234L)));
        xf.setAccessFileTime(FileTime.from(Instant.ofEpochSecond(-11644473601L)));
        xf.setCreateFileTime(null);
        byte[] b = xf.getLocalFileDataData();
        X000A_NTFS xf2 = new X000A_NTFS();
        xf2.parseFromLocalFileData(b, 0, b.length);
        Assertions.assertEquals((Object)FileTime.from(Instant.ofEpochSecond(0L, 1200L)), (Object)xf2.getModifyFileTime());
        Assertions.assertEquals((Object)new Date(0L), (Object)xf2.getModifyJavaTime());
        Assertions.assertEquals((Object)FileTime.from(Instant.ofEpochSecond(-11644473601L)), (Object)xf2.getAccessFileTime());
        Assertions.assertEquals((Object)new Date(-11644473601000L), (Object)xf2.getAccessJavaTime());
        Assertions.assertNull((Object)xf2.getCreateFileTime());
        Assertions.assertNull((Object)xf2.getCreateJavaTime());
    }
}

