/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.zip.ZipException;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipSplitReadOnlySeekableByteChannel;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZipArchiveInputStreamTest
extends AbstractTestCase {
    private static void nameSource(String archive, String entry, int entryNo, ZipArchiveEntry.NameSource expected) throws Exception {
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream(Files.newInputStream(ZipArchiveInputStreamTest.getFile(archive).toPath(), new OpenOption[0]));){
            ZipArchiveEntry ze;
            do {
                ze = zis.getNextZipEntry();
            } while (--entryNo > 0);
            Assertions.assertEquals((Object)entry, (Object)ze.getName());
            Assertions.assertEquals((Object)expected, (Object)ze.getNameSource());
        }
    }

    private static void nameSource(String archive, String entry, ZipArchiveEntry.NameSource expected) throws Exception {
        ZipArchiveInputStreamTest.nameSource(archive, entry, 1, expected);
    }

    private static byte[] readEntry(ZipArchiveInputStream zip, ZipArchiveEntry zae) throws IOException {
        int len = (int)zae.getSize();
        byte[] buff = new byte[len];
        zip.read(buff, 0, len);
        return buff;
    }

    private void extractZipInputStream(ZipArchiveInputStream in) throws IOException {
        ZipArchiveEntry zae = in.getNextZipEntry();
        while (zae != null) {
            if (zae.getName().endsWith(".zip")) {
                this.extractZipInputStream(new ZipArchiveInputStream((InputStream)in));
            }
            zae = in.getNextZipEntry();
        }
    }

    /*
     * Exception decompiling
     */
    private InputStream forgeZipInputStream() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fuzzingTest(int[] bytes) throws Exception {
        int len = bytes.length;
        byte[] input = new byte[len];
        for (int i = 0; i < len; ++i) {
            input[i] = (byte)bytes[i];
        }
        try (ArchiveInputStream ais = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("zip", (InputStream)new ByteArrayInputStream(input));){
            ais.getNextEntry();
            IOUtils.toByteArray((InputStream)ais);
        }
    }

    private void getAllZipEntries(ZipArchiveInputStream zipInputStream) throws IOException {
        while (zipInputStream.getNextZipEntry() != null) {
        }
    }

    private void multiByteReadConsistentlyReturnsMinusOneAtEof(File file) throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = ZipArchiveInputStreamTest.newInputStream("bla.zip");
             ZipArchiveInputStream archive = new ZipArchiveInputStream(in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingBzip2() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("bzip2-zip.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("bla.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate64() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("COMPRESS-380/COMPRESS-380.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingExplode() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("imploding-8Kdict-3trees.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingStore() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("COMPRESS-264.zip"));
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingUnshrink() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("SHRUNK.ZIP"));
    }

    @Test
    public void multiByteReadThrowsAtEofForCorruptedStoredEntry() throws Exception {
        byte[] content = Files.readAllBytes(ZipArchiveInputStreamTest.getFile("COMPRESS-264.zip").toPath());
        for (int i = 17; i < 26; ++i) {
            content[i] = -1;
        }
        byte[] buf = new byte[2];
        try (ByteArrayInputStream in = new ByteArrayInputStream(content);
             ZipArchiveInputStream archive = new ZipArchiveInputStream((InputStream)in);){
            ArchiveEntry e = archive.getNextEntry();
            IOException ex1 = (IOException)Assertions.assertThrows(IOException.class, () -> IOUtils.toByteArray((InputStream)archive), (String)"expected exception");
            Assertions.assertEquals((Object)"Truncated ZIP file", (Object)ex1.getMessage());
            IOException ex2 = (IOException)Assertions.assertThrows(IOException.class, () -> archive.read(buf), (String)"expected exception");
            Assertions.assertEquals((Object)"Truncated ZIP file", (Object)ex2.getMessage());
            IOException ex3 = (IOException)Assertions.assertThrows(IOException.class, () -> archive.read(buf), (String)"expected exception");
            Assertions.assertEquals((Object)"Truncated ZIP file", (Object)ex3.getMessage());
        }
    }

    @Test
    public void nameSourceDefaultsToName() throws Exception {
        ZipArchiveInputStreamTest.nameSource("bla.zip", "test1.xml", ZipArchiveEntry.NameSource.NAME);
    }

    @Test
    public void nameSourceIsSetToEFS() throws Exception {
        ZipArchiveInputStreamTest.nameSource("utf8-7zip-test.zip", "\u20ac_for_Dollar.txt", 3, ZipArchiveEntry.NameSource.NAME_WITH_EFS_FLAG);
    }

    @Test
    public void nameSourceIsSetToUnicodeExtraField() throws Exception {
        ZipArchiveInputStreamTest.nameSource("utf8-winzip-test.zip", "\u20ac_for_Dollar.txt", ZipArchiveEntry.NameSource.UNICODE_EXTRA_FIELD);
    }

    @Test
    public void properlyMarksEntriesAsUnreadableIfUncompressedSizeIsUnknown() throws Exception {
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));){
            ZipArchiveEntry e = new ZipArchiveEntry("test");
            e.setMethod(ZipMethod.DEFLATED.getCode());
            Assertions.assertTrue((boolean)zis.canReadEntryData((ArchiveEntry)e));
            e.setMethod(ZipMethod.ENHANCED_DEFLATED.getCode());
            Assertions.assertTrue((boolean)zis.canReadEntryData((ArchiveEntry)e));
            e.setMethod(ZipMethod.BZIP2.getCode());
            Assertions.assertFalse((boolean)zis.canReadEntryData((ArchiveEntry)e));
        }
    }

    @Test
    public void properlyReadsStoredEntries() throws IOException {
        try (InputStream fs = ZipArchiveInputStreamTest.newInputStream("bla-stored.zip");
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assertions.assertEquals((long)610L, (long)e.getCompressedSize());
            Assertions.assertEquals((long)610L, (long)e.getSize());
            byte[] data = IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)610, (int)data.length);
            e = archive.getNextZipEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((Object)"test2.xml", (Object)e.getName());
            Assertions.assertEquals((long)82L, (long)e.getCompressedSize());
            Assertions.assertEquals((long)82L, (long)e.getSize());
            data = IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)82, (int)data.length);
            Assertions.assertNull((Object)archive.getNextEntry());
        }
    }

    @Test
    public void properlyReadsStoredEntryWithDataDescriptorWithoutSignature() throws IOException {
        try (InputStream fs = ZipArchiveInputStreamTest.newInputStream("bla-stored-dd-nosig.zip");
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs, "UTF-8", true, true);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assertions.assertEquals((long)-1L, (long)e.getCompressedSize());
            Assertions.assertEquals((long)-1L, (long)e.getSize());
            byte[] data = IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)610, (int)data.length);
            Assertions.assertEquals((long)610L, (long)e.getCompressedSize());
            Assertions.assertEquals((long)610L, (long)e.getSize());
        }
    }

    @Test
    public void properlyReadsStoredEntryWithDataDescriptorWithSignature() throws IOException {
        try (InputStream fs = ZipArchiveInputStreamTest.newInputStream("bla-stored-dd.zip");
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs, "UTF-8", true, true);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assertions.assertEquals((long)-1L, (long)e.getCompressedSize());
            Assertions.assertEquals((long)-1L, (long)e.getSize());
            byte[] data = IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)610, (int)data.length);
            Assertions.assertEquals((long)610L, (long)e.getCompressedSize());
            Assertions.assertEquals((long)610L, (long)e.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void properUseOfInflater() throws Exception {
        ZipFile zf = null;
        ZipArchiveInputStream in = null;
        try {
            ZipArchiveEntry innerEntry;
            zf = new ZipFile(ZipArchiveInputStreamTest.getFile("COMPRESS-189.zip"));
            ZipArchiveEntry zae = zf.getEntry("USD0558682-20080101.ZIP");
            in = new ZipArchiveInputStream((InputStream)new BufferedInputStream(zf.getInputStream(zae)));
            while ((innerEntry = in.getNextZipEntry()) != null) {
                if (!innerEntry.getName().endsWith("XML")) continue;
                Assertions.assertTrue((0 < in.read() ? 1 : 0) != 0);
            }
        }
        finally {
            if (zf != null) {
                zf.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    public void readDeflate64CompressedStream() throws Exception {
        File input = ZipArchiveInputStreamTest.getFile("COMPRESS-380/COMPRESS-380-input");
        File archive = ZipArchiveInputStreamTest.getFile("COMPRESS-380/COMPRESS-380.zip");
        try (InputStream in = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZipArchiveInputStream zin = new ZipArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            byte[] orig = IOUtils.toByteArray((InputStream)in);
            ZipArchiveEntry e = zin.getNextZipEntry();
            byte[] fromZip = IOUtils.toByteArray((InputStream)zin);
            Assertions.assertArrayEquals((byte[])orig, (byte[])fromZip);
        }
    }

    @Test
    public void readDeflate64CompressedStreamWithDataDescriptor() throws Exception {
        File archive = ZipArchiveInputStreamTest.getFile("COMPRESS-380/COMPRESS-380-dd.zip");
        try (ZipArchiveInputStream zin = new ZipArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            ZipArchiveEntry e = zin.getNextZipEntry();
            Assertions.assertEquals((long)-1L, (long)e.getSize());
            Assertions.assertEquals((int)ZipMethod.ENHANCED_DEFLATED.getCode(), (int)e.getMethod());
            byte[] fromZip = IOUtils.toByteArray((InputStream)zin);
            byte[] expected = new byte[]{77, 97, 110, 105, 102, 101, 115, 116, 45, 86, 101, 114, 115, 105, 111, 110, 58, 32, 49, 46, 48, 13, 10, 13, 10};
            Assertions.assertArrayEquals((byte[])expected, (byte[])fromZip);
            zin.getNextZipEntry();
            Assertions.assertEquals((long)25L, (long)e.getSize());
        }
    }

    @Test
    public void rejectsStoredEntriesWithDataDescriptorByDefault() throws IOException {
        try (InputStream fs = ZipArchiveInputStreamTest.newInputStream("bla-stored-dd.zip");
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assertions.assertEquals((long)-1L, (long)e.getCompressedSize());
            Assertions.assertEquals((long)-1L, (long)e.getSize());
            Assertions.assertThrows(UnsupportedZipFeatureException.class, () -> IOUtils.toByteArray((InputStream)archive));
        }
    }

    @Test
    public void shouldConsumeArchiveCompletely() throws Exception {
        try (InputStream is = ZipArchiveInputStreamTest.class.getResourceAsStream("/archive_with_trailer.zip");
             ZipArchiveInputStream zip = new ZipArchiveInputStream(is);){
            this.getAllZipEntries(zip);
            byte[] expected = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10};
            byte[] actual = new byte[expected.length];
            is.read(actual);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void shouldReadNestedZip() throws IOException {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream(ZipArchiveInputStreamTest.newInputStream("COMPRESS-219.zip"));){
            this.extractZipInputStream(in);
        }
    }

    private void singleByteReadConsistentlyReturnsMinusOneAtEof(File file) throws Exception {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
             ZipArchiveInputStream archive = new ZipArchiveInputStream(in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read());
            Assertions.assertEquals((int)-1, (int)archive.read());
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingBzip2() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("bzip2-zip.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("bla.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate64() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("COMPRESS-380/COMPRESS-380.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingExplode() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("imploding-8Kdict-3trees.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingStore() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("COMPRESS-264.zip"));
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingUnshrink() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(ZipArchiveInputStreamTest.getFile("SHRUNK.ZIP"));
    }

    @Test
    public void singleByteReadThrowsAtEofForCorruptedStoredEntry() throws Exception {
        byte[] content = Files.readAllBytes(ZipArchiveInputStreamTest.getFile("COMPRESS-264.zip").toPath());
        for (int i = 17; i < 26; ++i) {
            content[i] = -1;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(content);
             ZipArchiveInputStream archive = new ZipArchiveInputStream((InputStream)in);){
            ArchiveEntry e = archive.getNextEntry();
            IOException ex1 = (IOException)Assertions.assertThrows(IOException.class, () -> IOUtils.toByteArray((InputStream)archive), (String)"expected exception");
            Assertions.assertEquals((Object)"Truncated ZIP file", (Object)ex1.getMessage());
            IOException ex2 = (IOException)Assertions.assertThrows(IOException.class, () -> ((ZipArchiveInputStream)archive).read(), (String)"expected exception");
            Assertions.assertEquals((Object)"Truncated ZIP file", (Object)ex2.getMessage());
            IOException ex3 = (IOException)Assertions.assertThrows(IOException.class, () -> ((ZipArchiveInputStream)archive).read(), (String)"expected exception");
            Assertions.assertEquals((Object)"Truncated ZIP file", (Object)ex3.getMessage());
        }
    }

    @Test
    public void testMessageWithCorruptFileName() throws Exception {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream(ZipArchiveInputStreamTest.newInputStream("COMPRESS-351.zip"));){
            EOFException ex = (EOFException)Assertions.assertThrows(EOFException.class, () -> {
                ZipArchiveEntry ze = in.getNextZipEntry();
                while (ze != null) {
                    ze = in.getNextZipEntry();
                }
            }, (String)"expected EOFException");
            String m = ex.getMessage();
            Assertions.assertTrue((boolean)m.startsWith("Truncated ZIP entry: ?2016"));
        }
    }

    @Test
    public void testOffsets() throws Exception {
        try (InputStream archiveStream = ZipArchiveInputStream.class.getResourceAsStream("/mixed.zip");
             ZipArchiveInputStream zipStream = new ZipArchiveInputStream(archiveStream);){
            ZipArchiveEntry inflatedEntry = zipStream.getNextZipEntry();
            Assertions.assertEquals((Object)"inflated.txt", (Object)inflatedEntry.getName());
            Assertions.assertEquals((long)0L, (long)inflatedEntry.getLocalHeaderOffset());
            Assertions.assertEquals((long)70L, (long)inflatedEntry.getDataOffset());
            ZipArchiveEntry storedEntry = zipStream.getNextZipEntry();
            Assertions.assertEquals((Object)"stored.txt", (Object)storedEntry.getName());
            Assertions.assertEquals((long)22674L, (long)storedEntry.getLocalHeaderOffset());
            Assertions.assertEquals((long)22742L, (long)storedEntry.getDataOffset());
            Assertions.assertNull((Object)zipStream.getNextZipEntry());
        }
    }

    @Test
    public void testReadingOfFirstStoredEntry() throws Exception {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream(ZipArchiveInputStreamTest.newInputStream("COMPRESS-264.zip"));){
            ZipArchiveEntry ze = in.getNextZipEntry();
            Assertions.assertEquals((long)5L, (long)ze.getSize());
            Assertions.assertArrayEquals((byte[])new byte[]{100, 97, 116, 97, 10}, (byte[])IOUtils.toByteArray((InputStream)in));
        }
    }

    @Test
    public void testSplitZipCreatedByWinrar() throws IOException {
        File lastFile = ZipArchiveInputStreamTest.getFile("COMPRESS-477/split_zip_created_by_winrar/split_zip_created_by_winrar.zip");
        try (SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
             InputStream inputStream = Channels.newInputStream(channel);
             ZipArchiveInputStream splitInputStream = new ZipArchiveInputStream(inputStream, "UTF8", true, false, true);){
            File fileToCompare = ZipArchiveInputStreamTest.getFile("COMPRESS-477/split_zip_created_by_winrar/zip_to_compare_created_by_winrar.zip");
            try (ZipArchiveInputStream inputStreamToCompare = new ZipArchiveInputStream(Files.newInputStream(fileToCompare.toPath(), new OpenOption[0]), "UTF8", true, false, true);){
                ArchiveEntry entry;
                while ((entry = splitInputStream.getNextEntry()) != null && inputStreamToCompare.getNextEntry() != null) {
                    if (entry.isDirectory()) continue;
                    Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)splitInputStream), (byte[])IOUtils.toByteArray((InputStream)inputStreamToCompare));
                }
            }
        }
    }

    @Test
    public void testSplitZipCreatedByZip() throws IOException {
        File lastFile = ZipArchiveInputStreamTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        try (SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
             InputStream inputStream = Channels.newInputStream(channel);
             ZipArchiveInputStream splitInputStream = new ZipArchiveInputStream(inputStream, "UTF8", true, false, true);){
            File fileToCompare = ZipArchiveInputStreamTest.getFile("COMPRESS-477/split_zip_created_by_zip/zip_to_compare_created_by_zip.zip");
            try (ZipArchiveInputStream inputStreamToCompare = new ZipArchiveInputStream(Files.newInputStream(fileToCompare.toPath(), new OpenOption[0]), "UTF8", true, false, true);){
                ArchiveEntry entry;
                while ((entry = splitInputStream.getNextEntry()) != null && inputStreamToCompare.getNextEntry() != null) {
                    if (entry.isDirectory()) continue;
                    Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)splitInputStream), (byte[])IOUtils.toByteArray((InputStream)inputStreamToCompare));
                }
            }
        }
    }

    @Test
    public void testSplitZipCreatedByZipOfZip64() throws IOException {
        File lastFile = ZipArchiveInputStreamTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip_zip64.zip");
        try (SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
             InputStream inputStream = Channels.newInputStream(channel);
             ZipArchiveInputStream splitInputStream = new ZipArchiveInputStream(inputStream, "UTF8", true, false, true);){
            File fileToCompare = ZipArchiveInputStreamTest.getFile("COMPRESS-477/split_zip_created_by_zip/zip_to_compare_created_by_zip_zip64.zip");
            try (ZipArchiveInputStream inputStreamToCompare = new ZipArchiveInputStream(Files.newInputStream(fileToCompare.toPath(), new OpenOption[0]), "UTF8", true, false, true);){
                ArchiveEntry entry;
                while ((entry = splitInputStream.getNextEntry()) != null && inputStreamToCompare.getNextEntry() != null) {
                    if (entry.isDirectory()) continue;
                    Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)splitInputStream), (byte[])IOUtils.toByteArray((InputStream)inputStreamToCompare));
                }
            }
        }
    }

    @Test
    public void testSplitZipCreatedByZipThrowsException() throws IOException {
        File zipSplitFile = ZipArchiveInputStreamTest.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        InputStream fileInputStream = Files.newInputStream(zipSplitFile.toPath(), new OpenOption[0]);
        ZipArchiveInputStream inputStream = new ZipArchiveInputStream(fileInputStream, "UTF8", true, false, true);
        Assertions.assertThrows(EOFException.class, () -> {
            ArchiveEntry entry = inputStream.getNextEntry();
            while (entry != null) {
                entry = inputStream.getNextEntry();
            }
        });
    }

    @Test
    public void testThrowOnInvalidEntry() throws Exception {
        InputStream is = ZipArchiveInputStreamTest.class.getResourceAsStream("/invalid-zip.zip");
        try (ZipArchiveInputStream zip = new ZipArchiveInputStream(is);){
            ZipException expected = (ZipException)Assertions.assertThrows(ZipException.class, () -> ((ZipArchiveInputStream)zip).getNextZipEntry(), (String)"IOException expected");
            Assertions.assertTrue((boolean)expected.getMessage().contains("Unexpected record signature"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnshrinkEntry() throws Exception {
        ZipArchiveInputStream in = new ZipArchiveInputStream(ZipArchiveInputStreamTest.newInputStream("SHRUNK.ZIP"));
        ZipArchiveEntry entry = in.getNextZipEntry();
        Assertions.assertEquals((int)ZipMethod.UNSHRINKING.getCode(), (int)entry.getMethod(), (String)"method");
        Assertions.assertTrue((boolean)in.canReadEntryData((ArchiveEntry)entry));
        try (InputStream original = ZipArchiveInputStreamTest.newInputStream("test1.xml");){
            Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)in));
        }
        entry = in.getNextZipEntry();
        Assertions.assertEquals((int)ZipMethod.UNSHRINKING.getCode(), (int)entry.getMethod(), (String)"method");
        Assertions.assertTrue((boolean)in.canReadEntryData((ArchiveEntry)entry));
        original = ZipArchiveInputStreamTest.newInputStream("test2.xml");
        try {
            Assertions.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)in));
        }
        finally {
            original.close();
        }
    }

    @Test
    public void testUnzipBZip2CompressedEntry() throws Exception {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream(ZipArchiveInputStreamTest.newInputStream("bzip2-zip.zip"));){
            ZipArchiveEntry ze = in.getNextZipEntry();
            Assertions.assertEquals((long)42L, (long)ze.getSize());
            byte[] expected = new byte[42];
            Arrays.fill(expected, (byte)97);
            Assertions.assertArrayEquals((byte[])expected, (byte[])IOUtils.toByteArray((InputStream)in));
        }
    }

    @Test
    public void testWithBytesAfterData() throws Exception {
        int expectedNumEntries = 2;
        InputStream is = ZipArchiveInputStreamTest.class.getResourceAsStream("/archive_with_bytes_after_data.zip");
        try (ZipArchiveInputStream zip = new ZipArchiveInputStream(is);){
            int actualNumEntries = 0;
            ZipArchiveEntry zae = zip.getNextZipEntry();
            while (zae != null) {
                ++actualNumEntries;
                ZipArchiveInputStreamTest.readEntry(zip, zae);
                zae = zip.getNextZipEntry();
            }
            Assertions.assertEquals((int)2, (int)actualNumEntries);
        }
    }

    @Test
    public void testZipUsingStoredWithDDAndNoDDSignature() throws IOException {
        try (InputStream inputStream = this.forgeZipInputStream();
             ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(inputStream, "UTF-8", true, true);){
            this.getAllZipEntries(zipInputStream);
        }
    }

    @Test
    public void testZipWithBadExtraFields() throws IOException {
        try (InputStream fis = ZipArchiveInputStreamTest.newInputStream("COMPRESS-548.zip");
             ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(fis);){
            this.getAllZipEntries(zipInputStream);
        }
    }

    @Test
    public void throwsIfStoredDDIsDifferentFromLengthRead() throws IOException {
        try (InputStream fs = ZipArchiveInputStreamTest.newInputStream("bla-stored-dd-contradicts-actualsize.zip");
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs, "UTF-8", true, true);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assertions.assertEquals((long)-1L, (long)e.getCompressedSize());
            Assertions.assertEquals((long)-1L, (long)e.getSize());
            Assertions.assertThrows(ZipException.class, () -> IOUtils.toByteArray((InputStream)archive));
        }
    }

    @Test
    public void throwsIfStoredDDIsInconsistent() throws IOException {
        try (InputStream fs = ZipArchiveInputStreamTest.newInputStream("bla-stored-dd-sizes-differ.zip");
             ZipArchiveInputStream archive = new ZipArchiveInputStream(fs, "UTF-8", true, true);){
            ZipArchiveEntry e = archive.getNextZipEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assertions.assertEquals((long)-1L, (long)e.getCompressedSize());
            Assertions.assertEquals((long)-1L, (long)e.getSize());
            Assertions.assertThrows(ZipException.class, () -> IOUtils.toByteArray((InputStream)archive));
        }
    }

    @Test
    public void throwsIfThereIsNoEocd() {
        Assertions.assertThrows(IOException.class, () -> this.fuzzingTest(new int[]{80, 75, 1, 2, 20, 0, 20, 0, 8, 0, 8, 0, 0, 0, 0, 0, 67, 190, 0, 0, 0, 183, 232, 7, 0, 0, 0, 1, 0, 0}));
    }

    @Test
    public void throwsIfZip64ExtraCouldNotBeUnderstood() {
        Assertions.assertThrows(IOException.class, () -> this.fuzzingTest(new int[]{80, 75, 3, 4, 46, 0, 0, 0, 12, 0, 132, 182, 186, 70, 114, 182, 254, 119, 99, 0, 0, 0, 107, 0, 0, 0, 3, 0, 28, 0, 98, 98, 98, 1, 0, 9, 0, 3, 231, 206, 100, 85, 243, 206, 100, 85, 117, 120, 11, 0, 1, 4, 92, 249, 1, 0, 4, 136, 19, 0, 0}));
    }

    @Test
    public void throwsIOExceptionIfThereIsCorruptedZip64Extra() throws IOException {
        try (InputStream fis = ZipArchiveInputStreamTest.newInputStream("COMPRESS-546.zip");
             ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(fis);){
            Assertions.assertThrows(IOException.class, () -> this.getAllZipEntries(zipInputStream));
        }
    }

    @Test
    public void winzipBackSlashWorkaround() throws Exception {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream(ZipArchiveInputStreamTest.newInputStream("test-winzip.zip"));){
            ZipArchiveEntry zae = in.getNextZipEntry();
            zae = in.getNextZipEntry();
            zae = in.getNextZipEntry();
            Assertions.assertEquals((Object)"\u00e4/", (Object)zae.getName());
        }
    }
}

