/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Enumeration;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ZipFileIgnoringLocalFileHeaderTest {
    private File dir;

    private static ZipFile openZipWithoutLFH(String fileName) throws IOException {
        return new ZipFile(AbstractTestCase.getFile(fileName), "UTF8", true, true);
    }

    @Test
    public void getEntryWorks() throws IOException {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLFH("bla.zip");){
            ZipArchiveEntry ze = zf.getEntry("test1.xml");
            Assertions.assertEquals((long)610L, (long)ze.getSize());
        }
    }

    @Test
    public void getRawInputStreamReturnsNotNull() throws IOException {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLFH("bla.zip");){
            ZipArchiveEntry ze = zf.getEntry("test1.xml");
            Assertions.assertNotNull((Object)zf.getRawInputStream(ze));
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.dir = AbstractTestCase.mkdir("dir");
    }

    @AfterEach
    public void tearDown() {
        AbstractTestCase.rmdir(this.dir);
    }

    @Test
    public void testDuplicateEntry() throws Exception {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLFH("COMPRESS-227.zip");){
            int numberOfEntries = 0;
            for (ZipArchiveEntry entry : zf.getEntries("test1.txt")) {
                ++numberOfEntries;
                Assertions.assertNotNull((Object)zf.getInputStream(entry));
            }
            Assertions.assertEquals((int)2, (int)numberOfEntries);
        }
    }

    @Test
    public void testPhysicalOrder() throws IOException {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLFH("ordertest.zip");){
            Enumeration e = zf.getEntriesInPhysicalOrder();
            ZipArchiveEntry ze = null;
            do {
                ze = (ZipArchiveEntry)e.nextElement();
            } while (e.hasMoreElements());
            Assertions.assertEquals((Object)"src/main/java/org/apache/commons/compress/archivers/zip/ZipUtil.java", (Object)ze.getName());
        }
    }

    @Test
    public void testZipUnarchive() throws Exception {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLFH("bla.zip");){
            Enumeration e = zf.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)e.nextElement();
                Files.copy(zf.getInputStream(entry), new File(this.dir, entry.getName()).toPath(), new CopyOption[0]);
            }
        }
    }
}

