/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz77support;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.compress.compressors.lz77support.LZ77Compressor;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LZ77CompressorTest {
    private static final byte[] BLA = "Blah blah blah blah blah!".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SAM = "I am Sam\n\nSam I am\n\nThat Sam-I-am!\nThat Sam-I-am!\nI do not like\nthat Sam-I-am!\n\nDo you like green eggs and ham?\n\nI do not like them, Sam-I-am.\nI do not like green eggs and ham.".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ONE_TO_TEN = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

    private static final void assertBackReference(int expectedOffset, int expectedLength, LZ77Compressor.Block block) {
        Assertions.assertEquals(LZ77Compressor.BackReference.class, block.getClass());
        LZ77Compressor.BackReference b = (LZ77Compressor.BackReference)block;
        Assertions.assertEquals((int)expectedOffset, (int)b.getOffset());
        Assertions.assertEquals((int)expectedLength, (int)b.getLength());
    }

    private static final void assertLiteralBlock(byte[] expectedContent, LZ77Compressor.Block block) {
        Assertions.assertEquals(LZ77Compressor.LiteralBlock.class, block.getClass());
        Assertions.assertArrayEquals((byte[])expectedContent, (byte[])((LZ77Compressor.LiteralBlock)block).getData());
    }

    private static final void assertLiteralBlock(String expectedContent, LZ77Compressor.Block block) {
        LZ77CompressorTest.assertLiteralBlock(expectedContent.getBytes(StandardCharsets.US_ASCII), block);
    }

    private static final void assertSize(int expectedSize, List<LZ77Compressor.Block> blocks) {
        Assertions.assertEquals((int)expectedSize, (int)blocks.size());
        Assertions.assertEquals((Object)LZ77Compressor.Block.BlockType.EOD, (Object)blocks.get(expectedSize - 1).getType());
    }

    private static Parameters newParameters(int windowSize) {
        return Parameters.builder((int)windowSize).build();
    }

    private static Parameters newParameters(int windowSize, int minBackReferenceLength, int maxBackReferenceLength, int maxOffset, int maxLiteralLength) {
        return Parameters.builder((int)windowSize).withMinBackReferenceLength(minBackReferenceLength).withMaxBackReferenceLength(maxBackReferenceLength).withMaxOffset(maxOffset).withMaxLiteralLength(maxLiteralLength).tunedForCompressionRatio().build();
    }

    private static final byte[][] stagger(byte[] data) {
        byte[][] r = new byte[data.length][1];
        for (int i = 0; i < data.length; ++i) {
            r[i][0] = data[i];
        }
        return r;
    }

    @Test
    public void blaExampleSmallerWindowSize() throws IOException {
        List<LZ77Compressor.Block> blocks = this.compress(LZ77CompressorTest.newParameters(8), new byte[][]{BLA});
        LZ77CompressorTest.assertSize(6, blocks);
        LZ77CompressorTest.assertLiteralBlock("Blah b", blocks.get(0));
        LZ77CompressorTest.assertBackReference(5, 7, blocks.get(1));
        LZ77CompressorTest.assertBackReference(5, 3, blocks.get(2));
        LZ77CompressorTest.assertBackReference(5, 7, blocks.get(3));
        LZ77CompressorTest.assertLiteralBlock("h!", blocks.get(4));
    }

    @Test
    public void blaExampleWithFullArrayAvailableForCompression() throws IOException {
        List<LZ77Compressor.Block> blocks = this.compress(LZ77CompressorTest.newParameters(128), new byte[][]{BLA});
        LZ77CompressorTest.assertSize(4, blocks);
        LZ77CompressorTest.assertLiteralBlock("Blah b", blocks.get(0));
        LZ77CompressorTest.assertBackReference(5, 18, blocks.get(1));
        LZ77CompressorTest.assertLiteralBlock("!", blocks.get(2));
    }

    @Test
    public void blaExampleWithPrefill() throws IOException {
        ArrayList<LZ77Compressor.Block> blocks = new ArrayList<LZ77Compressor.Block>();
        LZ77Compressor c = new LZ77Compressor(LZ77CompressorTest.newParameters(128), block -> {
            if (block instanceof LZ77Compressor.LiteralBlock) {
                LZ77Compressor.LiteralBlock b = (LZ77Compressor.LiteralBlock)block;
                int len = b.getLength();
                block = new LZ77Compressor.LiteralBlock(Arrays.copyOfRange(b.getData(), b.getOffset(), b.getOffset() + len), 0, len);
            }
            blocks.add(block);
        });
        c.prefill(Arrays.copyOfRange(BLA, 0, 6));
        c.compress(Arrays.copyOfRange(BLA, 6, BLA.length));
        c.finish();
        LZ77CompressorTest.assertSize(3, blocks);
        LZ77CompressorTest.assertBackReference(5, 18, (LZ77Compressor.Block)blocks.get(0));
        LZ77CompressorTest.assertLiteralBlock("!", (LZ77Compressor.Block)blocks.get(1));
    }

    @Test
    public void blaExampleWithPrefillBiggerThanWindowSize() throws IOException {
        ArrayList<LZ77Compressor.Block> blocks = new ArrayList<LZ77Compressor.Block>();
        LZ77Compressor c = new LZ77Compressor(LZ77CompressorTest.newParameters(4), block -> {
            if (block instanceof LZ77Compressor.LiteralBlock) {
                LZ77Compressor.LiteralBlock b = (LZ77Compressor.LiteralBlock)block;
                int len = b.getLength();
                block = new LZ77Compressor.LiteralBlock(Arrays.copyOfRange(b.getData(), b.getOffset(), b.getOffset() + len), 0, len);
            }
            blocks.add(block);
        });
        c.prefill(Arrays.copyOfRange(BLA, 0, 6));
        c.compress(Arrays.copyOfRange(BLA, 6, BLA.length));
        c.finish();
        LZ77CompressorTest.assertSize(6, blocks);
        LZ77CompressorTest.assertLiteralBlock("lah ", (LZ77Compressor.Block)blocks.get(0));
        LZ77CompressorTest.assertLiteralBlock("blah", (LZ77Compressor.Block)blocks.get(1));
        LZ77CompressorTest.assertLiteralBlock(" bla", (LZ77Compressor.Block)blocks.get(2));
        LZ77CompressorTest.assertLiteralBlock("h bl", (LZ77Compressor.Block)blocks.get(3));
        LZ77CompressorTest.assertLiteralBlock("ah!", (LZ77Compressor.Block)blocks.get(4));
    }

    @Test
    public void blaExampleWithShorterBackReferenceLength() throws IOException {
        List<LZ77Compressor.Block> blocks = this.compress(LZ77CompressorTest.newParameters(128, 3, 5, 0, 0), new byte[][]{BLA});
        LZ77CompressorTest.assertSize(7, blocks);
        LZ77CompressorTest.assertLiteralBlock("Blah b", blocks.get(0));
        LZ77CompressorTest.assertBackReference(5, 5, blocks.get(1));
        LZ77CompressorTest.assertBackReference(5, 5, blocks.get(2));
        LZ77CompressorTest.assertBackReference(5, 5, blocks.get(3));
        LZ77CompressorTest.assertBackReference(5, 3, blocks.get(4));
        LZ77CompressorTest.assertLiteralBlock("!", blocks.get(5));
    }

    @Test
    public void blaExampleWithShortPrefill() throws IOException {
        ArrayList<LZ77Compressor.Block> blocks = new ArrayList<LZ77Compressor.Block>();
        LZ77Compressor c = new LZ77Compressor(LZ77CompressorTest.newParameters(128), block -> {
            if (block instanceof LZ77Compressor.LiteralBlock) {
                LZ77Compressor.LiteralBlock b = (LZ77Compressor.LiteralBlock)block;
                int len = b.getLength();
                block = new LZ77Compressor.LiteralBlock(Arrays.copyOfRange(b.getData(), b.getOffset(), b.getOffset() + len), 0, len);
            }
            blocks.add(block);
        });
        c.prefill(Arrays.copyOfRange(BLA, 0, 2));
        c.compress(Arrays.copyOfRange(BLA, 2, BLA.length));
        c.finish();
        LZ77CompressorTest.assertSize(4, blocks);
        LZ77CompressorTest.assertLiteralBlock("ah b", (LZ77Compressor.Block)blocks.get(0));
        LZ77CompressorTest.assertBackReference(5, 18, (LZ77Compressor.Block)blocks.get(1));
        LZ77CompressorTest.assertLiteralBlock("!", (LZ77Compressor.Block)blocks.get(2));
    }

    @Test
    public void blaExampleWithSingleByteWrites() throws IOException {
        List<LZ77Compressor.Block> blocks = this.compress(LZ77CompressorTest.newParameters(128), LZ77CompressorTest.stagger(BLA));
        Assertions.assertEquals((int)9, (int)blocks.size());
        LZ77CompressorTest.assertLiteralBlock("Blah b", blocks.get(0));
        LZ77CompressorTest.assertBackReference(5, 3, blocks.get(1));
        LZ77CompressorTest.assertBackReference(5, 3, blocks.get(2));
        LZ77CompressorTest.assertBackReference(5, 3, blocks.get(3));
        LZ77CompressorTest.assertBackReference(5, 3, blocks.get(4));
        LZ77CompressorTest.assertBackReference(5, 3, blocks.get(5));
        LZ77CompressorTest.assertBackReference(5, 3, blocks.get(6));
        LZ77CompressorTest.assertLiteralBlock("!", blocks.get(7));
    }

    @Test
    public void cantPrefillAfterCompress() throws IOException {
        LZ77Compressor c = new LZ77Compressor(LZ77CompressorTest.newParameters(128), block -> {});
        c.compress(Arrays.copyOfRange(BLA, 0, 2));
        Assertions.assertThrows(IllegalStateException.class, () -> c.prefill(Arrays.copyOfRange(BLA, 2, 4)));
    }

    @Test
    public void cantPrefillTwice() {
        LZ77Compressor c = new LZ77Compressor(LZ77CompressorTest.newParameters(128), block -> {});
        c.prefill(Arrays.copyOfRange(BLA, 0, 2));
        Assertions.assertThrows(IllegalStateException.class, () -> c.prefill(Arrays.copyOfRange(BLA, 2, 4)));
    }

    private List<LZ77Compressor.Block> compress(Parameters params, byte[] ... chunks) throws IOException {
        ArrayList<LZ77Compressor.Block> blocks = new ArrayList<LZ77Compressor.Block>();
        LZ77Compressor c = new LZ77Compressor(params, block -> {
            if (block instanceof LZ77Compressor.LiteralBlock) {
                LZ77Compressor.LiteralBlock b = (LZ77Compressor.LiteralBlock)block;
                int len = b.getLength();
                block = new LZ77Compressor.LiteralBlock(Arrays.copyOfRange(b.getData(), b.getOffset(), b.getOffset() + len), 0, len);
            }
            blocks.add(block);
        });
        for (byte[] chunk : chunks) {
            c.compress(chunk);
        }
        c.finish();
        return blocks;
    }

    @Test
    public void nonCompressableSentAsSingleBytes() throws IOException {
        List<LZ77Compressor.Block> blocks = this.compress(LZ77CompressorTest.newParameters(8), LZ77CompressorTest.stagger(ONE_TO_TEN));
        LZ77CompressorTest.assertSize(3, blocks);
        LZ77CompressorTest.assertLiteralBlock(new byte[]{1, 2, 3, 4, 5, 6, 7, 8}, blocks.get(0));
        LZ77CompressorTest.assertLiteralBlock(new byte[]{9, 10}, blocks.get(1));
    }

    @Test
    public void nonCompressableWithLengthGreaterThanLiteralMaxButLessThanTwiceWindowSize() throws IOException {
        List<LZ77Compressor.Block> blocks = this.compress(LZ77CompressorTest.newParameters(8), new byte[][]{ONE_TO_TEN});
        LZ77CompressorTest.assertSize(3, blocks);
        LZ77CompressorTest.assertLiteralBlock(new byte[]{1, 2, 3, 4, 5, 6, 7, 8}, blocks.get(0));
        LZ77CompressorTest.assertLiteralBlock(new byte[]{9, 10}, blocks.get(1));
    }

    @Test
    public void nonCompressableWithLengthSmallerThanLiteralMax() throws IOException {
        List<LZ77Compressor.Block> blocks = this.compress(LZ77CompressorTest.newParameters(128), new byte[][]{ONE_TO_TEN});
        LZ77CompressorTest.assertSize(2, blocks);
        LZ77CompressorTest.assertLiteralBlock(ONE_TO_TEN, blocks.get(0));
    }

    @Test
    public void nonCompressableWithLengthThatForcesWindowSlide() throws IOException {
        List<LZ77Compressor.Block> blocks = this.compress(LZ77CompressorTest.newParameters(4), new byte[][]{ONE_TO_TEN});
        LZ77CompressorTest.assertSize(4, blocks);
        LZ77CompressorTest.assertLiteralBlock(new byte[]{1, 2, 3, 4}, blocks.get(0));
        LZ77CompressorTest.assertLiteralBlock(new byte[]{5, 6, 7, 8}, blocks.get(1));
        LZ77CompressorTest.assertLiteralBlock(new byte[]{9, 10}, blocks.get(2));
    }

    @Test
    public void samIAmExampleWithFullArrayAvailableForCompression() throws IOException {
        List<LZ77Compressor.Block> blocks = this.compress(LZ77CompressorTest.newParameters(1024), new byte[][]{SAM});
        Assertions.assertEquals((int)21, (int)blocks.size());
        LZ77CompressorTest.assertLiteralBlock("I am Sam\n\n", blocks.get(0));
        LZ77CompressorTest.assertBackReference(5, 3, blocks.get(1));
        LZ77CompressorTest.assertLiteralBlock(" ", blocks.get(2));
        LZ77CompressorTest.assertBackReference(14, 4, blocks.get(3));
        LZ77CompressorTest.assertLiteralBlock("\n\nThat", blocks.get(4));
        LZ77CompressorTest.assertBackReference(20, 4, blocks.get(5));
        LZ77CompressorTest.assertLiteralBlock("-I-am!", blocks.get(6));
        LZ77CompressorTest.assertBackReference(15, 16, blocks.get(7));
        LZ77CompressorTest.assertLiteralBlock("I do not like\nt", blocks.get(8));
        LZ77CompressorTest.assertBackReference(29, 14, blocks.get(9));
        LZ77CompressorTest.assertLiteralBlock("\nDo you", blocks.get(10));
        LZ77CompressorTest.assertBackReference(28, 5, blocks.get(11));
        LZ77CompressorTest.assertLiteralBlock(" green eggs and ham?\n", blocks.get(12));
        LZ77CompressorTest.assertBackReference(63, 14, blocks.get(13));
        LZ77CompressorTest.assertLiteralBlock(" them,", blocks.get(14));
        LZ77CompressorTest.assertBackReference(64, 9, blocks.get(15));
        LZ77CompressorTest.assertLiteralBlock(".", blocks.get(16));
        LZ77CompressorTest.assertBackReference(30, 15, blocks.get(17));
        LZ77CompressorTest.assertBackReference(65, 18, blocks.get(18));
        LZ77CompressorTest.assertLiteralBlock(".", blocks.get(19));
    }
}

