/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lzma;

import org.apache.commons.compress.compressors.lzma.LZMAUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LZMAUtilsTestCase {
    @Test
    public void testCachingIsEnabledByDefaultAndLZMAIsPresent() {
        Assertions.assertEquals((Object)LZMAUtils.CachedAvailability.CACHED_AVAILABLE, (Object)LZMAUtils.getCachedLZMAAvailability());
        Assertions.assertTrue((boolean)LZMAUtils.isLZMACompressionAvailable());
    }

    @Test
    public void testCanTurnOffCaching() {
        try {
            LZMAUtils.setCacheLZMAAvailablity((boolean)false);
            Assertions.assertEquals((Object)LZMAUtils.CachedAvailability.DONT_CACHE, (Object)LZMAUtils.getCachedLZMAAvailability());
            Assertions.assertTrue((boolean)LZMAUtils.isLZMACompressionAvailable());
        }
        finally {
            LZMAUtils.setCacheLZMAAvailablity((boolean)true);
        }
    }

    @Test
    public void testGetCompressedFilename() {
        Assertions.assertEquals((Object)".lzma", (Object)LZMAUtils.getCompressedFilename((String)""));
        Assertions.assertEquals((Object)"x.lzma", (Object)LZMAUtils.getCompressedFilename((String)"x"));
        Assertions.assertEquals((Object)"x.wmf .lzma", (Object)LZMAUtils.getCompressedFilename((String)"x.wmf "));
        Assertions.assertEquals((Object)"x.wmf\n.lzma", (Object)LZMAUtils.getCompressedFilename((String)"x.wmf\n"));
        Assertions.assertEquals((Object)"x.wmf.y.lzma", (Object)LZMAUtils.getCompressedFilename((String)"x.wmf.y"));
    }

    @Test
    public void testGetUncompressedFilename() {
        Assertions.assertEquals((Object)"", (Object)LZMAUtils.getUncompressedFilename((String)""));
        Assertions.assertEquals((Object)".lzma", (Object)LZMAUtils.getUncompressedFilename((String)".lzma"));
        Assertions.assertEquals((Object)"x", (Object)LZMAUtils.getUncompressedFilename((String)"x.lzma"));
        Assertions.assertEquals((Object)"x", (Object)LZMAUtils.getUncompressedFilename((String)"x-lzma"));
        Assertions.assertEquals((Object)"x.lzma ", (Object)LZMAUtils.getUncompressedFilename((String)"x.lzma "));
        Assertions.assertEquals((Object)"x.lzma\n", (Object)LZMAUtils.getUncompressedFilename((String)"x.lzma\n"));
        Assertions.assertEquals((Object)"x.lzma.y", (Object)LZMAUtils.getUncompressedFilename((String)"x.lzma.y"));
    }

    @Test
    public void testIsCompressedFilename() {
        Assertions.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)""));
        Assertions.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)".lzma"));
        Assertions.assertTrue((boolean)LZMAUtils.isCompressedFilename((String)"x.lzma"));
        Assertions.assertTrue((boolean)LZMAUtils.isCompressedFilename((String)"x-lzma"));
        Assertions.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"xxgz"));
        Assertions.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"lzmaz"));
        Assertions.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"xaz"));
        Assertions.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"x.lzma "));
        Assertions.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"x.lzma\n"));
        Assertions.assertFalse((boolean)LZMAUtils.isCompressedFilename((String)"x.lzma.y"));
    }

    @Test
    public void testMatches() {
        byte[] data = new byte[]{93, 0, 0};
        Assertions.assertFalse((boolean)LZMAUtils.matches((byte[])data, (int)2));
        Assertions.assertTrue((boolean)LZMAUtils.matches((byte[])data, (int)3));
        Assertions.assertTrue((boolean)LZMAUtils.matches((byte[])data, (int)4));
        data[2] = 48;
        Assertions.assertFalse((boolean)LZMAUtils.matches((byte[])data, (int)3));
    }

    @Test
    public void testTurningOnCachingReEvaluatesAvailability() {
        try {
            LZMAUtils.setCacheLZMAAvailablity((boolean)false);
            Assertions.assertEquals((Object)LZMAUtils.CachedAvailability.DONT_CACHE, (Object)LZMAUtils.getCachedLZMAAvailability());
            LZMAUtils.setCacheLZMAAvailablity((boolean)true);
            Assertions.assertEquals((Object)LZMAUtils.CachedAvailability.CACHED_AVAILABLE, (Object)LZMAUtils.getCachedLZMAAvailability());
        }
        finally {
            LZMAUtils.setCacheLZMAAvailablity((boolean)true);
        }
    }
}

