/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.zstandard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZstdRoundtripTest
extends AbstractTestCase {
    @Test
    public void directRoundtrip() throws Exception {
        this.roundtrip(ZstdCompressorOutputStream::new);
    }

    @Test
    public void factoryRoundtrip() throws Exception {
        Throwable throwable;
        File input = ZstdRoundtripTest.getFile("bla.tar");
        long start = System.currentTimeMillis();
        File output = new File(this.dir, input.getName() + ".zstd");
        try (OutputStream os = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            throwable = null;
            try (CompressorOutputStream zos = new CompressorStreamFactory().createCompressorOutputStream("zstd", os);){
                Files.copy(input.toPath(), (OutputStream)zos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        start = System.currentTimeMillis();
        var6_5 = null;
        try (InputStream inputStream = Files.newInputStream(output.toPath(), new OpenOption[0]);){
            throwable = null;
            try (CompressorInputStream zis = new CompressorStreamFactory().createCompressorInputStream("zstd", inputStream);){
                byte[] expected = Files.readAllBytes(input.toPath());
                byte[] actual = IOUtils.toByteArray((InputStream)zis);
                Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var6_5 = throwable4;
            throw throwable4;
        }
    }

    private void roundtrip(OutputStreamCreator oc) throws IOException {
        Throwable throwable;
        File input = ZstdRoundtripTest.getFile("bla.tar");
        long start = System.currentTimeMillis();
        File output = new File(this.dir, input.getName() + ".zstd");
        try (FileOutputStream os = new FileOutputStream(output);){
            throwable = null;
            try (ZstdCompressorOutputStream zos = oc.wrap(os);){
                Files.copy(input.toPath(), (OutputStream)zos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        start = System.currentTimeMillis();
        var7_6 = null;
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            throwable = null;
            try (ZstdCompressorInputStream zis = new ZstdCompressorInputStream(Files.newInputStream(output.toPath(), new OpenOption[0]));){
                byte[] expected = IOUtils.toByteArray((InputStream)is);
                byte[] actual = IOUtils.toByteArray((InputStream)zis);
                Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var7_6 = throwable4;
            throw throwable4;
        }
    }

    @Test
    public void roundtripWithChecksum() throws Exception {
        this.roundtrip(os -> new ZstdCompressorOutputStream((OutputStream)os, 3, false, true));
    }

    @Test
    public void roundtripWithCloseFrameOnFlush() throws Exception {
        this.roundtrip(os -> new ZstdCompressorOutputStream((OutputStream)os, 3, true));
    }

    @Test
    public void roundtripWithCustomLevel() throws Exception {
        this.roundtrip(os -> new ZstdCompressorOutputStream((OutputStream)os, 1));
    }

    private static interface OutputStreamCreator {
        public ZstdCompressorOutputStream wrap(FileOutputStream var1) throws IOException;
    }
}

