/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import org.apache.commons.compress.harmony.unpack200.CpBands;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.compress.harmony.unpack200.SegmentConstantPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SegmentConstantPoolTest {
    String[] testClassArray = new String[]{"Object", "Object", "java/lang/String", "java/lang/String", "Object", "Other"};
    String[] testMethodArray = new String[]{"<init>()", "clone()", "equals()", "<init>", "isNull()", "Other"};

    @Test
    public void testMatchSpecificPoolEntryIndex_DoubleArray() {
        MockSegmentConstantPool mockInstance = new MockSegmentConstantPool();
        Assertions.assertEquals((int)0, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "Object", "^<init>.*", 0));
        Assertions.assertEquals((int)2, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "java/lang/String", ".*", 0));
        Assertions.assertEquals((int)3, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "java/lang/String", "^<init>.*", 0));
        Assertions.assertEquals((int)5, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "Other", ".*", 0));
        Assertions.assertEquals((int)-1, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "NotThere", "^<init>.*", 0));
        Assertions.assertEquals((int)-1, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, this.testMethodArray, "java/lang/String", "^<init>.*", 1));
    }

    @Test
    public void testMatchSpecificPoolEntryIndex_SingleArray() {
        MockSegmentConstantPool mockInstance = new MockSegmentConstantPool();
        Assertions.assertEquals((int)0, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "Object", 0));
        Assertions.assertEquals((int)1, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "Object", 1));
        Assertions.assertEquals((int)2, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "java/lang/String", 0));
        Assertions.assertEquals((int)3, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "java/lang/String", 1));
        Assertions.assertEquals((int)4, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "Object", 2));
        Assertions.assertEquals((int)5, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "Other", 0));
        Assertions.assertEquals((int)-1, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "NotThere", 0));
        Assertions.assertEquals((int)-1, (int)mockInstance.matchSpecificPoolEntryIndex(this.testClassArray, "java/lang/String", 2));
    }

    @Test
    public void testRegexReplacement() {
        MockSegmentConstantPool mockPool = new MockSegmentConstantPool();
        Assertions.assertTrue((boolean)mockPool.regexMatchesVisible(".*", "anything"));
        Assertions.assertTrue((boolean)mockPool.regexMatchesVisible(".*", ""));
        Assertions.assertTrue((boolean)mockPool.regexMatchesVisible("^<init>.*", "<init>"));
        Assertions.assertTrue((boolean)mockPool.regexMatchesVisible("^<init>.*", "<init>stuff"));
        Assertions.assertFalse((boolean)mockPool.regexMatchesVisible("^<init>.*", "init>stuff"));
        Assertions.assertFalse((boolean)mockPool.regexMatchesVisible("^<init>.*", "<init"));
        Assertions.assertFalse((boolean)mockPool.regexMatchesVisible("^<init>.*", ""));
    }

    public class MockSegmentConstantPool
    extends SegmentConstantPool {
        public MockSegmentConstantPool() {
            super(new CpBands(new Segment()));
        }

        public int matchSpecificPoolEntryIndex(String[] classNameArray, String desiredClassName, int desiredIndex) {
            return super.matchSpecificPoolEntryIndex(classNameArray, desiredClassName, desiredIndex);
        }

        public int matchSpecificPoolEntryIndex(String[] classNameArray, String[] methodNameArray, String desiredClassName, String desiredMethodRegex, int desiredIndex) {
            return super.matchSpecificPoolEntryIndex(classNameArray, methodNameArray, desiredClassName, desiredMethodRegex, desiredIndex);
        }

        public boolean regexMatchesVisible(String regexString, String compareString) {
            return SegmentConstantPool.regexMatches((String)regexString, (String)compareString);
        }
    }
}

