/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteUtilsTest {
    @Test
    public void fromLittleEndianFromArray() {
        byte[] b = new byte[]{1, 2, 3, 4, 5};
        Assertions.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((byte[])b, (int)1, (int)3));
    }

    @Test
    public void fromLittleEndianFromArrayOneArg() {
        byte[] b = new byte[]{2, 3, 4};
        Assertions.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((byte[])b));
    }

    @Test
    public void fromLittleEndianFromArrayOneArgThrowsForLengthTooBig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.fromLittleEndian((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}));
    }

    @Test
    public void fromLittleEndianFromArrayOneArgUnsignedInt32() {
        byte[] b = new byte[]{2, 3, 4, -128};
        Assertions.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((byte[])b));
    }

    @Test
    public void fromLittleEndianFromArrayThrowsForLengthTooBig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.fromLittleEndian((byte[])ByteUtils.EMPTY_BYTE_ARRAY, (int)0, (int)9));
    }

    @Test
    public void fromLittleEndianFromArrayUnsignedInt32() {
        byte[] b = new byte[]{1, 2, 3, 4, -128};
        Assertions.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((byte[])b, (int)1, (int)4));
    }

    @Test
    public void fromLittleEndianFromDataInput() throws IOException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[]{2, 3, 4, 5}));
        Assertions.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((DataInput)din, (int)3));
    }

    @Test
    public void fromLittleEndianFromDataInputThrowsForLengthTooBig() {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.fromLittleEndian((DataInput)din, (int)9));
    }

    @Test
    public void fromLittleEndianFromDataInputThrowsForPrematureEnd() {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[]{2, 3}));
        Assertions.assertThrows(EOFException.class, () -> ByteUtils.fromLittleEndian((DataInput)din, (int)3));
    }

    @Test
    public void fromLittleEndianFromDataInputUnsignedInt32() throws IOException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[]{2, 3, 4, -128}));
        Assertions.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((DataInput)din, (int)4));
    }

    @Test
    public void fromLittleEndianFromStream() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, 5});
        Assertions.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((InputStream)bin, (int)3));
    }

    @Test
    public void fromLittleEndianFromStreamThrowsForLengthTooBig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.fromLittleEndian((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY), (int)9));
    }

    @Test
    public void fromLittleEndianFromStreamThrowsForPrematureEnd() {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertThrows(IOException.class, () -> ByteUtils.fromLittleEndian((InputStream)bin, (int)3));
    }

    @Test
    public void fromLittleEndianFromStreamUnsignedInt32() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, -128});
        Assertions.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((InputStream)bin, (int)4));
    }

    @Test
    public void fromLittleEndianFromSupplier() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, 5});
        Assertions.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)bin), (int)3));
    }

    @Test
    public void fromLittleEndianFromSupplierThrowsForLengthTooBig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY)), (int)9));
    }

    @Test
    public void fromLittleEndianFromSupplierThrowsForPrematureEnd() {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3});
        Assertions.assertThrows(IOException.class, () -> ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)bin), (int)3));
    }

    @Test
    public void fromLittleEndianFromSupplierUnsignedInt32() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, -128});
        Assertions.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)bin), (int)4));
    }

    @Test
    public void toLittleEndianToByteArray() {
        byte[] b = new byte[4];
        ByteUtils.toLittleEndian((byte[])b, (long)262914L, (int)1, (int)3);
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])Arrays.copyOfRange(b, 1, 4));
    }

    @Test
    public void toLittleEndianToByteArrayUnsignedInt32() {
        byte[] b = new byte[4];
        ByteUtils.toLittleEndian((byte[])b, (long)2147746562L, (int)0, (int)4);
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4, -128}, (byte[])b);
    }

    @Test
    public void toLittleEndianToConsumer() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteUtils.toLittleEndian((ByteUtils.ByteConsumer)new ByteUtils.OutputStreamByteConsumer((OutputStream)bos), (long)262914L, (int)3);
        bos.close();
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])bos.toByteArray());
    }

    @Test
    public void toLittleEndianToConsumerUnsignedInt32() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteUtils.toLittleEndian((ByteUtils.ByteConsumer)new ByteUtils.OutputStreamByteConsumer((OutputStream)bos), (long)2147746562L, (int)4);
        bos.close();
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4, -128}, (byte[])bos.toByteArray());
    }

    @Test
    public void toLittleEndianToDataOutput() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        ByteUtils.toLittleEndian((DataOutput)dos, (long)262914L, (int)3);
        bos.close();
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])bos.toByteArray());
    }

    @Test
    public void toLittleEndianToDataOutputUnsignedInt32() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        ByteUtils.toLittleEndian((DataOutput)dos, (long)2147746562L, (int)4);
        bos.close();
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4, -128}, (byte[])bos.toByteArray());
    }

    @Test
    public void toLittleEndianToStream() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteUtils.toLittleEndian((OutputStream)bos, (long)262914L, (int)3);
        bos.close();
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])bos.toByteArray());
    }

    @Test
    public void toLittleEndianToStreamUnsignedInt32() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteUtils.toLittleEndian((OutputStream)bos, (long)2147746562L, (int)4);
        bos.close();
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4, -128}, (byte[])bos.toByteArray());
    }
}

