/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.examples.Archiver;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SevenZArchiverTest
extends AbstractTest {
    private File target;

    private void assertDir(String expectedName, ArchiveEntry entry) {
        Assertions.assertNotNull((Object)entry, () -> expectedName + " does not exists");
        Assertions.assertEquals((Object)(expectedName + "/"), (Object)entry.getName());
        Assertions.assertTrue((boolean)entry.isDirectory(), (String)(expectedName + " is not a directory"));
    }

    private void assertHelloWorld(String expectedName, String suffix, ArchiveEntry entry, SevenZFile z) throws IOException {
        Assertions.assertNotNull((Object)entry, () -> expectedName + " does not exists");
        Assertions.assertEquals((Object)expectedName, (Object)entry.getName());
        Assertions.assertFalse((boolean)entry.isDirectory(), (String)(expectedName + " is a directory"));
        byte[] expected = ("Hello, world " + suffix).getBytes(StandardCharsets.UTF_8);
        byte[] actual = new byte[expected.length];
        Assertions.assertEquals((int)actual.length, (int)z.read(actual));
        Assertions.assertEquals((int)-1, (int)z.read());
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @BeforeEach
    public void setUp() throws Exception {
        File c = this.newTempFile("a/b/c");
        c.mkdirs();
        try (OutputStream os = Files.newOutputStream(this.newTempFile("a/b/d.txt").toPath(), new OpenOption[0]);){
            os.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
        }
        os = Files.newOutputStream(this.newTempFile("a/b/c/e.txt").toPath(), new OpenOption[0]);
        try {
            os.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        this.target = new File(this.tempResultDir, "test.7z");
    }

    @Test
    public void testChannelVersion() throws IOException, ArchiveException {
        try (FileChannel c = FileChannel.open(this.target.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            new Archiver().create("7z", (SeekableByteChannel)c, this.getTempDirFile());
        }
        this.verifyContent();
    }

    @Test
    public void testFileVersion() throws IOException, ArchiveException {
        new Archiver().create("7z", this.target, this.getTempDirFile());
        this.verifyContent();
    }

    @Test
    public void testOutputStreamVersion() throws IOException {
        try (OutputStream os = Files.newOutputStream(this.target.toPath(), new OpenOption[0]);){
            Assertions.assertThrows(StreamingNotSupportedException.class, () -> new Archiver().create("7z", os, this.getTempDirFile()));
        }
    }

    @Test
    public void testUnknownFormat() throws IOException {
        try (FileChannel c = FileChannel.open(this.target.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            Assertions.assertThrows(ArchiveException.class, () -> new Archiver().create("unknown format", c, this.getTempDirFile()));
        }
    }

    private void verifyContent() throws IOException {
        try (SevenZFile z = ((SevenZFile.Builder)SevenZFile.builder().setFile(this.target)).get();){
            this.assertDir("a", (ArchiveEntry)z.getNextEntry());
            this.assertDir("a/b", (ArchiveEntry)z.getNextEntry());
            SevenZArchiveEntry n = z.getNextEntry();
            Assertions.assertNotNull((Object)n);
            if (n.getName().endsWith("/")) {
                this.assertDir("a/b/c", (ArchiveEntry)n);
                this.assertHelloWorld("a/b/c/e.txt", "2", (ArchiveEntry)z.getNextEntry(), z);
                this.assertHelloWorld("a/b/d.txt", "1", (ArchiveEntry)z.getNextEntry(), z);
            } else {
                this.assertHelloWorld("a/b/d.txt", "1", (ArchiveEntry)n, z);
                this.assertDir("a/b/c", (ArchiveEntry)z.getNextEntry());
                this.assertHelloWorld("a/b/c/e.txt", "2", (ArchiveEntry)z.getNextEntry(), z);
            }
        }
    }
}

