/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileTimesIT
extends AbstractTest {
    private void assertGlobalHeaders(TarArchiveEntry e) {
        Assertions.assertEquals((int)5, (int)e.getExtraPaxHeaders().size());
        Assertions.assertEquals((Object)"exustar", (Object)e.getExtraPaxHeader("SCHILY.archtype"), (String)"SCHILY.archtype");
        Assertions.assertEquals((Object)"1647478879.579980900", (Object)e.getExtraPaxHeader("SCHILY.volhdr.dumpdate"), (String)"SCHILY.volhdr.dumpdate");
        Assertions.assertEquals((Object)"star 1.6 (x86_64-unknown-linux-gnu) 2019/04/01", (Object)e.getExtraPaxHeader("SCHILY.release"), (String)"SCHILY.release");
        Assertions.assertEquals((Object)"20", (Object)e.getExtraPaxHeader("SCHILY.volhdr.blocksize"), (String)"SCHILY.volhdr.blocksize");
        Assertions.assertEquals((Object)"1", (Object)e.getExtraPaxHeader("SCHILY.volhdr.volno"), (String)"SCHILY.volhdr.volno");
    }

    @Test
    public void testReadTimeFromTarEpax() throws Exception {
        String file = "COMPRESS-612/test-times-epax-folder.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-epax-folder.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test/", (Object)e.getName());
            Assertions.assertEquals((byte)53, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isDirectory());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:24:44.147126600Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T01:02:11.910960100Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:24:44.147126600Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test/test-times.txt", (Object)e.getName());
            Assertions.assertEquals((byte)48, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isFile());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.536752000Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarExustar() throws Exception {
        String file = "COMPRESS-612/test-times-exustar-folder.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-exustar-folder.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((Object)"test/", (Object)e.getName());
            Assertions.assertEquals((byte)53, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isDirectory());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:24:44.147126600Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:47:00.367783300Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:24:44.147126600Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            this.assertGlobalHeaders(e);
            e = tin.getNextTarEntry();
            Assertions.assertEquals((Object)"test/test-times.txt", (Object)e.getName());
            Assertions.assertEquals((byte)48, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isFile());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.536752000Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            this.assertGlobalHeaders(e);
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarGnu() throws Exception {
        String file = "COMPRESS-612/test-times-gnu.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-gnu.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertNull((Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertNull((Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarGnuIncremental() throws Exception {
        String file = "COMPRESS-612/test-times-gnu-incremental.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-gnu-incremental.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test-times.txt", (Object)e.getName());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertNull((Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertNull((Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test-times.txt", (Object)e.getName());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T03:17:05Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T03:17:10Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T03:17:10Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarGnuTar() throws Exception {
        String file = "COMPRESS-612/test-times-gnutar.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-gnutar.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T01:52:25Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T01:52:25Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T01:52:25Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarOldBsdTar() throws Exception {
        String file = "COMPRESS-612/test-times-oldbsdtar.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-oldbsdtar.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T01:52:25Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertNull((Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertNull((Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarOldGnu() throws Exception {
        String file = "COMPRESS-612/test-times-oldgnu.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-oldgnu.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertNull((Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertNull((Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarOldGnuIncremental() throws Exception {
        String file = "COMPRESS-612/test-times-oldgnu-incremental.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-oldgnu-incremental.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test-times.txt", (Object)e.getName());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertNull((Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertNull((Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test-times.txt", (Object)e.getName());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T03:17:05Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T03:17:06Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T03:17:05Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarPax() throws Exception {
        String file = "COMPRESS-612/test-times-pax-folder.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-pax-folder.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test/", (Object)e.getName());
            Assertions.assertEquals((byte)53, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isDirectory());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:24:44.147126600Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T01:01:53.369146300Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:24:44.147126600Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test/test-times.txt", (Object)e.getName());
            Assertions.assertEquals((byte)48, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isFile());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.536752000Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarPosix() throws Exception {
        String file = "COMPRESS-612/test-times-posix.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-posix.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03.599853900Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:31:00.706927200Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:28:59.700505300Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarPosixLibArchive() throws Exception {
        String file = "COMPRESS-612/test-times-bsd-folder.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-bsd-folder.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test/", (Object)e.getName());
            Assertions.assertEquals((byte)53, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isDirectory());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-16T10:19:43.382883700Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-16T10:21:01.251181000Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-16T10:19:24.105111500Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-16T10:19:24.105111500Z"), (Object)e.getCreationTime(), (String)"birthtime");
            e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test/test-times.txt", (Object)e.getName());
            Assertions.assertEquals((byte)48, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isFile());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-16T10:21:00.249238500Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-16T10:21:01.251181000Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03.599853900Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03.599853900Z"), (Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarPosixLinux() throws Exception {
        String file = "COMPRESS-612/test-times-posix-linux.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-posix-linux.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03.599853900Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:32:13.837251500Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:31:00.706927200Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarStarFolder() throws Exception {
        String file = "COMPRESS-612/test-times-star-folder.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-star-folder.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test/", (Object)e.getName());
            Assertions.assertEquals((byte)53, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isDirectory());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:24:44Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertNull((Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertNull((Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            e = tin.getNextTarEntry();
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test/test-times.txt", (Object)e.getName());
            Assertions.assertEquals((byte)48, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isFile());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertNull((Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertNull((Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarUstar() throws Exception {
        String file = "COMPRESS-612/test-times-ustar.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-ustar.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertNull((Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertNull((Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarV7() throws Exception {
        String file = "COMPRESS-612/test-times-v7.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-v7.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T01:25:03Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertNull((Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertNull((Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarXstar() throws Exception {
        String file = "COMPRESS-612/test-times-xstar.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-xstar.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T04:11:22Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T04:12:48Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T04:12:47Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarXstarFolder() throws Exception {
        String file = "COMPRESS-612/test-times-xstar-folder.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-xstar-folder.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test/", (Object)e.getName());
            Assertions.assertEquals((byte)53, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isDirectory());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:24:44Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T01:01:34Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:24:44Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            e = tin.getNextTarEntry();
            Assertions.assertEquals((Object)"test/test-times.txt", (Object)e.getName());
            Assertions.assertEquals((byte)48, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isFile());
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarXstarIncremental() throws Exception {
        String file = "COMPRESS-612/test-times-xstar-incremental.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-xstar-incremental.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test-times.txt", (Object)e.getName());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T04:03:29Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T04:03:29Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T04:03:29Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test-times.txt", (Object)e.getName(), (String)"name");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T04:11:22Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T04:11:23Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-14T04:11:22Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarXustar() throws Exception {
        String file = "COMPRESS-612/test-times-xustar.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-xustar.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.536752000Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarXustarFolder() throws Exception {
        String file = "COMPRESS-612/test-times-xustar-folder.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-xustar-folder.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test/", (Object)e.getName());
            Assertions.assertEquals((byte)53, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isDirectory());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:24:44.147126600Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T01:01:19.581236400Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:24:44.147126600Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            e = tin.getNextTarEntry();
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test/test-times.txt", (Object)e.getName());
            Assertions.assertEquals((byte)48, (byte)e.getLinkFlag());
            Assertions.assertTrue((boolean)e.isFile());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.536752000Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    public void testReadTimeFromTarXustarIncremental() throws Exception {
        String file = "COMPRESS-612/test-times-xustar-incremental.tar";
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(FileTimesIT.getPath("COMPRESS-612/test-times-xustar-incremental.tar"), new OpenOption[0]));
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test-times.txt", (Object)e.getName(), (String)"name");
            Assertions.assertEquals((byte)48, (byte)e.getLinkFlag());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.536752000Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T00:38:20.470751500Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertTrue((boolean)e.getExtraPaxHeaders().isEmpty());
            Assertions.assertEquals((Object)"test-times.txt", (Object)e.getName(), (String)"name");
            Assertions.assertEquals((byte)48, (byte)e.getLinkFlag());
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T01:52:25.592262900Z"), (Object)e.getLastModifiedTime(), (String)"mtime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T01:52:25.724278500Z"), (Object)e.getLastAccessTime(), (String)"atime");
            Assertions.assertEquals((Object)this.toFileTime("2022-03-17T01:52:25.592262900Z"), (Object)e.getStatusChangeTime(), (String)"ctime");
            Assertions.assertNull((Object)e.getCreationTime(), (String)"birthtime");
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    private FileTime toFileTime(String text) {
        return FileTime.from(Instant.parse(text));
    }
}

