/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.BitStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BitStreamTest {
    @Test
    public void testEmptyStream() throws Exception {
        try (BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));){
            Assertions.assertEquals((int)-1, (int)stream.nextBit(), (String)"next bit");
            Assertions.assertEquals((int)-1, (int)stream.nextBit(), (String)"next bit");
            Assertions.assertEquals((int)-1, (int)stream.nextBit(), (String)"next bit");
        }
    }

    @Test
    public void testNextByte() throws Exception {
        try (BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 53}));){
            Assertions.assertEquals((int)0, (int)stream.nextBit(), (String)"bit 0");
            Assertions.assertEquals((int)1, (int)stream.nextBit(), (String)"bit 1");
            Assertions.assertEquals((int)0, (int)stream.nextBit(), (String)"bit 2");
            Assertions.assertEquals((int)1, (int)stream.nextBit(), (String)"bit 3");
            Assertions.assertEquals((int)94, (int)stream.nextByte(), (String)"next byte");
            Assertions.assertEquals((int)-1, (int)stream.nextByte(), (String)"next byte");
        }
    }

    @Test
    public void testNextByteFromEmptyStream() throws Exception {
        try (BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY));){
            Assertions.assertEquals((int)-1, (int)stream.nextByte(), (String)"next byte");
            Assertions.assertEquals((int)-1, (int)stream.nextByte(), (String)"next byte");
        }
    }

    @Test
    public void testReadAlignedBytes() throws Exception {
        try (BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 53}));){
            Assertions.assertEquals((int)234, (int)stream.nextByte(), (String)"next byte");
            Assertions.assertEquals((int)53, (int)stream.nextByte(), (String)"next byte");
            Assertions.assertEquals((int)-1, (int)stream.nextByte(), (String)"next byte");
        }
    }

    @Test
    public void testStream() throws Exception {
        try (BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-22, 3}));){
            Assertions.assertEquals((int)0, (int)stream.nextBit(), (String)"bit 0");
            Assertions.assertEquals((int)1, (int)stream.nextBit(), (String)"bit 1");
            Assertions.assertEquals((int)0, (int)stream.nextBit(), (String)"bit 2");
            Assertions.assertEquals((int)1, (int)stream.nextBit(), (String)"bit 3");
            Assertions.assertEquals((int)0, (int)stream.nextBit(), (String)"bit 4");
            Assertions.assertEquals((int)1, (int)stream.nextBit(), (String)"bit 5");
            Assertions.assertEquals((int)1, (int)stream.nextBit(), (String)"bit 6");
            Assertions.assertEquals((int)1, (int)stream.nextBit(), (String)"bit 7");
            Assertions.assertEquals((int)1, (int)stream.nextBit(), (String)"bit 8");
            Assertions.assertEquals((int)1, (int)stream.nextBit(), (String)"bit 9");
            Assertions.assertEquals((int)0, (int)stream.nextBit(), (String)"bit 10");
            Assertions.assertEquals((int)0, (int)stream.nextBit(), (String)"bit 11");
            Assertions.assertEquals((int)0, (int)stream.nextBit(), (String)"bit 12");
            Assertions.assertEquals((int)0, (int)stream.nextBit(), (String)"bit 13");
            Assertions.assertEquals((int)0, (int)stream.nextBit(), (String)"bit 14");
            Assertions.assertEquals((int)0, (int)stream.nextBit(), (String)"bit 15");
            Assertions.assertEquals((int)-1, (int)stream.nextBit(), (String)"next bit");
        }
    }
}

