/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;

public final class Lister {
    private static void extract(Path targetDir, ZipArchiveEntry entry, InputStream inputStream) throws IOException {
        Path outputFile = entry.resolveIn(targetDir);
        Path parent = outputFile.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.copy(inputStream, outputFile, new CopyOption[0]);
    }

    private static void list(ZipArchiveEntry entry) {
        System.out.println(entry.getName());
    }

    public static void main(String[] args) throws IOException {
        CommandLine cl = Lister.parse(args);
        File f = new File(cl.archive);
        if (!f.isFile()) {
            System.err.println(f + " doesn't exists or is a directory");
            Lister.usage();
        }
        if (cl.useStream) {
            try (BufferedInputStream fs = new BufferedInputStream(Files.newInputStream(f.toPath(), new OpenOption[0]));){
                ZipArchiveInputStream zs = new ZipArchiveInputStream((InputStream)fs, cl.encoding, true, cl.allowStoredEntriesWithDataDescriptor);
                ZipArchiveEntry entry = zs.getNextEntry();
                while (entry != null) {
                    ZipArchiveEntry ze = entry;
                    Lister.list(ze);
                    if (cl.dir != null) {
                        Lister.extract(cl.dir, ze, (InputStream)zs);
                    }
                    entry = zs.getNextEntry();
                }
            }
        }
        try (ZipFile zf = ((ZipFile.Builder)((ZipFile.Builder)ZipFile.builder().setFile(f)).setCharset(cl.encoding)).get();){
            Enumeration entries = zf.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry ze = (ZipArchiveEntry)entries.nextElement();
                Lister.list(ze);
                if (cl.dir == null) continue;
                InputStream is = zf.getInputStream(ze);
                try {
                    Lister.extract(cl.dir, ze, is);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }

    private static CommandLine parse(String[] args) {
        CommandLine cl = new CommandLine();
        boolean error = false;
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            if (args[i].equals("-enc")) {
                if (argsLength > i + 1) {
                    cl.encoding = args[++i];
                    continue;
                }
                System.err.println("missing argument to -enc");
                error = true;
                continue;
            }
            if (args[i].equals("-extract")) {
                if (argsLength > i + 1) {
                    cl.dir = Paths.get(args[++i], new String[0]);
                    continue;
                }
                System.err.println("missing argument to -extract");
                error = true;
                continue;
            }
            if (args[i].equals("-stream")) {
                cl.useStream = true;
                continue;
            }
            if (args[i].equals("+storeddd")) {
                cl.allowStoredEntriesWithDataDescriptor = true;
                continue;
            }
            if (args[i].equals("-file")) {
                cl.useStream = false;
                continue;
            }
            if (cl.archive != null) {
                System.err.println("Only one archive");
                error = true;
                continue;
            }
            cl.archive = args[i];
        }
        if (error || cl.archive == null) {
            Lister.usage();
        }
        return cl;
    }

    private static void usage() {
        System.err.println("lister [-enc encoding] [-stream] [-file] [+storeddd] [-extract dir] archive");
        System.exit(1);
    }

    private static final class CommandLine {
        String archive;
        boolean useStream = false;
        String encoding;
        boolean allowStoredEntriesWithDataDescriptor = false;
        Path dir;

        private CommandLine() {
        }
    }
}

