/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Maven221MultiVolumeTest
extends AbstractTest {
    private static final String[] ENTRIES = new String[]{"apache-maven-2.2.1/", "apache-maven-2.2.1/LICENSE.txt", "apache-maven-2.2.1/NOTICE.txt", "apache-maven-2.2.1/README.txt", "apache-maven-2.2.1/bin/", "apache-maven-2.2.1/bin/m2.conf", "apache-maven-2.2.1/bin/mvn", "apache-maven-2.2.1/bin/mvn.bat", "apache-maven-2.2.1/bin/mvnDebug", "apache-maven-2.2.1/bin/mvnDebug.bat", "apache-maven-2.2.1/boot/", "apache-maven-2.2.1/boot/classworlds-1.1.jar", "apache-maven-2.2.1/conf/", "apache-maven-2.2.1/conf/settings.xml", "apache-maven-2.2.1/lib/"};
    private static final String LAST_ENTRY_NAME = "apache-maven-2.2.1/lib/maven-2.2.1-uber.jar";

    @Test
    public void testRead7ZipMultiVolumeArchiveForFile() {
        Assertions.assertThrows(IOException.class, () -> ((ZipFile.Builder)ZipFile.builder().setFile(Maven221MultiVolumeTest.getFile("apache-maven-2.2.1.zip.001"))).get());
    }

    @Test
    public void testRead7ZipMultiVolumeArchiveForStream() throws IOException {
        try (InputStream archive = Maven221MultiVolumeTest.newInputStream("apache-maven-2.2.1.zip.001");
             ZipArchiveInputStream zi = new ZipArchiveInputStream(archive, null, false);){
            for (String element : ENTRIES) {
                Assertions.assertEquals((Object)element, (Object)zi.getNextEntry().getName());
            }
            ZipArchiveEntry lastEntry = zi.getNextEntry();
            Assertions.assertEquals((Object)LAST_ENTRY_NAME, (Object)lastEntry.getName());
            byte[] buffer = new byte[4096];
            IOException e1 = (IOException)Assertions.assertThrows(IOException.class, () -> {
                while (zi.read(buffer) > 0) {
                }
            }, (String)"shouldn't be able to read from truncated entry");
            Assertions.assertEquals((Object)"Truncated ZIP file", (Object)e1.getMessage());
            IOException e2 = (IOException)Assertions.assertThrows(IOException.class, () -> zi.read(buffer), (String)"shouldn't be able to read from truncated entry after exception");
            Assertions.assertEquals((Object)"Truncated ZIP file", (Object)e2.getMessage());
            Assertions.assertThrows(IOException.class, () -> ((ZipArchiveInputStream)zi).getNextEntry(), (String)"shouldn't be able to read another entry from truncated file");
        }
    }
}

