/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.zip.DefaultBackingStoreSupplier;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequestSupplier;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.parallel.FileBasedScatterGatherBackingStore;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.parallel.ScatterGatherBackingStoreSupplier;
import org.apache.commons.compress.utils.CharsetNames;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ParallelScatterZipCreatorTest
extends AbstractTempDirTest {
    private static final long EXPECTED_FILE_SIZE = 0x100000L;
    private static final int EXPECTED_FILES_NUMBER = 50;
    private final int NUMITEMS = 5000;

    private void callableApi(CallableConsumerSupplier consumerSupplier, File result) throws Exception {
        this.callableApi(consumerSupplier, -1, result);
    }

    private void callableApi(CallableConsumerSupplier consumerSupplier, int compressionLevel, File result) throws Exception {
        Map<String, byte[]> entries;
        ParallelScatterZipCreator zipCreator;
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(result);){
            zos.setEncoding(CharsetNames.UTF_8);
            ExecutorService es = Executors.newFixedThreadPool(1);
            ScatterGatherBackingStoreSupplier supp = () -> new FileBasedScatterGatherBackingStore(this.createTempFile("parallelscatter", "n1"));
            zipCreator = new ParallelScatterZipCreator(es, supp, compressionLevel);
            entries = this.writeEntriesAsCallable(zipCreator, (CallableConsumer)consumerSupplier.apply(zipCreator));
            zipCreator.writeTo(zos);
        }
        this.removeEntriesFoundInZipFile(result, entries);
        Assertions.assertTrue((boolean)entries.isEmpty());
        Assertions.assertNotNull((Object)zipCreator.getStatisticsMessage());
    }

    private void callableApiWithTestFiles(CallableConsumerSupplier consumerSupplier, int compressionLevel, File result) throws Exception {
        Map<String, byte[]> entries;
        ParallelScatterZipCreator zipCreator;
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(result);){
            zos.setEncoding(CharsetNames.UTF_8);
            ExecutorService es = Executors.newFixedThreadPool(1);
            ScatterGatherBackingStoreSupplier supp = () -> new FileBasedScatterGatherBackingStore(this.createTempFile("parallelscatter", "n1"));
            zipCreator = new ParallelScatterZipCreator(es, supp, compressionLevel);
            entries = this.writeTestFilesAsCallable(zipCreator, (CallableConsumer)consumerSupplier.apply(zipCreator));
            zipCreator.writeTo(zos);
        }
        try (ZipFile zf = ((ZipFile.Builder)ZipFile.builder().setFile(result)).get();){
            Enumeration entriesInPhysicalOrder = zf.getEntriesInPhysicalOrder();
            while (entriesInPhysicalOrder.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)entriesInPhysicalOrder.nextElement();
                InputStream inputStream = zf.getInputStream(zipArchiveEntry);
                try {
                    byte[] actual = IOUtils.toByteArray((InputStream)inputStream);
                    byte[] expected = entries.remove(zipArchiveEntry.getName());
                    Assertions.assertArrayEquals((byte[])expected, (byte[])actual, (String)("For " + zipArchiveEntry.getName()));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        Assertions.assertNotNull((Object)zipCreator.getStatisticsMessage());
    }

    private ZipArchiveEntry createZipArchiveEntry(Map<String, byte[]> entries, int i, byte[] payloadBytes) {
        ZipArchiveEntry za = new ZipArchiveEntry("file" + i);
        entries.put(za.getName(), payloadBytes);
        za.setMethod(8);
        za.setSize((long)payloadBytes.length);
        za.setUnixMode(33204);
        return za;
    }

    private void removeEntriesFoundInZipFile(File result, Map<String, byte[]> entries) throws IOException {
        try (ZipFile zf = ((ZipFile.Builder)ZipFile.builder().setFile(result)).get();){
            Enumeration entriesInPhysicalOrder = zf.getEntriesInPhysicalOrder();
            int i = 0;
            while (entriesInPhysicalOrder.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)entriesInPhysicalOrder.nextElement();
                try (InputStream inputStream = zf.getInputStream(zipArchiveEntry);){
                    byte[] actual = IOUtils.toByteArray((InputStream)inputStream);
                    byte[] expected = entries.remove(zipArchiveEntry.getName());
                    Assertions.assertArrayEquals((byte[])expected, (byte[])actual, (String)("For " + zipArchiveEntry.getName()));
                }
                Assertions.assertEquals((Object)("file" + i++), (Object)zipArchiveEntry.getName(), (String)("For " + zipArchiveEntry.getName()));
            }
        }
    }

    @Test
    @Disabled(value="[COMPRESS-639]")
    public void sameZipArchiveEntryNullPointerException() throws IOException, ExecutionException, InterruptedException {
        ByteArrayOutputStream testOutputStream = new ByteArrayOutputStream();
        String fileContent = "A";
        int NUM_OF_FILES = 100;
        LinkedList<ByteArrayInputStream> inputStreams = new LinkedList<ByteArrayInputStream>();
        for (int i = 0; i < 100; ++i) {
            inputStreams.add(new ByteArrayInputStream("A".getBytes(StandardCharsets.UTF_8)));
        }
        ParallelScatterZipCreator zipCreator = new ParallelScatterZipCreator();
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream((OutputStream)testOutputStream);){
            zipArchiveOutputStream.setUseZip64(Zip64Mode.Always);
            for (InputStream inputStream : inputStreams) {
                ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry("./dir/myfile.txt");
                zipArchiveEntry.setMethod(8);
                zipCreator.addArchiveEntry(zipArchiveEntry, () -> inputStream);
            }
            zipCreator.writeTo(zipArchiveOutputStream);
        }
    }

    @Test
    public void testCallableApiUsingSubmit() throws Exception {
        File result = this.createTempFile("parallelScatterGather2", "");
        this.callableApi(zipCreator -> arg_0 -> ((ParallelScatterZipCreator)zipCreator).submit(arg_0), result);
    }

    @Test
    public void testCallableApiUsingSubmitStreamAwareCallable() throws Exception {
        File result = this.createTempFile("parallelScatterGather3", "");
        this.callableApi(zipCreator -> arg_0 -> ((ParallelScatterZipCreator)zipCreator).submitStreamAwareCallable(arg_0), result);
    }

    @Test
    public void testCallableApiWithHighestLevelUsingSubmitStreamAwareCallable() throws Exception {
        File result = this.createTempFile("parallelScatterGather5", "");
        this.callableApiWithTestFiles(zipCreator -> arg_0 -> ((ParallelScatterZipCreator)zipCreator).submitStreamAwareCallable(arg_0), 9, result);
    }

    @Test
    public void testCallableWithLowestLevelApiUsingSubmit() throws Exception {
        File result = this.createTempFile("parallelScatterGather4", "");
        this.callableApiWithTestFiles(zipCreator -> arg_0 -> ((ParallelScatterZipCreator)zipCreator).submit(arg_0), 0, result);
    }

    @Test
    public void testConcurrentCustomTempFolder() throws Exception {
        Map<String, byte[]> entries;
        ParallelScatterZipCreator zipCreator;
        File result = this.createTempFile("parallelScatterGather1", "");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(result);){
            zos.setEncoding(CharsetNames.UTF_8);
            Path dir = Paths.get("target/custom-temp-dir", new String[0]);
            Files.createDirectories(dir, new FileAttribute[0]);
            zipCreator = new ParallelScatterZipCreator(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()), (ScatterGatherBackingStoreSupplier)new DefaultBackingStoreSupplier(dir));
            entries = this.writeEntries(zipCreator);
            zipCreator.writeTo(zos);
        }
        this.removeEntriesFoundInZipFile(result, entries);
        Assertions.assertTrue((boolean)entries.isEmpty());
        Assertions.assertNotNull((Object)zipCreator.getStatisticsMessage());
    }

    @Test
    public void testConcurrentDefaultTempFolder() throws Exception {
        Map<String, byte[]> entries;
        ParallelScatterZipCreator zipCreator;
        File result = this.createTempFile("parallelScatterGather1", "");
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(result);){
            zos.setEncoding(CharsetNames.UTF_8);
            zipCreator = new ParallelScatterZipCreator();
            entries = this.writeEntries(zipCreator);
            zipCreator.writeTo(zos);
        }
        this.removeEntriesFoundInZipFile(result, entries);
        Assertions.assertTrue((boolean)entries.isEmpty());
        Assertions.assertNotNull((Object)zipCreator.getStatisticsMessage());
    }

    @Test
    public void testThrowsExceptionWithCompressionLevelTooBig() {
        int compressLevelTooBig = 10;
        ExecutorService es = Executors.newFixedThreadPool(1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ParallelScatterZipCreator(es, () -> new FileBasedScatterGatherBackingStore(this.createTempFile("parallelscatter", "n1")), 10));
        es.shutdownNow();
    }

    @Test
    public void testThrowsExceptionWithCompressionLevelTooSmall() {
        int compressLevelTooSmall = -2;
        ExecutorService es = Executors.newFixedThreadPool(1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ParallelScatterZipCreator(es, () -> new FileBasedScatterGatherBackingStore(this.createTempFile("parallelscatter", "n1")), -2));
        es.shutdownNow();
    }

    private Map<String, byte[]> writeEntries(ParallelScatterZipCreator zipCreator) {
        HashMap<String, byte[]> entries = new HashMap<String, byte[]>();
        for (int i = 0; i < 5000; ++i) {
            byte[] payloadBytes = ("content" + i).getBytes();
            ZipArchiveEntry za = this.createZipArchiveEntry(entries, i, payloadBytes);
            InputStreamSupplier iss = () -> new ByteArrayInputStream(payloadBytes);
            if (i % 2 == 0) {
                zipCreator.addArchiveEntry(za, iss);
                continue;
            }
            ZipArchiveEntryRequestSupplier zaSupplier = () -> ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)za, (InputStreamSupplier)iss);
            zipCreator.addArchiveEntry(zaSupplier);
        }
        return entries;
    }

    private Map<String, byte[]> writeEntriesAsCallable(ParallelScatterZipCreator zipCreator, CallableConsumer consumer) {
        HashMap<String, byte[]> entries = new HashMap<String, byte[]>();
        for (int i = 0; i < 5000; ++i) {
            Callable callable;
            byte[] payloadBytes = ("content" + i).getBytes();
            ZipArchiveEntry za = this.createZipArchiveEntry(entries, i, payloadBytes);
            InputStreamSupplier iss = () -> new ByteArrayInputStream(payloadBytes);
            if (i % 2 == 0) {
                callable = zipCreator.createCallable(za, iss);
            } else {
                ZipArchiveEntryRequestSupplier zaSupplier = () -> ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)za, (InputStreamSupplier)iss);
                callable = zipCreator.createCallable(zaSupplier);
            }
            consumer.accept(callable);
        }
        return entries;
    }

    private Map<String, byte[]> writeTestFilesAsCallable(ParallelScatterZipCreator zipCreator, CallableConsumer consumer) throws IOException {
        HashMap<String, byte[]> entries = new HashMap<String, byte[]>();
        File baseDir = AbstractTest.getFile("");
        int filesCount = 0;
        for (File file : baseDir.listFiles()) {
            Callable callable;
            if (filesCount >= 50) break;
            if (file.isDirectory() || file.length() > 0x100000L) continue;
            entries.put(file.getName(), Files.readAllBytes(file.toPath()));
            ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(file.getName());
            zipArchiveEntry.setMethod(8);
            zipArchiveEntry.setSize(file.length());
            zipArchiveEntry.setUnixMode(33204);
            InputStreamSupplier iss = () -> {
                try {
                    return Files.newInputStream(file.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    return null;
                }
            };
            if (filesCount % 2 == 0) {
                callable = zipCreator.createCallable(zipArchiveEntry, iss);
            } else {
                ZipArchiveEntryRequestSupplier zaSupplier = () -> ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zipArchiveEntry, (InputStreamSupplier)iss);
                callable = zipCreator.createCallable(zaSupplier);
            }
            consumer.accept(callable);
            ++filesCount;
        }
        return entries;
    }

    private static interface CallableConsumerSupplier
    extends Function<ParallelScatterZipCreator, CallableConsumer> {
    }

    private static interface CallableConsumer
    extends Consumer<Callable<? extends ScatterZipOutputStream>> {
    }
}

