/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.ZipShort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZipShortTest {
    @Test
    public void testClone() {
        ZipShort s1 = new ZipShort(42);
        ZipShort s2 = (ZipShort)s1.clone();
        Assertions.assertNotSame((Object)s1, (Object)s2);
        Assertions.assertEquals((Object)s1, (Object)s2);
        Assertions.assertEquals((int)s1.getValue(), (int)s2.getValue());
    }

    @Test
    public void testEquals() {
        ZipShort zs = new ZipShort(4660);
        ZipShort zs2 = new ZipShort(4660);
        ZipShort zs3 = new ZipShort(22136);
        Assertions.assertEquals((Object)zs, (Object)zs, (String)"reflexive");
        Assertions.assertEquals((Object)zs, (Object)zs2, (String)"works");
        Assertions.assertNotEquals((Object)zs, (Object)zs3, (String)"works, part two");
        Assertions.assertEquals((Object)zs2, (Object)zs, (String)"symmetric");
        Assertions.assertNotEquals(null, (Object)zs, (String)"null handling");
        Assertions.assertNotEquals((Object)zs, (Object)4660, (String)"non ZipShort handling");
    }

    @Test
    public void testFromBytes() {
        byte[] val = new byte[]{52, 18};
        ZipShort zs = new ZipShort(val);
        Assertions.assertEquals((int)4660, (int)zs.getValue(), (String)"value from bytes");
    }

    @Test
    public void testPut() {
        byte[] arr = new byte[3];
        ZipShort.putShort((int)4660, (byte[])arr, (int)1);
        Assertions.assertEquals((int)52, (int)arr[1], (String)"first byte getBytes");
        Assertions.assertEquals((int)18, (int)arr[2], (String)"second byte getBytes");
    }

    @Test
    public void testSign() {
        ZipShort zs = new ZipShort(new byte[]{-1, -1});
        Assertions.assertEquals((int)65535, (int)zs.getValue());
    }

    @Test
    public void testToBytes() {
        ZipShort zs = new ZipShort(4660);
        byte[] result = zs.getBytes();
        Assertions.assertEquals((int)2, (int)result.length, (String)"length getBytes");
        Assertions.assertEquals((int)52, (int)result[0], (String)"first byte getBytes");
        Assertions.assertEquals((int)18, (int)result[1], (String)"second byte getBytes");
    }
}

