/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate64;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.deflate64.Deflate64CompressorInputStream;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class Deflate64CompressorInputStreamTest {
    private final HuffmanDecoder nullDecoder = null;
    @Mock
    private HuffmanDecoder decoder;

    private void fuzzingTest(int[] bytes) throws IOException, ArchiveException {
        int len = bytes.length;
        byte[] input = new byte[len];
        for (int i = 0; i < len; ++i) {
            input[i] = (byte)bytes[i];
        }
        try (ArchiveInputStream ais = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("zip", (InputStream)new ByteArrayInputStream(input));){
            ais.getNextEntry();
            IOUtils.toByteArray((InputStream)ais);
        }
    }

    @Test
    public void testCloseCallsDecoder() throws Exception {
        Deflate64CompressorInputStream input = new Deflate64CompressorInputStream(this.decoder);
        input.close();
        ((HuffmanDecoder)Mockito.verify((Object)this.decoder, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testCloseIsDelegatedJustOnce() throws Exception {
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream(this.decoder);){
            input.close();
        }
        ((HuffmanDecoder)Mockito.verify((Object)this.decoder, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testDelegatesAvailable() throws Exception {
        Mockito.when((Object)this.decoder.available()).thenReturn((Object)1024);
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream(this.decoder);){
            Assertions.assertEquals((int)1024, (int)input.available());
        }
    }

    @Test
    public void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (Deflate64CompressorInputStream in = new Deflate64CompressorInputStream(this.nullDecoder);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    public void testProperSizeWhenClosed() throws Exception {
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream(this.nullDecoder);){
            Assertions.assertEquals((int)0, (int)input.available());
        }
    }

    @Test
    public void testReadWhenClosed() throws Exception {
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream(this.nullDecoder);){
            Assertions.assertEquals((int)-1, (int)input.read());
            Assertions.assertEquals((int)-1, (int)input.read(new byte[1]));
            Assertions.assertEquals((int)-1, (int)input.read(new byte[1], 0, 1));
        }
    }

    @Test
    public void testShouldThrowIOExceptionInsteadOfRuntimeExceptionCOMPRESS521() {
        Assertions.assertThrows(IOException.class, () -> this.fuzzingTest(new int[]{80, 75, 3, 4, 46, 0, 182, 0, 9, 0, 132, 182, 186, 70, 114, 0, 254, 119, 99, 0, 0, 0, 107, 0, 0, 0, 3, 0, 28, 0, 98, 98, 98, 85, 84, 12, 0, 3, 231, 206, 100, 85, 243, 206, 101, 85, 117, 120, 11, 0, 1, 4, 92, 249, 1, 0, 4, 136, 19, 0, 0, 66, 90, 104, 52}));
    }

    @Test
    public void testShouldThrowIOExceptionInsteadOfRuntimeExceptionCOMPRESS522() {
        Assertions.assertThrows(IOException.class, () -> this.fuzzingTest(new int[]{80, 75, 3, 4, 20, 0, 8, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 97, 74, 132, 2, 64, 0, 1, 0, 255, 255}));
    }

    @Test
    public void testShouldThrowIOExceptionInsteadOfRuntimeExceptionCOMPRESS525() {
        Assertions.assertThrows(IOException.class, () -> this.fuzzingTest(new int[]{80, 75, 3, 4, 20, 0, 8, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 120, 0, 97, 74, 4, 4, 0, 0, 255, 255, 80, 83, 7, 8, 67, 190, 183, 232, 7, 0, 0, 0, 1, 0, 0, 0, 80, 75, 3, 4, 20, 0, 8, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 98, 74, 2, 4, 0, 0, 255, 255, 80, 75, 127, 8, 249, 239, 190, 113, 7, 0, 0, 0, 1, 0, 0, 0, 80, 75, 3, 4, 20, 0, 8, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 99, 74, 6, 4, 0, 0, 255, 255, 80, 75, 7, 8, 111, 223}));
    }

    @Test
    public void testShouldThrowIOExceptionInsteadOfRuntimeExceptionCOMPRESS526() {
        Assertions.assertThrows(IOException.class, () -> this.fuzzingTest(new int[]{80, 75, 3, 4, 20, 0, 8, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 0, 0, 0, 97, 74, 4, 4, 0, 0, 255, 255, 80, 83, 7, 8, 67, 190, 183, 232, 7, 0, 0, 0, 1, 0, 0, 0, 80, 75, 3, 4, 20, 0, 8, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 98, 74, 2, 4, 0, 0, 255, 255, 80, 75, 127, 8, 249, 239, 190, 113, 7, 0, 0, 0, 1, 0, 0, 0, 80, 75, 3, 4, 20, 0, 8, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 99, 74, 6, 4, 0, 0, 255, 255, 80, 75, 7, 8, 1, 223, 185, 6, 7, 0, 0, 0, 1, 0, 0, 0, 80, 75, 3, 4, 20, 0, 8, 0, 8}));
    }

    @Test
    public void testShouldThrowIOExceptionInsteadOfRuntimeExceptionCOMPRESS527() {
        Assertions.assertThrows(IOException.class, () -> this.fuzzingTest(new int[]{80, 75, 3, 4, 20, 0, 0, 0, 9, 0, 132, 182, 186, 70, 114, 182, 254, 119, 74, 0, 0, 0, 107, 0, 0, 0, 3, 0, 28, 0, 98, 98, 98, 85, 84, 9, 0, 3, 231, 206, 100, 85, 243, 206, 100, 85, 117, 120, 11, 0, 1, 4, 92, 249, 1, 0, 4, 136, 19, 0, 0, 29, 139, 193, 13, 192, 48, 8, 3, 255, 153, 194, 171, 129, 80, 26, 168, 68, 30, 86, 48, 127, 33, 31, 91, 62, 157, 133, 110}));
    }

    @Test
    public void testShouldThrowsEOFExceptionOnTruncatedStreams() throws IOException {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108};
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream((InputStream)new ByteArrayInputStream(data));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)input));){
            Assertions.assertThrows(EOFException.class, () -> br.readLine());
        }
    }

    @Test
    public void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (Deflate64CompressorInputStream in = new Deflate64CompressorInputStream(this.nullDecoder);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testStreamIgnoresExtraBytesAfterDeflatedInput() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100, 88};
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream((InputStream)new ByteArrayInputStream(data));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)input));){
            Assertions.assertEquals((Object)"Hello World", (Object)br.readLine());
            Assertions.assertNull((Object)br.readLine());
        }
    }

    @Test
    public void testUncompressedBlock() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream((InputStream)new ByteArrayInputStream(data));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)input));){
            Assertions.assertEquals((Object)"Hello World", (Object)br.readLine());
            Assertions.assertNull((Object)br.readLine());
        }
    }

    @Test
    public void testUncompressedBlockAvailable() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream((InputStream)new ByteArrayInputStream(data));){
            Assertions.assertEquals((int)72, (int)input.read());
            Assertions.assertEquals((int)10, (int)input.available());
        }
    }

    @Test
    public void testUncompressedBlockViaFactory() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        try (CompressorInputStream input = new CompressorStreamFactory().createCompressorInputStream("deflate64", (InputStream)new ByteArrayInputStream(data));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)input));){
            Assertions.assertEquals((Object)"Hello World", (Object)br.readLine());
            Assertions.assertNull((Object)br.readLine());
        }
    }
}

