/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.lz4.XXHash32;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class XXHash32Test {
    public static Stream<Arguments> factory() {
        return Stream.of(Arguments.of((Object[])new Object[]{"bla.tar", "fbb5c8d1"}), Arguments.of((Object[])new Object[]{"bla.tar.xz", "4106a208"}), Arguments.of((Object[])new Object[]{"8.posix.tar.gz", "9fce116a"}));
    }

    @ParameterizedTest
    @MethodSource(value={"factory"})
    public void verifyChecksum(String fileName, String expectedChecksum) throws IOException {
        XXHash32 h = new XXHash32();
        File file = AbstractTest.getFile(fileName);
        try (InputStream s = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            byte[] b = IOUtils.toByteArray((InputStream)s);
            h.update(b, 0, b.length);
        }
        Assertions.assertEquals((Object)expectedChecksum, (Object)Long.toHexString(h.getValue()), (String)("checksum for " + file.getName()));
    }
}

