/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.compress.harmony.pack200.BHSDCodec;
import org.apache.commons.compress.harmony.pack200.CanonicalCodecFamilies;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CodecTest {
    static Stream<Arguments> bCodings() {
        return IntStream.rangeClosed(1, 5).mapToObj(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static Stream<Arguments> codecFamily() {
        return Stream.of(Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.nonDeltaUnsignedCodecs1}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.nonDeltaUnsignedCodecs2}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.nonDeltaUnsignedCodecs3}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.nonDeltaUnsignedCodecs4}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.nonDeltaUnsignedCodecs5}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.deltaUnsignedCodecs1}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.deltaUnsignedCodecs2}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.deltaUnsignedCodecs3}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.deltaUnsignedCodecs4}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.deltaUnsignedCodecs5}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.nonDeltaSignedCodecs1}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.nonDeltaSignedCodecs2}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.nonDeltaDoubleSignedCodecs1}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.deltaSignedCodecs1}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.deltaSignedCodecs2}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.deltaSignedCodecs3}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.deltaSignedCodecs4}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.deltaSignedCodecs5}), Arguments.of((Object[])new Object[]{CanonicalCodecFamilies.deltaDoubleSignedCodecs1}));
    }

    static Stream<Arguments> hCodings() {
        return IntStream.range(0, 256).mapToObj(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private long decode(Codec codec, byte[] data, long value, long last) throws IOException, Pack200Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        Assertions.assertEquals((long)value, (long)codec.decode((InputStream)in, last));
        Assertions.assertEquals((int)-1, (int)in.read());
        return value;
    }

    private void decodeFail(Codec codec, byte[] data) {
        Assertions.assertThrowsExactly(EOFException.class, () -> this.decode(codec, data, 0L, 0L), (String)"Should have detected an EOFException");
    }

    @ParameterizedTest
    @MethodSource(value={"bCodings"})
    public void testBCodings(int i) {
        if (i == 5) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new BHSDCodec(i, 256));
        } else {
            Assertions.assertDoesNotThrow(() -> new BHSDCodec(i, 256));
        }
    }

    @Test
    public void testByte1() throws Exception {
        for (int i = 0; i < 255; ++i) {
            this.decode((Codec)Codec.BYTE1, new byte[]{(byte)i}, i, 0L);
        }
    }

    @Test
    public void testByte1Delta() throws Exception {
        BHSDCodec BYTE1D = new BHSDCodec(1, 256, 0, 1);
        long last = 0L;
        for (int i = 1; i < 255; ++i) {
            last = this.decode((Codec)BYTE1D, new byte[]{1}, i, last);
        }
    }

    @Test
    public void testByte1DeltaException() throws Exception {
        BHSDCodec BYTE1D = new BHSDCodec(1, 256, 0, 1);
        Assertions.assertThrows(Pack200Exception.class, () -> CodecTest.lambda$testByte1DeltaException$5((Codec)BYTE1D), (String)"Decoding with a delta stream and not passing a last value should throw an exception");
    }

    @Test
    public void testByte1Signed() throws Exception {
        BHSDCodec BYTE1S2 = new BHSDCodec(1, 256, 2);
        this.decode((Codec)BYTE1S2, new byte[]{0}, 0L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{1}, 1L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{2}, 2L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{3}, -1L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{4}, 3L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{5}, 4L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{6}, 5L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{7}, -2L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{8}, 6L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{9}, 7L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{10}, 8L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{11}, -3L, 0L);
    }

    @Test
    public void testCardinality() {
        BHSDCodec byte1 = Codec.BYTE1;
        Assertions.assertEquals((long)256L, (long)byte1.cardinality());
        Assertions.assertEquals((long)0L, (long)byte1.smallest());
        Assertions.assertEquals((long)255L, (long)byte1.largest());
        Assertions.assertFalse((boolean)byte1.encodes(-257L));
        Assertions.assertFalse((boolean)byte1.encodes(-256L));
        Assertions.assertFalse((boolean)byte1.encodes(-255L));
        Assertions.assertFalse((boolean)byte1.encodes(-129L));
        Assertions.assertFalse((boolean)byte1.encodes(-128L));
        Assertions.assertFalse((boolean)byte1.encodes(-127L));
        Assertions.assertFalse((boolean)byte1.encodes(-1L));
        Assertions.assertTrue((boolean)byte1.encodes(0L));
        Assertions.assertTrue((boolean)byte1.encodes(1L));
        Assertions.assertTrue((boolean)byte1.encodes(255L));
        Assertions.assertFalse((boolean)byte1.encodes(256L));
        BHSDCodec byte1s = new BHSDCodec(1, 256, 1);
        Assertions.assertEquals((long)256L, (long)byte1s.cardinality());
        Assertions.assertEquals((long)-128L, (long)byte1s.smallest());
        Assertions.assertEquals((long)127L, (long)byte1s.largest());
        Assertions.assertFalse((boolean)byte1s.encodes(-257L));
        Assertions.assertFalse((boolean)byte1s.encodes(-256L));
        Assertions.assertFalse((boolean)byte1s.encodes(-255L));
        Assertions.assertFalse((boolean)byte1s.encodes(-129L));
        Assertions.assertTrue((boolean)byte1s.encodes(-128L));
        Assertions.assertTrue((boolean)byte1s.encodes(-127L));
        Assertions.assertTrue((boolean)byte1s.encodes(-1L));
        Assertions.assertTrue((boolean)byte1s.encodes(0L));
        Assertions.assertTrue((boolean)byte1s.encodes(1L));
        Assertions.assertTrue((boolean)byte1s.encodes(127L));
        Assertions.assertFalse((boolean)byte1s.encodes(128L));
        Assertions.assertFalse((boolean)byte1s.encodes(129L));
        Assertions.assertFalse((boolean)byte1s.encodes(255L));
        Assertions.assertFalse((boolean)byte1s.encodes(256L));
        BHSDCodec byte2s = new BHSDCodec(1, 256, 2);
        Assertions.assertEquals((long)256L, (long)byte2s.cardinality());
        Assertions.assertEquals((long)-64L, (long)byte2s.smallest());
        Assertions.assertEquals((long)191L, (long)byte2s.largest());
        Assertions.assertFalse((boolean)byte2s.encodes(-257L));
        Assertions.assertFalse((boolean)byte2s.encodes(-256L));
        Assertions.assertFalse((boolean)byte2s.encodes(-255L));
        Assertions.assertFalse((boolean)byte2s.encodes(-129L));
        Assertions.assertFalse((boolean)byte2s.encodes(-128L));
        Assertions.assertFalse((boolean)byte2s.encodes(-127L));
        Assertions.assertFalse((boolean)byte2s.encodes(-65L));
        Assertions.assertTrue((boolean)byte2s.encodes(-64L));
        Assertions.assertTrue((boolean)byte2s.encodes(-64L));
        Assertions.assertTrue((boolean)byte2s.encodes(-1L));
        Assertions.assertTrue((boolean)byte2s.encodes(0L));
        Assertions.assertTrue((boolean)byte2s.encodes(1L));
        Assertions.assertTrue((boolean)byte2s.encodes(127L));
        Assertions.assertTrue((boolean)byte2s.encodes(128L));
        Assertions.assertTrue((boolean)byte2s.encodes(191L));
        Assertions.assertFalse((boolean)byte2s.encodes(192L));
        Assertions.assertFalse((boolean)byte2s.encodes(256L));
    }

    @ParameterizedTest
    @MethodSource(value={"codecFamily"})
    public void testCodecFamilies(BHSDCodec[] family) {
        for (int i = 1; i < family.length; ++i) {
            BHSDCodec previous = family[i - 1];
            BHSDCodec codec = family[i];
            Assertions.assertTrue((codec.largest() >= previous.largest() ? 1 : 0) != 0);
            Assertions.assertTrue((codec.smallest() <= previous.smallest() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCodecToString() {
        Assertions.assertEquals((Object)"(1,256)", (Object)Codec.BYTE1.toString());
        Assertions.assertEquals((Object)"(3,128)", (Object)Codec.CHAR3.toString());
        Assertions.assertEquals((Object)"(5,4)", (Object)Codec.BCI5.toString());
        Assertions.assertEquals((Object)"(5,4,2)", (Object)Codec.BRANCH5.toString());
        Assertions.assertEquals((Object)"(5,64)", (Object)Codec.UNSIGNED5.toString());
        Assertions.assertEquals((Object)"(5,64,1)", (Object)Codec.SIGNED5.toString());
        Assertions.assertEquals((Object)"(5,64,0,1)", (Object)Codec.UDELTA5.toString());
        Assertions.assertEquals((Object)"(5,64,1,1)", (Object)Codec.DELTA5.toString());
        Assertions.assertEquals((Object)"(5,64,2,1)", (Object)Codec.MDELTA5.toString());
        Assertions.assertEquals((Object)"(5,64)", (Object)Codec.UNSIGNED5.toString());
        Assertions.assertEquals((Object)"(5,64,1)", (Object)Codec.SIGNED5.toString());
        Assertions.assertEquals((Object)"(5,64,1,1)", (Object)Codec.DELTA5.toString());
        Assertions.assertEquals((Object)"(5,64,2,1)", (Object)Codec.MDELTA5.toString());
    }

    @ParameterizedTest
    @MethodSource(value={"hCodings"})
    public void testInvalidHCodings(int i) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BHSDCodec(1, i), (String)"b=1 -> h=256");
    }

    @Test
    public void testUnsigned5() throws Exception {
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{1}, 1L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-65}, 191L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, 0}, 192L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-63, 0}, 193L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-1, 0}, 255L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, 1}, 256L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, 5}, 512L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, 13}, 1024L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, 29}, 2048L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-1, -65}, 12479L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, -64, 0}, 12480L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-1, -1, -65}, 798911L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, -64, -64, 0}, 798912L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-1, -1, -1, -65}, 51130559L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, -64, -64, -64, 0}, 0x30C30C0L, 0L);
        this.decodeFail((Codec)Codec.UNSIGNED5, new byte[]{-64});
        this.decodeFail((Codec)Codec.UNSIGNED5, new byte[]{-64, -64});
        this.decodeFail((Codec)Codec.UNSIGNED5, new byte[]{-64, -64, -64});
        this.decodeFail((Codec)Codec.UNSIGNED5, new byte[]{-64, -64, -64, -64});
    }

    private static /* synthetic */ void lambda$testByte1DeltaException$5(Codec BYTE1D) throws Throwable {
        BYTE1D.decode((InputStream)new ByteArrayInputStream(new byte[]{1}));
    }
}

