/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200;

import java.util.stream.Stream;
import org.apache.commons.compress.harmony.unpack200.IcTuple;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ICTupleTest {
    static Stream<Arguments> explicit() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Foo$$2$Local", null, "$2$Local", "$2$Local", "Foo$$2"}), Arguments.of((Object[])new Object[]{"Red$Herring", "Red$Herring", null, "Herring", "Red$Herring"}), Arguments.of((Object[])new Object[]{"X$1$Q", "X$1", "Q", "Q", "X$1"}));
    }

    static Stream<Arguments> predicted() {
        return Stream.of(Arguments.of((Object[])new Object[]{"orw/SimpleHelloWorld$SimpleHelloWorldInner", "SimpleHelloWorldInner", "orw/SimpleHelloWorld"}), Arguments.of((Object[])new Object[]{"java/util/AbstractList$2$Local", "Local", "java/util/AbstractList$2"}), Arguments.of((Object[])new Object[]{"java/util/AbstractList#2#Local", "Local", "java/util/AbstractList$2"}), Arguments.of((Object[])new Object[]{"java/util/AbstractList$1", "1", "java/util/AbstractList"}));
    }

    @ParameterizedTest
    @MethodSource(value={"explicit"})
    public void testExplicitClassTupleParsing(String c, String c2, String n, String expectedSimpleClassName, String expectedOuterClass) {
        IcTuple tuple = new IcTuple(c, 65536, c2, n, -1, -1, -1, -1);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)expectedSimpleClassName, (Object)tuple.simpleClassName()), () -> Assertions.assertEquals((Object)expectedOuterClass, (Object)tuple.outerClassString())});
    }

    @ParameterizedTest
    @MethodSource(value={"predicted"})
    public void testPredictedClassTupleParsing(String c, String expectedSimpleClass, String expectedOuterClass) {
        IcTuple tuple = new IcTuple(c, 0, null, null, -1, -1, -1, -1);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)expectedSimpleClass, (Object)tuple.simpleClassName()), () -> Assertions.assertEquals((Object)expectedOuterClass, (Object)tuple.outerClassString())});
    }
}

