/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.pack200;

import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.pack200.Pack200Utils;
import org.junit.jupiter.api.Test;

public final class Pack200UtilsTest
extends AbstractTest {
    @Test
    public void testNormalize() throws Throwable {
        File input = Pack200UtilsTest.getFile("bla.jar");
        File output = this.createTempFile();
        Pack200Utils.normalize((File)input, (File)output, new HashMap());
        try (InputStream is = Files.newInputStream(output.toPath(), new OpenOption[0]);
             ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", is);){
            ArchiveEntry entry = in.getNextEntry();
            while (entry != null) {
                File archiveEntry = this.newTempFile(entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    entry = in.getNextEntry();
                    continue;
                }
                Files.copy((InputStream)in, archiveEntry.toPath(), new CopyOption[0]);
                entry = in.getNextEntry();
            }
        }
    }

    @Test
    public void testNormalizeInPlace() throws Throwable {
        File input = Pack200UtilsTest.getFile("bla.jar");
        File output = this.createTempFile();
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            Files.copy(is, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        Pack200Utils.normalize((File)output);
        is = Files.newInputStream(output.toPath(), new OpenOption[0]);
        try (ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", is);){
            ArchiveEntry entry = in.getNextEntry();
            while (entry != null) {
                File archiveEntry = this.newTempFile(entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    entry = in.getNextEntry();
                    continue;
                }
                Files.copy((InputStream)in, archiveEntry.toPath(), new CopyOption[0]);
                entry = in.getNextEntry();
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

