/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.z;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZCompressorInputStreamTest {
    @Test
    public void testFailsToCreateZCompressorInputStreamAndThrowsIOException() {
        SequenceInputStream sequenceInputStream = new SequenceInputStream(Collections.emptyEnumeration());
        Assertions.assertThrows(IOException.class, () -> new ZCompressorInputStream((InputStream)sequenceInputStream));
    }

    @Test
    public void testInvalidMaxCodeSize() throws IOException {
        byte[] bytes = AbstractTest.readAllBytes("bla.tar.Z");
        IntStream[] invalid = new IntStream[]{IntStream.range(-128, -120), IntStream.range(-97, -88), IntStream.range(-65, -56), IntStream.range(-33, -24), IntStream.range(-1, 8), IntStream.range(31, 40), IntStream.range(63, 72), IntStream.range(95, 104), IntStream.range(127, 127)};
        Stream.of(invalid).forEach(ints -> ints.forEach(i -> {
            bytes[2] = (byte)i;
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ZCompressorInputStream((InputStream)new ByteArrayInputStream(bytes), 0x100000), () -> "value=" + i);
        }));
    }

    @Test
    public void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = AbstractTest.getFile("bla.tar.Z");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZCompressorInputStream in = new ZCompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    public void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = AbstractTest.getFile("bla.tar.Z");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZCompressorInputStream in = new ZCompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }
}

