/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.compress.harmony.pack200.AttributeDefinitionBands;
import org.apache.commons.compress.harmony.pack200.CPUTF8;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.CpBands;
import org.apache.commons.compress.harmony.pack200.NewAttribute;
import org.apache.commons.compress.harmony.pack200.NewAttributeBands;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.pack200.SegmentHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class NewAttributeBandsTest {
    @Test
    public void testAddAttributes() throws IOException, Pack200Exception {
        CPUTF8 name = new CPUTF8("TestAttribute");
        CPUTF8 layout = new CPUTF8("B");
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(1, null, null, new AttributeDefinitionBands.AttributeDefinition(35, 0, name, layout));
        newAttributeBands.addAttribute(new NewAttribute(null, "TestAttribute", "B", new byte[]{27}, null, 0, null));
        newAttributeBands.addAttribute(new NewAttribute(null, "TestAttribute", "B", new byte[]{56}, null, 0, null));
        newAttributeBands.addAttribute(new NewAttribute(null, "TestAttribute", "B", new byte[]{3}, null, 0, null));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        newAttributeBands.pack(out);
        byte[] bytes = out.toByteArray();
        Assertions.assertEquals((int)3, (int)bytes.length);
        Assertions.assertEquals((int)27, (int)bytes[0]);
        Assertions.assertEquals((int)56, (int)bytes[1]);
        Assertions.assertEquals((int)3, (int)bytes[2]);
    }

    @Test
    public void testAddAttributesWithReplicationLayout() throws IOException, Pack200Exception {
        CPUTF8 name = new CPUTF8("TestAttribute");
        CPUTF8 layout = new CPUTF8("NB[SH]");
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(1, null, null, new AttributeDefinitionBands.AttributeDefinition(35, 0, name, layout));
        newAttributeBands.addAttribute(new NewAttribute(null, "TestAttribute", "B", new byte[]{1, 0, 100}, null, 0, null));
        int s = -50;
        int b1 = -1;
        int b2 = -50;
        newAttributeBands.addAttribute(new NewAttribute(null, "TestAttribute", "B", new byte[]{3, 0, 5, 0, 25, -1, -50}, null, 0, null));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        newAttributeBands.pack(out);
        byte[] bytes = out.toByteArray();
        Assertions.assertEquals((int)1, (int)bytes[0]);
        Assertions.assertEquals((int)3, (int)bytes[1]);
        byte[] band = new byte[bytes.length - 2];
        System.arraycopy(bytes, 2, band, 0, band.length);
        int[] decoded = Codec.SIGNED5.decodeInts(4, (InputStream)new ByteArrayInputStream(band));
        Assertions.assertEquals((int)4, (int)decoded.length);
        Assertions.assertEquals((int)100, (int)decoded[0]);
        Assertions.assertEquals((int)5, (int)decoded[1]);
        Assertions.assertEquals((int)25, (int)decoded[2]);
        Assertions.assertEquals((int)-50, (int)decoded[3]);
    }

    @Test
    public void testEmptyLayout() throws IOException {
        CPUTF8 name = new CPUTF8("TestAttribute");
        CPUTF8 layout = new CPUTF8("");
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(1, null, null, new AttributeDefinitionBands.AttributeDefinition(35, 0, name, layout));
        List<NewAttributeBands.AttributeLayoutElement> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)0, (int)layoutElements.size());
    }

    @ParameterizedTest
    @ValueSource(strings={"B", "FB", "SB", "H", "FH", "SH", "I", "FI", "SI", "PB", "OB", "OSB", "POB", "PH", "OH", "OSH", "POH", "PI", "OI", "OSI", "POI"})
    public void testIntegralLayouts(String layoutStr) throws IOException {
        CPUTF8 name = new CPUTF8("TestAttribute");
        CPUTF8 layout = new CPUTF8(layoutStr);
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(1, null, null, new AttributeDefinitionBands.AttributeDefinition(35, 0, name, layout));
        List<NewAttributeBands.AttributeLayoutElement> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Integral element = (NewAttributeBands.Integral)layoutElements.get(0);
        Assertions.assertEquals((Object)layoutStr, (Object)element.getTag());
    }

    @Test
    public void testLayoutWithBackwardsCalls() throws Exception {
        CPUTF8 name = new CPUTF8("TestAttribute");
        CPUTF8 layout = new CPUTF8("[NH[(1)]][KIH][(-1)]");
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(1, null, null, new AttributeDefinitionBands.AttributeDefinition(35, 0, name, layout));
        List<NewAttributeBands.AttributeLayoutElement> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)3, (int)layoutElements.size());
        NewAttributeBands.Callable firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        NewAttributeBands.Callable secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        NewAttributeBands.Callable thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        List thirdBody = thirdCallable.getBody();
        Assertions.assertEquals((int)1, (int)thirdBody.size());
        NewAttributeBands.Call call = (NewAttributeBands.Call)thirdBody.get(0);
        Assertions.assertEquals((Object)secondCallable, (Object)call.getCallable());
        Assertions.assertTrue((boolean)secondCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)firstCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)thirdCallable.isBackwardsCallable());
        name = new CPUTF8("TestAttribute");
        layout = new CPUTF8("[NH[(1)]][KIH][(-2)]");
        newAttributeBands = new MockNewAttributeBands(1, null, null, new AttributeDefinitionBands.AttributeDefinition(35, 0, name, layout));
        layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)3, (int)layoutElements.size());
        firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        thirdBody = thirdCallable.getBody();
        Assertions.assertEquals((int)1, (int)thirdBody.size());
        call = (NewAttributeBands.Call)thirdBody.get(0);
        Assertions.assertEquals((Object)firstCallable, (Object)call.getCallable());
        Assertions.assertTrue((boolean)firstCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)secondCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)thirdCallable.isBackwardsCallable());
        name = new CPUTF8("TestAttribute");
        layout = new CPUTF8("[NH[(1)]][KIH][(0)]");
        newAttributeBands = new MockNewAttributeBands(1, null, null, new AttributeDefinitionBands.AttributeDefinition(35, 0, name, layout));
        layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)3, (int)layoutElements.size());
        firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        thirdBody = thirdCallable.getBody();
        Assertions.assertEquals((int)1, (int)thirdBody.size());
        call = (NewAttributeBands.Call)thirdBody.get(0);
        Assertions.assertEquals((Object)thirdCallable, (Object)call.getCallable());
        Assertions.assertTrue((boolean)thirdCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)firstCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)secondCallable.isBackwardsCallable());
    }

    @Test
    public void testLayoutWithCalls() throws IOException {
        CPUTF8 name = new CPUTF8("TestAttribute");
        CPUTF8 layout = new CPUTF8("[NH[(1)]][RSH NH[RUH(1)]][TB(66,67,73,83,90)[KIH](68)[KDH](70)[KFH](74)[KJH](99)[RSH](101)[RSH RUH](115)[RUH](91)[NH[(0)]](64)[RSH[RUH(0)]]()[]]");
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(1, null, null, new AttributeDefinitionBands.AttributeDefinition(35, 0, name, layout));
        List<NewAttributeBands.AttributeLayoutElement> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)3, (int)layoutElements.size());
        NewAttributeBands.Callable firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        NewAttributeBands.Callable secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        NewAttributeBands.Callable thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        List firstBody = firstCallable.getBody();
        Assertions.assertEquals((int)1, (int)firstBody.size());
        NewAttributeBands.Replication rep = (NewAttributeBands.Replication)firstBody.get(0);
        List repBody = rep.getLayoutElements();
        Assertions.assertEquals((int)1, (int)repBody.size());
        NewAttributeBands.Call call = (NewAttributeBands.Call)repBody.get(0);
        Assertions.assertEquals((int)1, (int)call.getCallableIndex());
        Assertions.assertEquals((Object)secondCallable, (Object)call.getCallable());
        Assertions.assertFalse((boolean)firstCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)secondCallable.isBackwardsCallable());
        Assertions.assertFalse((boolean)thirdCallable.isBackwardsCallable());
    }

    @ParameterizedTest
    @ValueSource(strings={"KIB", "KIH", "KII", "KINH", "KJH", "KDH", "KSH", "KQH", "RCH", "RSH", "RDH", "RFH", "RMH", "RIH", "RUH", "RQH", "RQNH", "RQNI"})
    public void testReferenceLayouts(String layoutStr) throws IOException {
        CPUTF8 name = new CPUTF8("TestAttribute");
        CPUTF8 layout = new CPUTF8(layoutStr);
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(1, null, null, new AttributeDefinitionBands.AttributeDefinition(35, 0, name, layout));
        List<NewAttributeBands.AttributeLayoutElement> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Reference element = (NewAttributeBands.Reference)layoutElements.get(0);
        Assertions.assertEquals((Object)layoutStr, (Object)element.getTag());
    }

    @Test
    public void testReplicationLayouts() throws IOException {
        CPUTF8 name = new CPUTF8("TestAttribute");
        CPUTF8 layout = new CPUTF8("NH[PHOHRUHRSHH]");
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(1, null, null, new AttributeDefinitionBands.AttributeDefinition(35, 0, name, layout));
        List<NewAttributeBands.AttributeLayoutElement> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Replication element = (NewAttributeBands.Replication)layoutElements.get(0);
        NewAttributeBands.Integral countElement = element.getCountElement();
        Assertions.assertEquals((Object)"H", (Object)countElement.getTag());
        List replicatedElements = element.getLayoutElements();
        Assertions.assertEquals((int)5, (int)replicatedElements.size());
        NewAttributeBands.Integral firstElement = (NewAttributeBands.Integral)replicatedElements.get(0);
        Assertions.assertEquals((Object)"PH", (Object)firstElement.getTag());
        NewAttributeBands.Integral secondElement = (NewAttributeBands.Integral)replicatedElements.get(1);
        Assertions.assertEquals((Object)"OH", (Object)secondElement.getTag());
        NewAttributeBands.Reference thirdElement = (NewAttributeBands.Reference)replicatedElements.get(2);
        Assertions.assertEquals((Object)"RUH", (Object)thirdElement.getTag());
        NewAttributeBands.Reference fourthElement = (NewAttributeBands.Reference)replicatedElements.get(3);
        Assertions.assertEquals((Object)"RSH", (Object)fourthElement.getTag());
        NewAttributeBands.Integral fifthElement = (NewAttributeBands.Integral)replicatedElements.get(4);
        Assertions.assertEquals((Object)"H", (Object)fifthElement.getTag());
    }

    @Test
    public void testUnionLayout() throws IOException {
        CPUTF8 name = new CPUTF8("TestAttribute");
        CPUTF8 layout = new CPUTF8("TB(55)[FH](23)[]()[RSH]");
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(1, null, null, new AttributeDefinitionBands.AttributeDefinition(35, 0, name, layout));
        List<NewAttributeBands.AttributeLayoutElement> layoutElements = newAttributeBands.getLayoutElements();
        Assertions.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Union element = (NewAttributeBands.Union)layoutElements.get(0);
        NewAttributeBands.Integral tag = element.getUnionTag();
        Assertions.assertEquals((Object)"B", (Object)tag.getTag());
        List unionCases = element.getUnionCases();
        Assertions.assertEquals((int)2, (int)unionCases.size());
        NewAttributeBands.UnionCase firstCase = (NewAttributeBands.UnionCase)unionCases.get(0);
        Assertions.assertTrue((boolean)firstCase.hasTag(55L));
        Assertions.assertFalse((boolean)firstCase.hasTag(23L));
        List body = firstCase.getBody();
        Assertions.assertEquals((int)1, (int)body.size());
        NewAttributeBands.Integral bodyElement = (NewAttributeBands.Integral)body.get(0);
        Assertions.assertEquals((Object)"FH", (Object)bodyElement.getTag());
        NewAttributeBands.UnionCase secondCase = (NewAttributeBands.UnionCase)unionCases.get(1);
        Assertions.assertTrue((boolean)secondCase.hasTag(23L));
        Assertions.assertFalse((boolean)secondCase.hasTag(55L));
        body = secondCase.getBody();
        Assertions.assertEquals((int)0, (int)body.size());
        List defaultBody = element.getDefaultCaseBody();
        Assertions.assertEquals((int)1, (int)defaultBody.size());
        NewAttributeBands.Reference ref = (NewAttributeBands.Reference)defaultBody.get(0);
        Assertions.assertEquals((Object)"RSH", (Object)ref.getTag());
    }

    private final class MockNewAttributeBands
    extends NewAttributeBands {
        MockNewAttributeBands(int effort, CpBands cpBands, SegmentHeader header, AttributeDefinitionBands.AttributeDefinition def) throws IOException {
            super(effort, cpBands, header, def);
        }

        public List<NewAttributeBands.AttributeLayoutElement> getLayoutElements() {
            return this.attributeLayoutElements;
        }
    }
}

