/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200;

import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.unpack200.AttributeLayout;
import org.apache.commons.compress.harmony.unpack200.AttributeLayoutMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AttributeLayoutMapTest {
    @Test
    public void testRepeatable() throws Pack200Exception {
        AttributeLayoutMap a = new AttributeLayoutMap();
        AttributeLayout layout = a.getAttributeLayout("SourceFile", 0);
        Assertions.assertNotNull((Object)layout);
        Assertions.assertEquals((Object)"RUNH", (Object)layout.getLayout());
        Assertions.assertEquals((int)17, (int)layout.getIndex());
        a.add(new AttributeLayout("SourceFile", 0, "FROG", 17));
        layout = a.getAttributeLayout("SourceFile", 0);
        Assertions.assertNotNull((Object)layout);
        Assertions.assertEquals((Object)"FROG", (Object)layout.getLayout());
        Assertions.assertTrue((boolean)layout.matches(131072L));
        Assertions.assertFalse((boolean)layout.matches(65536L));
        Assertions.assertTrue((boolean)layout.matches(-1L));
        Assertions.assertFalse((boolean)layout.matches(0L));
        AttributeLayoutMap b = new AttributeLayoutMap();
        layout = b.getAttributeLayout("SourceFile", 0);
        Assertions.assertNotNull((Object)layout);
        Assertions.assertEquals((Object)"RUNH", (Object)layout.getLayout());
    }
}

