/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.compress.archivers.zip.Zip64RequiredException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipConstants;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZipClassCoverageTest {
    @Test
    public void testConstantConstructor() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<ZipConstants> clazz = ZipConstants.class;
        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
        Assertions.assertFalse((boolean)constructor.isAccessible());
        constructor.setAccessible(true);
        Object o = constructor.newInstance(new Object[0]);
        MatcherAssert.assertThat(o, (Matcher)IsInstanceOf.instanceOf(clazz));
        constructor.setAccessible(false);
    }

    @Test
    public void testConstructZip64RequiredException() {
        Zip64RequiredException e = new Zip64RequiredException("critique of pure");
        Assertions.assertNotNull((Object)e);
    }

    @Test
    public void testMessageException() {
        ZipArchiveEntry ze = new ZipArchiveEntry("hello");
        String entryTooBigMessage = Zip64RequiredException.getEntryTooBigMessage((ZipArchiveEntry)ze);
        Assertions.assertEquals((Object)"hello's size exceeds the limit of 4GByte.", (Object)entryTooBigMessage);
    }
}

