/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GzipUtilsTest {
    @Test
    public void testGetCompressedFilename() {
        Assertions.assertEquals((Object)".gz", (Object)GzipUtils.getCompressedFilename((String)""));
        Assertions.assertEquals((Object)".gz", (Object)GzipUtils.getCompressedFileName((String)""));
        Assertions.assertEquals((Object)"x.gz", (Object)GzipUtils.getCompressedFilename((String)"x"));
        Assertions.assertEquals((Object)"x.gz", (Object)GzipUtils.getCompressedFileName((String)"x"));
        Assertions.assertEquals((Object)"x.tgz", (Object)GzipUtils.getCompressedFilename((String)"x.tar"));
        Assertions.assertEquals((Object)"x.tgz", (Object)GzipUtils.getCompressedFileName((String)"x.tar"));
        Assertions.assertEquals((Object)"x.svgz", (Object)GzipUtils.getCompressedFilename((String)"x.svg"));
        Assertions.assertEquals((Object)"x.svgz", (Object)GzipUtils.getCompressedFileName((String)"x.svg"));
        Assertions.assertEquals((Object)"x.cpgz", (Object)GzipUtils.getCompressedFilename((String)"x.cpio"));
        Assertions.assertEquals((Object)"x.cpgz", (Object)GzipUtils.getCompressedFileName((String)"x.cpio"));
        Assertions.assertEquals((Object)"x.wmz", (Object)GzipUtils.getCompressedFilename((String)"x.wmf"));
        Assertions.assertEquals((Object)"x.wmz", (Object)GzipUtils.getCompressedFileName((String)"x.wmf"));
        Assertions.assertEquals((Object)"x.emz", (Object)GzipUtils.getCompressedFilename((String)"x.emf"));
        Assertions.assertEquals((Object)"x.emz", (Object)GzipUtils.getCompressedFileName((String)"x.emf"));
        Assertions.assertEquals((Object)"x.svgz", (Object)GzipUtils.getCompressedFilename((String)"x.SVG"));
        Assertions.assertEquals((Object)"x.svgz", (Object)GzipUtils.getCompressedFileName((String)"x.SVG"));
        Assertions.assertEquals((Object)"X.svgz", (Object)GzipUtils.getCompressedFilename((String)"X.SVG"));
        Assertions.assertEquals((Object)"X.svgz", (Object)GzipUtils.getCompressedFileName((String)"X.SVG"));
        Assertions.assertEquals((Object)"X.svgz", (Object)GzipUtils.getCompressedFilename((String)"X.svG"));
        Assertions.assertEquals((Object)"X.svgz", (Object)GzipUtils.getCompressedFileName((String)"X.svG"));
        Assertions.assertEquals((Object)"x.wmf .gz", (Object)GzipUtils.getCompressedFilename((String)"x.wmf "));
        Assertions.assertEquals((Object)"x.wmf .gz", (Object)GzipUtils.getCompressedFileName((String)"x.wmf "));
        Assertions.assertEquals((Object)"x.wmf\n.gz", (Object)GzipUtils.getCompressedFilename((String)"x.wmf\n"));
        Assertions.assertEquals((Object)"x.wmf\n.gz", (Object)GzipUtils.getCompressedFileName((String)"x.wmf\n"));
        Assertions.assertEquals((Object)"x.wmf.y.gz", (Object)GzipUtils.getCompressedFilename((String)"x.wmf.y"));
        Assertions.assertEquals((Object)"x.wmf.y.gz", (Object)GzipUtils.getCompressedFileName((String)"x.wmf.y"));
    }

    @Test
    public void testGetUncompressedFilename() {
        Assertions.assertEquals((Object)"", (Object)GzipUtils.getUncompressedFilename((String)""));
        Assertions.assertEquals((Object)"", (Object)GzipUtils.getUncompressedFileName((String)""));
        Assertions.assertEquals((Object)".gz", (Object)GzipUtils.getUncompressedFilename((String)".gz"));
        Assertions.assertEquals((Object)".gz", (Object)GzipUtils.getUncompressedFileName((String)".gz"));
        Assertions.assertEquals((Object)"x.tar", (Object)GzipUtils.getUncompressedFilename((String)"x.tgz"));
        Assertions.assertEquals((Object)"x.tar", (Object)GzipUtils.getUncompressedFileName((String)"x.tgz"));
        Assertions.assertEquals((Object)"x.tar", (Object)GzipUtils.getUncompressedFilename((String)"x.taz"));
        Assertions.assertEquals((Object)"x.tar", (Object)GzipUtils.getUncompressedFileName((String)"x.taz"));
        Assertions.assertEquals((Object)"x.svg", (Object)GzipUtils.getUncompressedFilename((String)"x.svgz"));
        Assertions.assertEquals((Object)"x.svg", (Object)GzipUtils.getUncompressedFileName((String)"x.svgz"));
        Assertions.assertEquals((Object)"x.cpio", (Object)GzipUtils.getUncompressedFilename((String)"x.cpgz"));
        Assertions.assertEquals((Object)"x.cpio", (Object)GzipUtils.getUncompressedFileName((String)"x.cpgz"));
        Assertions.assertEquals((Object)"x.wmf", (Object)GzipUtils.getUncompressedFilename((String)"x.wmz"));
        Assertions.assertEquals((Object)"x.wmf", (Object)GzipUtils.getUncompressedFileName((String)"x.wmz"));
        Assertions.assertEquals((Object)"x.emf", (Object)GzipUtils.getUncompressedFilename((String)"x.emz"));
        Assertions.assertEquals((Object)"x.emf", (Object)GzipUtils.getUncompressedFileName((String)"x.emz"));
        Assertions.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFilename((String)"x.gz"));
        Assertions.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFileName((String)"x.gz"));
        Assertions.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFilename((String)"x.z"));
        Assertions.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFileName((String)"x.z"));
        Assertions.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFilename((String)"x-gz"));
        Assertions.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFileName((String)"x-gz"));
        Assertions.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFilename((String)"x-z"));
        Assertions.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFileName((String)"x-z"));
        Assertions.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFilename((String)"x_z"));
        Assertions.assertEquals((Object)"x", (Object)GzipUtils.getUncompressedFileName((String)"x_z"));
        Assertions.assertEquals((Object)"x.svg", (Object)GzipUtils.getUncompressedFilename((String)"x.SVGZ"));
        Assertions.assertEquals((Object)"x.svg", (Object)GzipUtils.getUncompressedFileName((String)"x.SVGZ"));
        Assertions.assertEquals((Object)"X.svg", (Object)GzipUtils.getUncompressedFilename((String)"X.SVGZ"));
        Assertions.assertEquals((Object)"X.svg", (Object)GzipUtils.getUncompressedFileName((String)"X.SVGZ"));
        Assertions.assertEquals((Object)"X.svg", (Object)GzipUtils.getUncompressedFilename((String)"X.svGZ"));
        Assertions.assertEquals((Object)"X.svg", (Object)GzipUtils.getUncompressedFileName((String)"X.svGZ"));
        Assertions.assertEquals((Object)"x.wmz ", (Object)GzipUtils.getUncompressedFilename((String)"x.wmz "));
        Assertions.assertEquals((Object)"x.wmz ", (Object)GzipUtils.getUncompressedFileName((String)"x.wmz "));
        Assertions.assertEquals((Object)"x.wmz\n", (Object)GzipUtils.getUncompressedFilename((String)"x.wmz\n"));
        Assertions.assertEquals((Object)"x.wmz\n", (Object)GzipUtils.getUncompressedFileName((String)"x.wmz\n"));
        Assertions.assertEquals((Object)"x.wmz.y", (Object)GzipUtils.getUncompressedFilename((String)"x.wmz.y"));
        Assertions.assertEquals((Object)"x.wmz.y", (Object)GzipUtils.getUncompressedFileName((String)"x.wmz.y"));
    }

    @Test
    public void testIsCompressedFilename() {
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFilename((String)""));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFileName((String)""));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFilename((String)".gz"));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFileName((String)".gz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.tgz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x.tgz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.taz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x.taz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.svgz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x.svgz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.cpgz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x.cpgz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.wmz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x.wmz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.emz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x.emz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.gz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x.gz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.z"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x.z"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x-gz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x-gz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x-z"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x-z"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x_z"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x_z"));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"xxgz"));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFileName((String)"xxgz"));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"xzz"));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFileName((String)"xzz"));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"xaz"));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFileName((String)"xaz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.SVGZ"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x.SVGZ"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.Svgz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x.Svgz"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.svGZ"));
        Assertions.assertTrue((boolean)GzipUtils.isCompressedFileName((String)"x.svGZ"));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"x.wmz "));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFileName((String)"x.wmz "));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"x.wmz\n"));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFileName((String)"x.wmz\n"));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"x.wmz.y"));
        Assertions.assertFalse((boolean)GzipUtils.isCompressedFileName((String)"x.wmz.y"));
    }
}

