/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class ZTest
extends AbstractTest {
    @Test
    public void testMatches() {
        Assertions.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{1, 2, 3, 4}, (int)4));
        Assertions.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, 2, 3, 4}, (int)4));
        Assertions.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{1, -99, 3, 4}, (int)4));
        Assertions.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, -99, 3, 4}, (int)3));
        Assertions.assertTrue((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, -99, 3, 4}, (int)4));
    }

    private void testUnarchive(AbstractTest.StreamWrapper<CompressorInputStream> wrapper) throws Exception {
        File input = ZTest.getFile("bla.tar.Z");
        File output = this.newTempFile("bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = wrapper.wrap(is);){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
        }
    }

    @Test
    public void testZUnarchive() throws Exception {
        this.testUnarchive(ZCompressorInputStream::new);
    }

    @Test
    public void testZUnarchiveViaAutoDetection() throws Exception {
        this.testUnarchive(is -> new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(is)));
    }

    @Test
    public void testZUnarchiveViaFactory() throws Exception {
        this.testUnarchive(is -> new CompressorStreamFactory().createCompressorInputStream("z", is));
    }
}

