/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.ChecksumCalculatingInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChecksumCalculatingInputStreamTest {
    @Test
    public void testClassInstantiationWithParameterBeingNullThrowsNullPointerExceptionOne() {
        Assertions.assertThrows(NullPointerException.class, () -> new ChecksumCalculatingInputStream(null, null));
    }

    @Test
    public void testClassInstantiationWithParameterBeingNullThrowsNullPointerExceptionThree() {
        Assertions.assertThrows(NullPointerException.class, () -> new ChecksumCalculatingInputStream((Checksum)new CRC32(), null));
    }

    @Test
    public void testClassInstantiationWithParameterBeingNullThrowsNullPointerExceptionTwo() {
        Assertions.assertThrows(NullPointerException.class, () -> new ChecksumCalculatingInputStream(null, (InputStream)new ByteArrayInputStream(new byte[1])));
    }

    @Test
    public void testReadTakingByteArray() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[6];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        try (ChecksumCalculatingInputStream checksumCalculatingInputStream = new ChecksumCalculatingInputStream((Checksum)adler32, (InputStream)byteArrayInputStream);){
            int readResult = checksumCalculatingInputStream.read(byteArray);
            Assertions.assertEquals((int)6, (int)readResult);
            Assertions.assertEquals((int)0, (int)byteArrayInputStream.available());
            Assertions.assertEquals((long)393217L, (long)checksumCalculatingInputStream.getValue());
        }
    }

    @Test
    public void testReadTakingByteArraySanityCheck() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[6];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        try (CheckedInputStream checksumCalculatingInputStream = new CheckedInputStream(byteArrayInputStream, adler32);){
            int readResult = checksumCalculatingInputStream.read(byteArray);
            Assertions.assertEquals((int)6, (int)readResult);
            Assertions.assertEquals((int)0, (int)byteArrayInputStream.available());
            Assertions.assertEquals((long)393217L, (long)checksumCalculatingInputStream.getChecksum().getValue());
        }
    }

    @Test
    public void testReadTakingNoArguments() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[6];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        ChecksumCalculatingInputStream checksumCalculatingInputStream = new ChecksumCalculatingInputStream((Checksum)adler32, (InputStream)byteArrayInputStream);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)checksumCalculatingInputStream);){
            int inputStreamReadResult = bufferedInputStream.read(byteArray, 0, 1);
            int checkSumCalculationReadResult = checksumCalculatingInputStream.read();
            Assertions.assertNotEquals((int)checkSumCalculationReadResult, (int)inputStreamReadResult);
            Assertions.assertEquals((int)-1, (int)checkSumCalculationReadResult);
            Assertions.assertEquals((int)0, (int)byteArrayInputStream.available());
            Assertions.assertEquals((long)393217L, (long)checksumCalculatingInputStream.getValue());
        }
    }

    @Test
    public void testReadTakingNoArgumentsSanityCheck() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[6];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        CheckedInputStream checksumCalculatingInputStream = new CheckedInputStream(byteArrayInputStream, adler32);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(checksumCalculatingInputStream);){
            int inputStreamReadResult = bufferedInputStream.read(byteArray, 0, 1);
            int checkSumCalculationReadResult = checksumCalculatingInputStream.read();
            Assertions.assertNotEquals((int)checkSumCalculationReadResult, (int)inputStreamReadResult);
            Assertions.assertEquals((int)-1, (int)checkSumCalculationReadResult);
            Assertions.assertEquals((int)0, (int)byteArrayInputStream.available());
            Assertions.assertEquals((long)393217L, (long)checksumCalculatingInputStream.getChecksum().getValue());
        }
    }

    @Test
    public void testSkipReturningPositive() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[6];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        try (ChecksumCalculatingInputStream checksumCalculatingInputStream = new ChecksumCalculatingInputStream((Checksum)adler32, (InputStream)byteArrayInputStream);){
            long skipResult = checksumCalculatingInputStream.skip(0L);
            Assertions.assertEquals((long)0L, (long)skipResult);
            Assertions.assertEquals((long)1L, (long)checksumCalculatingInputStream.getValue());
        }
    }

    @Test
    public void testSkipReturningPositiveSanityCheck() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[6];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        try (CheckedInputStream checksumCalculatingInputStream = new CheckedInputStream(byteArrayInputStream, adler32);){
            long skipResult = checksumCalculatingInputStream.skip(0L);
            Assertions.assertEquals((long)0L, (long)skipResult);
            Assertions.assertEquals((long)1L, (long)checksumCalculatingInputStream.getChecksum().getValue());
        }
    }

    @Test
    public void testSkipReturningZero() throws IOException {
        Adler32 adler32 = new Adler32();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY);
        try (ChecksumCalculatingInputStream checksumCalculatingInputStream = new ChecksumCalculatingInputStream((Checksum)adler32, (InputStream)byteArrayInputStream);){
            long skipResult = checksumCalculatingInputStream.skip(60L);
            Assertions.assertEquals((long)0L, (long)skipResult);
            Assertions.assertEquals((long)1L, (long)checksumCalculatingInputStream.getValue());
        }
    }

    @Test
    public void testSkipReturningZeroSanityCheck() throws IOException {
        Adler32 adler32 = new Adler32();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY);
        try (CheckedInputStream checksumCalculatingInputStream = new CheckedInputStream(byteArrayInputStream, adler32);){
            long skipResult = checksumCalculatingInputStream.skip(60L);
            Assertions.assertEquals((long)0L, (long)skipResult);
            Assertions.assertEquals((long)1L, (long)checksumCalculatingInputStream.getChecksum().getValue());
        }
    }
}

