/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.AbstractHierarchicalConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.configuration2.InterpolationTestHelper;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.DefaultConfigurationKey;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeModel;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAbstractHierarchicalConfiguration {
    private AbstractHierarchicalConfiguration<ImmutableNode> config;

    private static void checkContent(Configuration c) {
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            Assertions.assertEquals((Object)NodeStructureHelper.table(i), (Object)c.getString("tables.table(" + i + ").name"));
            for (int j = 0; j < NodeStructureHelper.fieldsLength(i); ++j) {
                Assertions.assertEquals((Object)NodeStructureHelper.field(i, j), (Object)c.getString("tables.table(" + i + ").fields.field(" + j + ").name"));
            }
        }
    }

    private static void checkGetProperty(AbstractHierarchicalConfiguration<?> testConfig) {
        Assertions.assertNull((Object)testConfig.getProperty("tables.table.resultset"));
        Assertions.assertNull((Object)testConfig.getProperty("tables.table.fields.field"));
        Object prop = testConfig.getProperty("tables.table(0).fields.field.name");
        Collection collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)NodeStructureHelper.fieldsLength(0), (int)collection.size());
        prop = testConfig.getProperty("tables.table.fields.field.name");
        collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)TestAbstractHierarchicalConfiguration.totalFieldCount(), (int)collection.size());
        prop = testConfig.getProperty("tables.table.fields.field(3).name");
        collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)2, (int)collection.size());
        prop = testConfig.getProperty("tables.table(1).fields.field(2).name");
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((Object)"creationDate", (Object)prop.toString());
    }

    private static DefaultConfigurationKey createConfigurationKey() {
        return new DefaultConfigurationKey(DefaultExpressionEngine.INSTANCE);
    }

    private static int totalFieldCount() {
        int fieldCount = 0;
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            fieldCount += NodeStructureHelper.fieldsLength(i);
        }
        return fieldCount;
    }

    private void checkAlternativeSyntax() {
        Assertions.assertNull((Object)this.config.getProperty("tables/table/resultset"));
        Assertions.assertNull((Object)this.config.getProperty("tables/table/fields/field"));
        Object prop = this.config.getProperty("tables/table[0]/fields/field/name");
        Collection collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)NodeStructureHelper.fieldsLength(0), (int)collection.size());
        prop = this.config.getProperty("tables/table/fields/field/name");
        collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)TestAbstractHierarchicalConfiguration.totalFieldCount(), (int)collection.size());
        prop = this.config.getProperty("tables/table/fields/field[3]/name");
        collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)2, (int)collection.size());
        prop = this.config.getProperty("tables/table[1]/fields/field[2]/name");
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((Object)"creationDate", (Object)prop.toString());
        Set<String> keys = ConfigurationAssert.keysToSet(this.config);
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("tables/table/name", "tables/table/fields/field/name")), keys);
    }

    private void checkKeys(String prefix, String[] expected) {
        HashSet<String> expectedKeys = new HashSet<String>();
        for (String anExpected : expected) {
            expectedKeys.add(anExpected.startsWith(prefix) ? anExpected : prefix + "." + anExpected);
        }
        HashSet<String> keys = new HashSet<String>();
        Iterator itKeys = this.config.getKeys(prefix);
        while (itKeys.hasNext()) {
            String key = (String)itKeys.next();
            keys.add(key);
        }
        Assertions.assertEquals(expectedKeys, keys);
    }

    private ExpressionEngine createAlternativeExpressionEngine() {
        return new DefaultExpressionEngine(new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setPropertyDelimiter("/").setIndexStart("[").setIndexEnd("]").create());
    }

    private ImmutableNode getRootNode() {
        return (ImmutableNode)this.config.getModel().getNodeHandler().getRootNode();
    }

    @BeforeEach
    public void setUp() throws Exception {
        ImmutableNode root = new ImmutableNode.Builder(1).addChild(NodeStructureHelper.ROOT_TABLES_TREE).create();
        this.config = new AbstractHierarchicalConfigurationTestImpl(new InMemoryNodeModel(root));
    }

    @Test
    public void testAddNodes() {
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>();
        nodes.add(NodeStructureHelper.createFieldNode("birthDate"));
        nodes.add(NodeStructureHelper.createFieldNode("lastLogin"));
        nodes.add(NodeStructureHelper.createFieldNode("language"));
        this.config.addNodes("tables.table(0).fields", nodes);
        Assertions.assertEquals((int)7, (int)this.config.getMaxIndex("tables.table(0).fields.field"));
        Assertions.assertEquals((Object)"birthDate", (Object)this.config.getString("tables.table(0).fields.field(5).name"));
        Assertions.assertEquals((Object)"lastLogin", (Object)this.config.getString("tables.table(0).fields.field(6).name"));
        Assertions.assertEquals((Object)"language", (Object)this.config.getString("tables.table(0).fields.field(7).name"));
    }

    @Test
    public void testAddNodesCopy() {
        AbstractHierarchicalConfigurationTestImpl configDest = new AbstractHierarchicalConfigurationTestImpl(new InMemoryNodeModel());
        configDest.addProperty("test", "TEST");
        List nodes = this.getRootNode().getChildren();
        Assertions.assertEquals((int)1, (int)nodes.size());
        configDest.addNodes("newNodes", nodes);
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            String keyTab = "newNodes.tables.table(" + i + ").";
            Assertions.assertEquals((Object)NodeStructureHelper.table(i), (Object)configDest.getString(keyTab + "name"), (String)("Table " + i + " not found"));
            for (int j = 0; j < NodeStructureHelper.fieldsLength(i); ++j) {
                Assertions.assertEquals((Object)NodeStructureHelper.field(i, j), (Object)configDest.getString(keyTab + "fields.field(" + j + ").name"), (String)("Invalid field " + j + " in table " + i));
            }
        }
    }

    @Test
    public void testAddNodesForNonExistingKey() {
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>();
        ImmutableNode newNode = new ImmutableNode.Builder().name("usr").value((Object)"scott").addAttribute("pwd", (Object)"tiger").create();
        nodes.add(newNode);
        this.config.addNodes("database.connection.settings", nodes);
        Assertions.assertEquals((Object)"scott", (Object)this.config.getString("database.connection.settings.usr"));
        Assertions.assertEquals((Object)"tiger", (Object)this.config.getString("database.connection.settings.usr[@pwd]"));
    }

    @Test
    public void testAddNodesWithAttributeKey() {
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>();
        nodes.add(NodeStructureHelper.createNode("testNode", "yes"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.config.addNodes("database.connection[@settings]", nodes));
    }

    @Test
    public void testAddProperty() {
        this.config.addProperty("tables.table(0).fields.field(-1).name", (Object)"phone");
        Object prop = this.config.getProperty("tables.table(0).fields.field.name");
        Collection collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)6, (int)collection.size());
        this.config.addProperty("tables.table(0).fields.field.name", (Object)"fax");
        prop = this.config.getProperty("tables.table.fields.field(5).name");
        List list = (List)Assertions.assertInstanceOf(List.class, (Object)prop);
        Assertions.assertEquals((Object)"phone", list.get(0));
        Assertions.assertEquals((Object)"fax", list.get(1));
        this.config.addProperty("tables.table(-1).name", (Object)"config");
        prop = this.config.getProperty("tables.table.name");
        collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)3, (int)collection.size());
        this.config.addProperty("tables.table(2).fields.field(0).name", (Object)"cid");
        this.config.addProperty("tables.table(2).fields.field(-1).name", (Object)"confName");
        prop = this.config.getProperty("tables.table(2).fields.field.name");
        collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)2, (int)collection.size());
        Assertions.assertEquals((Object)"confName", (Object)this.config.getProperty("tables.table(2).fields.field(1).name"));
        this.config.addProperty("connection.user", (Object)"scott");
        this.config.addProperty("connection.passwd", (Object)"tiger");
        Assertions.assertEquals((Object)"tiger", (Object)this.config.getProperty("connection.passwd"));
        DefaultConfigurationKey key = TestAbstractHierarchicalConfiguration.createConfigurationKey();
        key.append("tables").append("table").appendIndex(0);
        key.appendAttribute("tableType");
        this.config.addProperty(key.toString(), (Object)"system");
        Assertions.assertEquals((Object)"system", (Object)this.config.getProperty(key.toString()));
    }

    @Test
    public void testAddPropertyInvalidKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.config.addProperty(".", (Object)"InvalidKey"));
    }

    @Test
    public void testAddPropertyWithListHandling() {
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        String key = "list.delimiter.value";
        this.config.addProperty("list.delimiter.value.escaped", (Object)"3\\,1415");
        this.config.addProperty("list.delimiter.value.elements", (Object)"3,1415");
        Assertions.assertEquals((Object)"3,1415", (Object)this.config.getString("list.delimiter.value.escaped"));
        Assertions.assertEquals((Object)"3", (Object)this.config.getString("list.delimiter.value.elements"));
    }

    @Test
    public void testClear() {
        this.config.setProperty(null, (Object)"value");
        this.config.addProperty("[@attr]", (Object)"defined");
        this.config.clear();
        Assertions.assertTrue((boolean)this.config.isEmpty());
    }

    @Test
    public void testClearProperty() {
        this.config.clearProperty("tables.table(0).fields.field(0).name");
        Assertions.assertEquals((Object)"uname", (Object)this.config.getProperty("tables.table(0).fields.field(0).name"));
        this.config.clearProperty("tables.table(0).name");
        Assertions.assertFalse((boolean)this.config.containsKey("tables.table(0).name"));
        Assertions.assertEquals((Object)"firstName", (Object)this.config.getProperty("tables.table(0).fields.field(1).name"));
        Assertions.assertEquals((Object)"documents", (Object)this.config.getProperty("tables.table.name"));
        this.config.clearProperty("tables.table");
        Assertions.assertEquals((Object)"documents", (Object)this.config.getProperty("tables.table.name"));
        this.config.addProperty("test", (Object)"first");
        this.config.addProperty("test.level", (Object)"second");
        this.config.clearProperty("test");
        Assertions.assertEquals((Object)"second", (Object)this.config.getString("test.level"));
        Assertions.assertFalse((boolean)this.config.containsKey("test"));
    }

    @Test
    public void testClearTree() {
        Object prop = this.config.getProperty("tables.table(0).fields.field.name");
        Assertions.assertNotNull((Object)prop);
        this.config.clearTree("tables.table(0).fields.field(3)");
        prop = this.config.getProperty("tables.table(0).fields.field.name");
        Collection collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)4, (int)collection.size());
        this.config.clearTree("tables.table(0).fields");
        Assertions.assertNull((Object)this.config.getProperty("tables.table(0).fields.field.name"));
        prop = this.config.getProperty("tables.table.fields.field.name");
        collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)NodeStructureHelper.fieldsLength(1), (int)collection.size());
        this.config.clearTree("tables.table(1)");
        Assertions.assertNull((Object)this.config.getProperty("tables.table.fields.field.name"));
    }

    @Test
    public void testClearTreeComplex() {
        String name;
        int count = 5;
        for (int idx = 0; idx < 5; ++idx) {
            this.config.addProperty("indexList.index(-1)[@default]", (Object)Boolean.FALSE);
            this.config.addProperty("indexList.index[@name]", (Object)("test" + idx));
            this.config.addProperty("indexList.index.dir", (Object)("testDir" + idx));
        }
        Assertions.assertEquals((int)4, (int)this.config.getMaxIndex("indexList.index[@name]"));
        boolean found = false;
        int idx = 0;
        while ((name = this.config.getString("indexList.index(" + idx + ")[@name]")) != null) {
            if ("test3".equals(name)) {
                Assertions.assertEquals((Object)"testDir3", (Object)this.config.getString("indexList.index(" + idx + ").dir"));
                this.config.clearTree("indexList.index(" + idx + ")");
                found = true;
            }
            ++idx;
        }
        Assertions.assertTrue((boolean)found);
        Assertions.assertEquals((int)3, (int)this.config.getMaxIndex("indexList.index[@name]"));
        Assertions.assertEquals((int)3, (int)this.config.getMaxIndex("indexList.index.dir"));
        idx = 0;
        while ((name = this.config.getString("indexList.index(" + idx + ")[@name]")) != null) {
            Assertions.assertNotEquals((Object)"test3", (Object)name);
            ++idx;
        }
    }

    @Test
    public void testClearTreeHierarchy() {
        this.config.addProperty("a.b.c", (Object)"c");
        this.config.addProperty("a.b.c.d", (Object)"d");
        this.config.addProperty("a.b.c.d.e", (Object)"e");
        this.config.clearTree("a.b.c");
        Assertions.assertFalse((boolean)this.config.containsKey("a.b.c"));
        Assertions.assertFalse((boolean)this.config.containsKey("a.b.c.d"));
    }

    @Test
    public void testClone() {
        Configuration copy = (Configuration)this.config.clone();
        Assertions.assertInstanceOf(AbstractHierarchicalConfiguration.class, (Object)copy);
        TestAbstractHierarchicalConfiguration.checkContent(copy);
    }

    @Test
    public void testCloneInterpolation() {
        String keyAnswer = "answer";
        String keyValue = "value";
        this.config.addProperty("answer", (Object)"The answer is ${value}.");
        this.config.addProperty("value", (Object)42);
        Configuration clone = (Configuration)this.config.clone();
        clone.setProperty("value", (Object)43);
        Assertions.assertEquals((Object)"The answer is 42.", (Object)this.config.getString("answer"));
        Assertions.assertEquals((Object)"The answer is 43.", (Object)clone.getString("answer"));
    }

    @Test
    public void testCloneWithEventListeners() {
        EventListenerTestImpl l = new EventListenerTestImpl(null);
        this.config.addEventListener(ConfigurationEvent.ANY, (EventListener)l);
        AbstractHierarchicalConfiguration copy = (AbstractHierarchicalConfiguration)this.config.clone();
        Assertions.assertFalse((boolean)copy.getEventListeners(ConfigurationEvent.ANY).contains(l));
    }

    @Test
    public void testContainsKey() {
        Assertions.assertTrue((boolean)this.config.containsKey("tables.table(0).name"));
        Assertions.assertTrue((boolean)this.config.containsKey("tables.table(1).name"));
        Assertions.assertFalse((boolean)this.config.containsKey("tables.table(2).name"));
        Assertions.assertTrue((boolean)this.config.containsKey("tables.table(0).fields.field.name"));
        Assertions.assertFalse((boolean)this.config.containsKey("tables.table(0).fields.field"));
        this.config.clearTree("tables.table(0).fields");
        Assertions.assertFalse((boolean)this.config.containsKey("tables.table(0).fields.field.name"));
        Assertions.assertTrue((boolean)this.config.containsKey("tables.table.fields.field.name"));
    }

    @Test
    public void testGetKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            keys.add((String)it.next());
        }
        Assertions.assertEquals(Arrays.asList("tables.table.name", "tables.table.fields.field.name"), keys);
    }

    @Test
    public void testGetKeysAttribute() {
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        HashSet<String> keys = new HashSet<String>();
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            keys.add((String)it.next());
        }
        Assertions.assertTrue((boolean)keys.contains("tables.table[@type]"));
    }

    @Test
    public void testGetKeysAttributePrefix() {
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        Iterator itKeys = this.config.getKeys("tables.table[@type]");
        Assertions.assertEquals((Object)"tables.table[@type]", itKeys.next());
        Assertions.assertFalse((boolean)itKeys.hasNext());
    }

    @Test
    public void testGetKeysOrder() {
        this.config.addProperty("order.key1", (Object)"value1");
        this.config.addProperty("order.key2", (Object)"value2");
        this.config.addProperty("order.key3", (Object)"value3");
        Iterator it = this.config.getKeys("order");
        Assertions.assertEquals((Object)"order.key1", it.next());
        Assertions.assertEquals((Object)"order.key2", it.next());
        Assertions.assertEquals((Object)"order.key3", it.next());
    }

    @Test
    public void testGetKeysString() {
        this.config.addProperty("tables.table(0).fields.field(1).type", (Object)"VARCHAR");
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        this.config.addProperty("tables.table(0).size", (Object)"42");
        this.config.addProperty("tables.table(0).fields.field(0).size", (Object)"128");
        this.config.addProperty("connections.connection.param.url", (Object)"url1");
        this.config.addProperty("connections.connection.param.user", (Object)"me");
        this.config.addProperty("connections.connection.param.pwd", (Object)"secret");
        this.config.addProperty("connections.connection(-1).param.url", (Object)"url2");
        this.config.addProperty("connections.connection(1).param.user", (Object)"guest");
        this.checkKeys("tables.table(1)", new String[]{"name", "fields.field.name"});
        this.checkKeys("tables.table(0)", new String[]{"name", "fields.field.name", "tables.table(0)[@type]", "size", "fields.field.type", "fields.field.size"});
        this.checkKeys("connections.connection(0).param", new String[]{"url", "user", "pwd"});
        this.checkKeys("connections.connection(1).param", new String[]{"url", "user"});
    }

    @Test
    public void testGetKeysWithKeyAsPrefix() {
        this.config.addProperty("order.key1", (Object)"value1");
        this.config.addProperty("order.key2", (Object)"value2");
        Iterator it = this.config.getKeys("order.key1");
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"order.key1", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testGetKeysWithKeyAsPrefixMultiple() {
        this.config.addProperty("order.key1", (Object)"value1");
        this.config.addProperty("order.key1.test", (Object)"value2");
        this.config.addProperty("order.key1.test.complex", (Object)"value2");
        Iterator it = this.config.getKeys("order.key1");
        Assertions.assertEquals((Object)"order.key1", it.next());
        Assertions.assertEquals((Object)"order.key1.test", it.next());
        Assertions.assertEquals((Object)"order.key1.test.complex", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testGetMaxIndex() {
        Assertions.assertEquals((int)(NodeStructureHelper.fieldsLength(0) - 1), (int)this.config.getMaxIndex("tables.table(0).fields.field"));
        Assertions.assertEquals((int)(NodeStructureHelper.fieldsLength(1) - 1), (int)this.config.getMaxIndex("tables.table(1).fields.field"));
        Assertions.assertEquals((int)1, (int)this.config.getMaxIndex("tables.table"));
        Assertions.assertEquals((int)1, (int)this.config.getMaxIndex("tables.table.name"));
        Assertions.assertEquals((int)0, (int)this.config.getMaxIndex("tables.table(0).name"));
        Assertions.assertEquals((int)0, (int)this.config.getMaxIndex("tables.table(1).fields.field(1)"));
        Assertions.assertEquals((int)-1, (int)this.config.getMaxIndex("tables.table(2).fields"));
        int maxIdx = this.config.getMaxIndex("tables.table(0).fields.field.name");
        for (int i = 0; i <= maxIdx; ++i) {
            DefaultConfigurationKey key = new DefaultConfigurationKey(DefaultExpressionEngine.INSTANCE, "tables.table(0).fields");
            key.append("field").appendIndex(i).append("name");
            Assertions.assertNotNull((Object)this.config.getProperty(key.toString()));
        }
    }

    @Test
    public void testGetNodeModel() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        this.config.setSynchronizer((Synchronizer)sync);
        NodeModel model = this.config.getNodeModel();
        Assertions.assertInstanceOf(InMemoryNodeModel.class, (Object)model);
        ImmutableNode rootNode = (ImmutableNode)model.getNodeHandler().getRootNode();
        Assertions.assertEquals((int)1, (int)rootNode.getChildren().size());
        Assertions.assertTrue((boolean)rootNode.getChildren().contains(NodeStructureHelper.ROOT_TABLES_TREE));
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetProperty() {
        TestAbstractHierarchicalConfiguration.checkGetProperty(this.config);
    }

    @Test
    public void testGetPropertyKeyWithBrackets() {
        String key = "test.directory.platform(x86)";
        this.config.addProperty("test.directory.platform(x86)", (Object)"C:\\Temp");
        Assertions.assertEquals((Object)"C:\\Temp", (Object)this.config.getString("test.directory.platform(x86)"));
    }

    @Test
    public void testInitCopyNull() {
        BaseHierarchicalConfiguration copy = new BaseHierarchicalConfiguration((HierarchicalConfiguration)((BaseHierarchicalConfiguration)null));
        Assertions.assertTrue((boolean)copy.isEmpty());
    }

    @Test
    public void testInterpolatedConfiguration() {
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        AbstractHierarchicalConfiguration c = (AbstractHierarchicalConfiguration)InterpolationTestHelper.testInterpolatedConfiguration(this.config);
        TestAbstractHierarchicalConfiguration.checkGetProperty(c);
    }

    @Test
    public void testInterpolation() {
        this.config.addProperty("base.dir", (Object)"/home/foo");
        this.config.addProperty("test.absolute.dir.dir1", (Object)"${base.dir}/path1");
        this.config.addProperty("test.absolute.dir.dir2", (Object)"${base.dir}/path2");
        this.config.addProperty("test.absolute.dir.dir3", (Object)"${base.dir}/path3");
        Configuration sub = this.config.subset("test.absolute.dir");
        for (int i = 1; i < 4; ++i) {
            Assertions.assertEquals((Object)("/home/foo/path" + i), (Object)this.config.getString("test.absolute.dir.dir" + i));
            Assertions.assertEquals((Object)("/home/foo/path" + i), (Object)sub.getString("dir" + i));
        }
    }

    @Test
    public void testInterpolationBasic() {
        InterpolationTestHelper.testInterpolation(this.config);
    }

    @Test
    public void testInterpolationConstants() {
        InterpolationTestHelper.testInterpolationConstants(this.config);
    }

    @Test
    public void testInterpolationEscaped() {
        InterpolationTestHelper.testInterpolationEscaped(this.config);
    }

    @Test
    public void testInterpolationLocalhost() {
        InterpolationTestHelper.testInterpolationLocalhost(this.config);
    }

    @Test
    public void testInterpolationLoop() {
        InterpolationTestHelper.testInterpolationLoop(this.config);
    }

    @Test
    public void testInterpolationMultipleLevels() {
        InterpolationTestHelper.testMultipleInterpolation(this.config);
    }

    @Test
    public void testInterpolationSubset() {
        InterpolationTestHelper.testInterpolationSubset(this.config);
    }

    @Test
    public void testInterpolationSubsetMultipleLayers() {
        this.config.clear();
        this.config.addProperty("var", (Object)"value");
        this.config.addProperty("prop2.prop[@attr]", (Object)"${var}");
        Configuration sub1 = this.config.subset("prop2");
        Configuration sub2 = sub1.subset("prop");
        Assertions.assertEquals((Object)"value", (Object)sub2.getString("[@attr]"));
    }

    @Test
    public void testInterpolationSystemProperties() {
        InterpolationTestHelper.testInterpolationSystemProperties(this.config);
    }

    @Test
    public void testInterpolationUnknownProperty() {
        InterpolationTestHelper.testInterpolationUnknownProperty(this.config);
    }

    @Test
    public void testInterpolator() {
        InterpolationTestHelper.testGetInterpolator(this.config);
    }

    @Test
    public void testIsEmptyFalse() {
        Assertions.assertFalse((boolean)this.config.isEmpty());
    }

    @Test
    public void testIsEmptyNodesWithNoValues() {
        ImmutableNode.Builder rootBuilder = new ImmutableNode.Builder(1);
        ImmutableNode.Builder nodeBuilder = new ImmutableNode.Builder(1);
        nodeBuilder.addChild(NodeStructureHelper.createNode("child", null));
        rootBuilder.addChild(nodeBuilder.create());
        this.config = new AbstractHierarchicalConfigurationTestImpl(new InMemoryNodeModel(rootBuilder.create()));
        Assertions.assertTrue((boolean)this.config.isEmpty());
    }

    @Test
    public void testIsEmptyRootOnly() {
        this.config = new AbstractHierarchicalConfigurationTestImpl(new InMemoryNodeModel());
        Assertions.assertTrue((boolean)this.config.isEmpty());
    }

    @Test
    public void testNodeKeyCacheHit() {
        HashMap<ImmutableNode, String> cache = new HashMap<ImmutableNode, String>();
        String key = "someResultKey";
        cache.put(this.getRootNode(), "someResultKey");
        Assertions.assertEquals((Object)"someResultKey", (Object)this.config.nodeKey((Object)this.getRootNode(), cache, this.config.getModel().getNodeHandler()));
    }

    @Test
    public void testNodeKeyCachePopulated() {
        HashMap cache = new HashMap();
        ImmutableNode nodeTabName = NodeStructureHelper.nodeForKey(this.getRootNode(), "tables/table(0)/name");
        NodeHandler handler = this.config.getModel().getNodeHandler();
        this.config.nodeKey((Object)nodeTabName, cache, handler);
        Assertions.assertEquals((int)4, (int)cache.size());
        Assertions.assertEquals((Object)"tables(0).table(0).name(0)", cache.get(nodeTabName));
        Assertions.assertEquals((Object)"tables(0).table(0)", cache.get(handler.getParent((Object)nodeTabName)));
        Assertions.assertEquals((Object)"tables(0)", cache.get(handler.getParent((Object)((ImmutableNode)handler.getParent((Object)nodeTabName)))));
        Assertions.assertEquals((Object)"", cache.get(this.getRootNode()));
    }

    @Test
    public void testNodeKeyCacheUsage() {
        HashMap<ImmutableNode, String> cache = new HashMap<ImmutableNode, String>();
        ImmutableNode nodeTabName = NodeStructureHelper.nodeForKey(this.getRootNode(), "tables/table(0)/name");
        NodeHandler handler = this.config.getModel().getNodeHandler();
        cache.put((ImmutableNode)handler.getParent((Object)nodeTabName), "somePrefix");
        Assertions.assertEquals((Object)"somePrefix.name(0)", (Object)this.config.nodeKey((Object)nodeTabName, cache, handler));
    }

    @Test
    public void testNodeKeyEmptyCache() {
        HashMap cache = new HashMap();
        ImmutableNode nodeTabName = NodeStructureHelper.nodeForKey(this.getRootNode(), "tables/table(0)/name");
        ImmutableNode nodeFldName = NodeStructureHelper.nodeForKey(this.getRootNode(), "tables/table(0)/fields/field(1)/name");
        Assertions.assertEquals((Object)"tables(0).table(0).name(0)", (Object)this.config.nodeKey((Object)nodeTabName, cache, this.config.getModel().getNodeHandler()));
        Assertions.assertEquals((Object)"tables(0).table(0).fields(0).field(1).name(0)", (Object)this.config.nodeKey((Object)nodeFldName, cache, this.config.getModel().getNodeHandler()));
    }

    @Test
    public void testNodeKeyRootNode() {
        HashMap cache = new HashMap();
        Assertions.assertEquals((Object)"", (Object)this.config.nodeKey((Object)this.getRootNode(), cache, this.config.getModel().getNodeHandler()));
    }

    @Test
    public void testResolveNodeKey() {
        List nodes = this.config.resolveNodeKey((Object)this.getRootNode(), "tables.table.name", this.config.getModel().getNodeHandler());
        Assertions.assertEquals((int)NodeStructureHelper.tablesLength(), (int)nodes.size());
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            Assertions.assertEquals((Object)NodeStructureHelper.table(i), (Object)((ImmutableNode)nodes.get(i)).getValue(), (String)("Wrong node value at " + i));
        }
    }

    @Test
    public void testResolveNodeKeyAttribute() {
        String attrKey = "tables.table(0)[@type]";
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        Assertions.assertTrue((boolean)this.config.resolveNodeKey((Object)this.getRootNode(), "tables.table(0)[@type]", this.config.getModel().getNodeHandler()).isEmpty());
    }

    @Test
    public void testSetExpressionEngine() {
        this.config.setExpressionEngine(null);
        Assertions.assertNotNull((Object)this.config.getExpressionEngine());
        Assertions.assertSame((Object)DefaultExpressionEngine.INSTANCE, (Object)this.config.getExpressionEngine());
        this.config.setExpressionEngine(this.createAlternativeExpressionEngine());
        this.checkAlternativeSyntax();
    }

    @Test
    public void testSetProperty() {
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        this.config.setProperty("tables.table(0).name", (Object)"resources");
        Assertions.assertEquals((Object)"resources", (Object)this.config.getString("tables.table(0).name"));
        this.config.setProperty("tables.table.name", (Object)"tab1,tab2");
        Assertions.assertEquals((Object)"tab1", (Object)this.config.getString("tables.table(0).name"));
        Assertions.assertEquals((Object)"tab2", (Object)this.config.getString("tables.table(1).name"));
        this.config.setProperty("test.items.item", (Object)new int[]{2, 4, 8, 16});
        Assertions.assertEquals((int)3, (int)this.config.getMaxIndex("test.items.item"));
        Assertions.assertEquals((int)8, (int)this.config.getInt("test.items.item(2)"));
        this.config.setProperty("test.items.item(2)", (Object)6);
        Assertions.assertEquals((int)6, (int)this.config.getInt("test.items.item(2)"));
        this.config.setProperty("test.items.item(2)", (Object)new int[]{7, 9, 11});
        Assertions.assertEquals((int)5, (int)this.config.getMaxIndex("test.items.item"));
        this.config.setProperty("test", (Object)Boolean.TRUE);
        this.config.setProperty("test.items", (Object)"01/01/05");
        Assertions.assertEquals((int)5, (int)this.config.getMaxIndex("test.items.item"));
        Assertions.assertTrue((boolean)this.config.getBoolean("test"));
        Assertions.assertEquals((Object)"01/01/05", (Object)this.config.getProperty("test.items"));
        this.config.setProperty("test.items.item", (Object)42);
        Assertions.assertEquals((int)0, (int)this.config.getMaxIndex("test.items.item"));
        Assertions.assertEquals((int)42, (int)this.config.getInt("test.items.item"));
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)2, (int)this.config.size());
    }

    private static final class AbstractHierarchicalConfigurationTestImpl
    extends AbstractHierarchicalConfiguration<ImmutableNode> {
        public AbstractHierarchicalConfigurationTestImpl(InMemoryNodeModel model) {
            super((NodeModel)model);
        }

        public List<HierarchicalConfiguration<ImmutableNode>> childConfigurationsAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public List<HierarchicalConfiguration<ImmutableNode>> childConfigurationsAt(String key, boolean supportUpdates) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        protected NodeModel<ImmutableNode> cloneNodeModel() {
            return new InMemoryNodeModel((ImmutableNode)this.getModel().getNodeHandler().getRootNode());
        }

        public SubnodeConfiguration configurationAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public SubnodeConfiguration configurationAt(String key, boolean supportUpdates) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public List<HierarchicalConfiguration<ImmutableNode>> configurationsAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public List<HierarchicalConfiguration<ImmutableNode>> configurationsAt(String key, boolean supportUpdates) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public List<ImmutableHierarchicalConfiguration> immutableChildConfigurationsAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public ImmutableHierarchicalConfiguration immutableConfigurationAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public ImmutableHierarchicalConfiguration immutableConfigurationAt(String key, boolean supportUpdates) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }

        public List<ImmutableHierarchicalConfiguration> immutableConfigurationsAt(String key) {
            throw new UnsupportedOperationException("Unexpected method call!");
        }
    }
}

