/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Collection;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderConfigurationWrapperFactory;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.apache.commons.configuration2.event.EventSource;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestBuilderConfigurationWrapperFactory {
    private ConfigurationBuilder<BaseHierarchicalConfiguration> createBuilderMock(BaseHierarchicalConfiguration conf) {
        ConfigurationBuilder builder = (ConfigurationBuilder)Mockito.mock(ConfigurationBuilder.class);
        Assertions.assertDoesNotThrow(() -> Mockito.when((Object)((BaseHierarchicalConfiguration)builder.getConfiguration())).thenReturn((Object)conf));
        return builder;
    }

    @Test
    public void testConfigurationBuilderWrapper() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        ConfigurationBuilder<BaseHierarchicalConfiguration> builder = this.createBuilderMock(conf);
        conf.addProperty("test1", (Object)"value1");
        conf.addProperty("test2", (Object)"42");
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory();
        HierarchicalConfiguration wrapper = (HierarchicalConfiguration)factory.createBuilderConfigurationWrapper(HierarchicalConfiguration.class, builder);
        Assertions.assertEquals((Object)"value1", (Object)wrapper.getString("test1"));
        Assertions.assertEquals((int)42, (int)wrapper.getInt("test2"));
        Assertions.assertSame((Object)conf.getNodeModel().getNodeHandler().getRootNode(), (Object)wrapper.getNodeModel().getNodeHandler().getRootNode());
    }

    @Test
    public void testCreateBuilderConfigurationWrapperNoBuilder() {
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory();
        Assertions.assertThrows(IllegalArgumentException.class, () -> factory.createBuilderConfigurationWrapper(Configuration.class, null));
    }

    @Test
    public void testCreateBuilderConfigurationWrapperNoClass() {
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory(BuilderConfigurationWrapperFactory.EventSourceSupport.BUILDER);
        ConfigurationBuilder<BaseHierarchicalConfiguration> builder = this.createBuilderMock(new BaseHierarchicalConfiguration());
        Assertions.assertThrows(IllegalArgumentException.class, () -> factory.createBuilderConfigurationWrapper(null, builder));
        Mockito.verifyNoInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void testDefaultEventSourceSupport() {
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory();
        Assertions.assertEquals((Object)BuilderConfigurationWrapperFactory.EventSourceSupport.NONE, (Object)factory.getEventSourceSupport());
    }

    @Test
    public void testEventSourceSupportBuilder() throws ConfigurationException {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        EventListenerTestImpl l1 = new EventListenerTestImpl(null);
        EventListenerTestImpl l2 = new EventListenerTestImpl(null);
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory(BuilderConfigurationWrapperFactory.EventSourceSupport.BUILDER);
        EventSource src = (EventSource)factory.createBuilderConfigurationWrapper(Configuration.class, (ConfigurationBuilder)builder);
        src.addEventListener(ConfigurationEvent.ANY, (EventListener)l1);
        src.addEventListener(ConfigurationEvent.ANY_HIERARCHICAL, (EventListener)l2);
        Assertions.assertTrue((boolean)src.removeEventListener(ConfigurationEvent.ANY_HIERARCHICAL, (EventListener)l2));
        Assertions.assertFalse((boolean)src.removeEventListener(ConfigurationEvent.ANY_HIERARCHICAL, (EventListener)l2));
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Collection listeners = config.getEventListeners(ConfigurationEvent.ANY_HIERARCHICAL);
        Assertions.assertTrue((boolean)listeners.contains(l1));
        Assertions.assertFalse((boolean)listeners.contains(l2));
    }

    @Test
    public void testEventSourceSupportDummy() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        ConfigurationBuilder<BaseHierarchicalConfiguration> builder = this.createBuilderMock(conf);
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory(BuilderConfigurationWrapperFactory.EventSourceSupport.DUMMY);
        EventSource src = (EventSource)factory.createBuilderConfigurationWrapper(HierarchicalConfiguration.class, builder);
        src.addEventListener(ConfigurationEvent.ANY, null);
        Mockito.verifyNoInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void testEventSourceSupportMockBuilder() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        ConfigurationBuilder<BaseHierarchicalConfiguration> builder = this.createBuilderMock(conf);
        EventListenerTestImpl listener = new EventListenerTestImpl(null);
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory(BuilderConfigurationWrapperFactory.EventSourceSupport.BUILDER);
        EventSource src = (EventSource)factory.createBuilderConfigurationWrapper(HierarchicalConfiguration.class, builder);
        src.addEventListener(ConfigurationEvent.ANY, (EventListener)listener);
        ((ConfigurationBuilder)Mockito.verify(builder)).addEventListener(ConfigurationEvent.ANY, (EventListener)listener);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void testEventSourceSupportNone() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        ConfigurationBuilder<BaseHierarchicalConfiguration> builder = this.createBuilderMock(conf);
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory();
        HierarchicalConfiguration wrapper = (HierarchicalConfiguration)factory.createBuilderConfigurationWrapper(HierarchicalConfiguration.class, builder);
        Assertions.assertFalse((boolean)(wrapper instanceof EventSource));
    }
}

