/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.DatabaseBuilderParametersImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestDatabaseBuilderParametersImpl {
    private DatabaseBuilderParametersImpl params;

    @BeforeEach
    public void setUp() throws Exception {
        this.params = new DatabaseBuilderParametersImpl();
    }

    @Test
    public void testBeanProperties() throws Exception {
        BeanHelper.setProperty((Object)this.params, (String)"table", (Object)"testTable");
        BeanHelper.setProperty((Object)this.params, (String)"autoCommit", (Object)Boolean.FALSE);
        Map map = this.params.getParameters();
        Assertions.assertEquals((Object)"testTable", map.get("table"));
        Assertions.assertEquals((Object)Boolean.FALSE, map.get("autoCommit"));
    }

    @Test
    public void testSetAutoCommit() {
        Assertions.assertSame((Object)this.params, (Object)this.params.setAutoCommit(true));
        Assertions.assertEquals((Object)Boolean.TRUE, this.params.getParameters().get("autoCommit"));
    }

    @Test
    public void testSetConfigurationName() {
        String confName = "TestConfiguration";
        Assertions.assertSame((Object)this.params, (Object)this.params.setConfigurationName("TestConfiguration"));
        Assertions.assertEquals((Object)"TestConfiguration", this.params.getParameters().get("configurationName"));
    }

    @Test
    public void testSetConfigurationNameColumn() {
        String colName = "CONFIG_COLUMN";
        Assertions.assertSame((Object)this.params, (Object)this.params.setConfigurationNameColumn("CONFIG_COLUMN"));
        Assertions.assertEquals((Object)"CONFIG_COLUMN", this.params.getParameters().get("configurationNameColumn"));
    }

    @Test
    public void testSetDataSource() {
        DataSource src = (DataSource)Mockito.mock(DataSource.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setDataSource(src));
        Assertions.assertSame((Object)src, this.params.getParameters().get("dataSource"));
    }

    @Test
    public void testSetKeyColumn() {
        String colName = "KEY_COLUMN";
        Assertions.assertSame((Object)this.params, (Object)this.params.setKeyColumn("KEY_COLUMN"));
        Assertions.assertEquals((Object)"KEY_COLUMN", this.params.getParameters().get("keyColumn"));
    }

    @Test
    public void testSetTable() {
        String table = "TestTable";
        Assertions.assertSame((Object)this.params, (Object)this.params.setTable("TestTable"));
        Assertions.assertEquals((Object)"TestTable", this.params.getParameters().get("table"));
    }

    @Test
    public void testSetValueColumn() {
        String colName = "VALUE_COLUMN";
        Assertions.assertSame((Object)this.params, (Object)this.params.setValueColumn("VALUE_COLUMN"));
        Assertions.assertEquals((Object)"VALUE_COLUMN", this.params.getParameters().get("valueColumn"));
    }
}

