/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Arrays;
import org.apache.commons.configuration2.builder.EventListenerParameters;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerRegistrationData;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEventListenerParameters {
    @Test
    public void testAddEventListener() {
        EventListenerTestImpl listener = new EventListenerTestImpl(null);
        EventListenerParameters parameters = new EventListenerParameters();
        Assertions.assertSame((Object)parameters, (Object)parameters.addEventListener(ConfigurationEvent.ADD_PROPERTY, (EventListener)listener));
        Assertions.assertEquals((int)1, (int)parameters.getListeners().getRegistrations().size());
        EventListenerRegistrationData reg = (EventListenerRegistrationData)parameters.getListeners().getRegistrations().get(0);
        Assertions.assertEquals((Object)ConfigurationEvent.ADD_PROPERTY, (Object)reg.getEventType());
        Assertions.assertEquals((Object)listener, (Object)reg.getListener());
    }

    @Test
    public void testAddEventListenerRegistration() {
        EventListenerRegistrationData reg = new EventListenerRegistrationData(ConfigurationEvent.SET_PROPERTY, (EventListener)new EventListenerTestImpl(null));
        EventListenerParameters parameters = new EventListenerParameters();
        Assertions.assertSame((Object)parameters, (Object)parameters.addEventListener(reg));
        Assertions.assertEquals(Arrays.asList(reg), (Object)parameters.getListeners().getRegistrations());
    }

    @Test
    public void testGetParameters() {
        EventListenerParameters parameters = new EventListenerParameters();
        Assertions.assertTrue((boolean)parameters.getParameters().isEmpty());
    }

    @Test
    public void testRegistrationsAfterCreation() {
        EventListenerParameters parameters = new EventListenerParameters();
        Assertions.assertTrue((boolean)parameters.getListeners().getRegistrations().isEmpty());
    }
}

