/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.sync;

import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestReadWriteSynchronizer {
    private static final long TOTAL_MONEY = 1000000L;

    private static long sumUpAccounts(Account ... accounts) {
        long sum = 0L;
        for (Account acc : accounts) {
            sum += acc.getAmount();
        }
        return sum;
    }

    @Test
    public void testInitLock() {
        ReadWriteLock lock = (ReadWriteLock)Mockito.mock(ReadWriteLock.class);
        Lock readLock = (Lock)Mockito.mock(Lock.class);
        Mockito.when((Object)lock.readLock()).thenReturn((Object)readLock);
        ReadWriteSynchronizer sync = new ReadWriteSynchronizer(lock);
        sync.beginRead();
        ((ReadWriteLock)Mockito.verify((Object)lock)).readLock();
        ((Lock)Mockito.verify((Object)readLock)).lock();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{lock, readLock});
    }

    @Test
    public void testReentrance() {
        ReadWriteSynchronizer sync = new ReadWriteSynchronizer();
        sync.beginWrite();
        sync.beginRead();
        sync.beginRead();
        sync.endRead();
        sync.endRead();
        sync.beginWrite();
        sync.endWrite();
        sync.endWrite();
    }

    @Test
    public void testSynchronizerInAction() throws InterruptedException {
        int numberOfUpdates = 10000;
        int numberOfReads = 5000;
        int readThreadCount = 3;
        int updateThreadCount = 2;
        ReadWriteSynchronizer sync = new ReadWriteSynchronizer();
        Account account1 = new Account();
        Account account2 = new Account();
        account1.change(500000L);
        account2.change(500000L);
        UpdateThread[] updateThreads = new UpdateThread[2];
        for (int i = 0; i < updateThreads.length; ++i) {
            updateThreads[i] = new UpdateThread((Synchronizer)sync, 10000, account1, account2);
            updateThreads[i].start();
        }
        ReaderThread[] readerThreads = new ReaderThread[3];
        for (int i = 0; i < readerThreads.length; ++i) {
            readerThreads[i] = new ReaderThread((Synchronizer)sync, 5000, account1, account2);
            readerThreads[i].start();
        }
        for (UpdateThread updateThread : updateThreads) {
            updateThread.join();
        }
        for (Thread thread : readerThreads) {
            thread.join();
            Assertions.assertEquals((int)0, (int)((ReaderThread)thread).getErrors());
        }
        sync.beginRead();
        Assertions.assertEquals((long)1000000L, (long)TestReadWriteSynchronizer.sumUpAccounts(account1, account2));
        sync.endRead();
    }

    private static final class Account {
        private long amount;

        private Account() {
        }

        public void change(long delta) {
            this.amount += delta;
        }

        public long getAmount() {
            return this.amount;
        }
    }

    private static final class UpdateThread
    extends Thread {
        private final Synchronizer sync;
        private final Account account1;
        private final Account account2;
        private final Random random;
        private final int numberOfUpdates;

        public UpdateThread(Synchronizer s, int updateCount, Account ac1, Account ac2) {
            this.sync = s;
            this.account1 = ac1;
            this.account2 = ac2;
            this.numberOfUpdates = updateCount;
            this.random = new Random();
        }

        @Override
        public void run() {
            for (int i = 0; i < this.numberOfUpdates; ++i) {
                Account acDest;
                Account acSource;
                this.sync.beginWrite();
                if (this.account1.getAmount() < this.account2.getAmount()) {
                    acSource = this.account1;
                    acDest = this.account2;
                } else {
                    acSource = this.account2;
                    acDest = this.account1;
                }
                long x = Math.round(this.random.nextDouble() * (double)(acSource.getAmount() - 1L)) + 1L;
                acSource.change(-x);
                acDest.change(x);
                this.sync.endWrite();
            }
        }
    }

    private static final class ReaderThread
    extends Thread {
        private final Account[] accounts;
        private final Synchronizer sync;
        private final int numberOfReads;
        private volatile int errors;

        public ReaderThread(Synchronizer s, int readCount, Account ... accs) {
            this.accounts = accs;
            this.sync = s;
            this.numberOfReads = readCount;
        }

        public int getErrors() {
            return this.errors;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.numberOfReads; ++i) {
                this.sync.beginRead();
                long sum = TestReadWriteSynchronizer.sumUpAccounts(this.accounts);
                this.sync.endRead();
                if (sum == 1000000L) continue;
                ++this.errors;
            }
        }
    }
}

