/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeMatcher;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractImmutableNodeHandlerTest {
    protected abstract NodeHandler<ImmutableNode> createHandler(ImmutableNode var1);

    @Test
    public void testGetParentForRoot() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Assertions.assertNull((Object)handler.getParent((Object)NodeStructureHelper.ROOT_AUTHORS_TREE));
    }

    @Test
    public void testGetParentInvalidNode() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode node = new ImmutableNode.Builder().name("unknown").create();
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.getParent((Object)node));
    }

    @Test
    public void testGetParentNode() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        for (int authorIdx = 0; authorIdx < NodeStructureHelper.authorsLength(); ++authorIdx) {
            ImmutableNode authorNode = NodeStructureHelper.nodeForKey((ImmutableNode)handler.getRootNode(), NodeStructureHelper.author(authorIdx));
            Assertions.assertSame((Object)handler.getRootNode(), (Object)handler.getParent((Object)authorNode), (String)("Wrong parent for " + NodeStructureHelper.author(authorIdx)));
            for (int workIdx = 0; workIdx < NodeStructureHelper.worksLength(authorIdx); ++workIdx) {
                String workKey = NodeStructureHelper.appendPath(NodeStructureHelper.author(authorIdx), NodeStructureHelper.work(authorIdx, workIdx));
                ImmutableNode workNode = NodeStructureHelper.nodeForKey((ImmutableNode)handler.getRootNode(), workKey);
                Assertions.assertSame((Object)authorNode, (Object)handler.getParent((Object)workNode), (String)("Wrong parent for " + workKey));
                for (int personaIdx = 0; personaIdx < NodeStructureHelper.personaeLength(authorIdx, workIdx); ++personaIdx) {
                    String personKey = NodeStructureHelper.appendPath(workKey, NodeStructureHelper.persona(authorIdx, workIdx, personaIdx));
                    ImmutableNode personNode = NodeStructureHelper.nodeForKey((ImmutableNode)handler.getRootNode(), personKey);
                    Assertions.assertSame((Object)workNode, (Object)handler.getParent((Object)personNode), (String)("Wrong parent for " + personKey));
                }
            }
        }
    }

    @Test
    public void testNodeHandlerGetAttributes() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, "Puck");
        Assertions.assertEquals(node.getAttributes().keySet(), (Object)handler.getAttributes((Object)node));
    }

    @Test
    public void testNodeHandlerGetAttributesImmutable() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, "Puck");
        Set attributes = handler.getAttributes((Object)node);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> attributes.add("test"));
    }

    @Test
    public void testNodeHandlerGetAttributeValue() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, "Prospero");
        Assertions.assertEquals((Object)"Shakespeare", (Object)handler.getAttributeValue((Object)node, "author"));
    }

    @Test
    public void testNodeHandlerGetChildAtIndex() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, NodeStructureHelper.author(0));
        Assertions.assertSame(node.getChildren().get(1), (Object)handler.getChild((Object)node, 1));
    }

    @Test
    public void testNodeHandlerGetChildren() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, NodeStructureHelper.author(0));
        Assertions.assertSame((Object)node.getChildren(), (Object)handler.getChildren((Object)node));
    }

    @Test
    public void testNodeHandlerGetChildrenByName() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String name = "Achilles";
        HashSet children = new HashSet(handler.getChildren((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, "Achilles"));
        Assertions.assertEquals((int)3, (int)children.size());
        for (ImmutableNode c : children) {
            Assertions.assertEquals((Object)"Achilles", (Object)c.getNodeName());
        }
    }

    @Test
    public void testNodeHandlerGetChildrenByNameImmutable() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        List children = handler.getChildren((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, "Ajax");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> children.add(null));
    }

    @Test
    public void testNodeHandlerGetChildrenCountAll() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, NodeStructureHelper.author(0));
        Assertions.assertEquals((int)NodeStructureHelper.worksLength(0), (int)handler.getChildrenCount((Object)node, null));
    }

    @Test
    public void testNodeHandlerGetChildrenCountSpecific() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        Assertions.assertEquals((int)3, (int)handler.getChildrenCount((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, "Achilles"));
    }

    @Test
    public void testNodeHandlerGetMatchingChildren() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        final ImmutableNode target = NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, NodeStructureHelper.author(1));
        final HashSet encounteredAuthors = new HashSet();
        NodeMatcher<ImmutableNode> matcher = new NodeMatcher<ImmutableNode>(){

            public <T> boolean matches(T node, NodeHandler<T> paramHandler, ImmutableNode criterion) {
                encounteredAuthors.add(paramHandler.nodeName(node));
                return node == target;
            }
        };
        List result = handler.getMatchingChildren((Object)((ImmutableNode)handler.getRootNode()), (NodeMatcher)matcher, (Object)target);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertSame((Object)target, result.get(0));
        HashSet<String> expectedAuthors = new HashSet<String>();
        for (int i = 0; i < NodeStructureHelper.authorsLength(); ++i) {
            expectedAuthors.add(NodeStructureHelper.author(i));
        }
        Assertions.assertEquals(expectedAuthors, encounteredAuthors);
    }

    @Test
    public void testNodeHandlerGetMatchingChildrenCount() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Assertions.assertEquals((int)NodeStructureHelper.authorsLength(), (int)handler.getMatchingChildrenCount((Object)((ImmutableNode)handler.getRootNode()), (NodeMatcher)new DummyNodeMatcher(), (Object)this));
    }

    @Test
    public void testNodeHandlerGetMatchingChildrenImmutable() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        List result = handler.getMatchingChildren((Object)((ImmutableNode)handler.getRootNode()), (NodeMatcher)new DummyNodeMatcher(), (Object)this);
        Assertions.assertThrows(UnsupportedOperationException.class, result::clear);
    }

    @Test
    public void testNodeHandlerHasAttributesFalse() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        Assertions.assertFalse((boolean)handler.hasAttributes((Object)NodeStructureHelper.ROOT_PERSONAE_TREE));
    }

    @Test
    public void testNodeHandlerHasAttributesTrue() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, "Puck");
        Assertions.assertTrue((boolean)handler.hasAttributes((Object)node));
    }

    @Test
    public void testNodeHandlerIndexOfChild() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        String key = "Simmons/Hyperion";
        ImmutableNode parent = NodeStructureHelper.nodeForKey(handler, "Simmons/Hyperion");
        ImmutableNode child = NodeStructureHelper.nodeForKey(handler, "Simmons/Hyperion/Weintraub");
        Assertions.assertEquals((int)3, (int)handler.indexOfChild((Object)parent, (Object)child));
    }

    @Test
    public void testNodeHandlerIndexOfUnknownChild() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode parent = NodeStructureHelper.nodeForKey(handler, "Homer/Ilias");
        ImmutableNode child = NodeStructureHelper.nodeForKey(handler, "Shakespeare/Troilus and Cressida/Achilles");
        Assertions.assertEquals((int)-1, (int)handler.indexOfChild((Object)parent, (Object)child));
    }

    @Test
    public void testNodeHandlerIsDefinedAttributes() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = new ImmutableNode.Builder().addAttribute("author", (Object)NodeStructureHelper.author(0)).create();
        Assertions.assertTrue((boolean)handler.isDefined((Object)node));
    }

    @Test
    public void testNodeHandlerIsDefinedChildren() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, NodeStructureHelper.author(2));
        Assertions.assertTrue((boolean)handler.isDefined((Object)node));
    }

    @Test
    public void testNodeHandlerIsDefinedFalse() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = new ImmutableNode.Builder().name(NodeStructureHelper.author(1)).create();
        Assertions.assertFalse((boolean)handler.isDefined((Object)node));
    }

    @Test
    public void testNodeHandlerIsDefinedValue() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = new ImmutableNode.Builder().value((Object)42).create();
        Assertions.assertTrue((boolean)handler.isDefined((Object)node));
    }

    @Test
    public void testNodeHandlerName() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode author = NodeStructureHelper.nodeForKey(handler, NodeStructureHelper.author(0));
        Assertions.assertEquals((Object)NodeStructureHelper.author(0), (Object)handler.nodeName((Object)author));
    }

    @Test
    public void testNodeHandlerValue() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode work = NodeStructureHelper.nodeForKey(handler, "Shakespeare/The Tempest");
        int year = 1611;
        work = work.setValue((Object)1611);
        Assertions.assertEquals((Object)1611, (Object)handler.getValue((Object)work));
    }

    private static final class DummyNodeMatcher
    implements NodeMatcher<Object> {
        private DummyNodeMatcher() {
        }

        public <T> boolean matches(T node, NodeHandler<T> handler, Object criterion) {
            return true;
        }
    }
}

