/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestXPathExpressionEngineInConfig {
    private static final String KEY = "test/expression/xpath";
    private static final String VALUE = "success";
    private XMLConfiguration config;

    @BeforeEach
    public void setUp() throws Exception {
        this.config = new XMLConfiguration();
        this.config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
    }

    @Test
    public void testAddPropertyComplexStructures() {
        this.config.addProperty("tables/table/name", (Object)"tasks");
        this.config.addProperty("tables/table[last()]/@type", (Object)"system");
        this.config.addProperty("tables/table[last()]/fields/field/name", (Object)"taskid");
        this.config.addProperty("tables/table[last()]/fields/field[last()]/@type", (Object)"int");
        this.config.addProperty("tables table/name", (Object)"documents");
        Assertions.assertEquals((Object)"tasks", (Object)this.config.getString("tables/table[1]/name"));
        Assertions.assertEquals((Object)"documents", (Object)this.config.getString("tables/table[2]/name"));
        Assertions.assertEquals((Object)"int", (Object)this.config.getString("tables/table[1]/fields/field[1]/@type"));
    }

    @Test
    public void testPropertiesWithNamespace() throws ConfigurationException {
        String xml = "<Config>\n<dsig:Transforms xmlns:dsig=\"http://www.w3.org/2000/09/xmldsig#\">\n  <dsig:Transform Algorithm=\"http://www.w3.org/TR/1999/REC-xpath-19991116\">\n    <dsig:XPath xmlns:ietf=\"http://www.ietf.org\" xmlns:pl=\"http://test.test\">self::pl:policy1</dsig:XPath>\n  </dsig:Transform>\n  <dsig:Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"/>\n</dsig:Transforms></Config>";
        FileHandler handler = new FileHandler((FileBased)this.config);
        handler.load((Reader)new StringReader("<Config>\n<dsig:Transforms xmlns:dsig=\"http://www.w3.org/2000/09/xmldsig#\">\n  <dsig:Transform Algorithm=\"http://www.w3.org/TR/1999/REC-xpath-19991116\">\n    <dsig:XPath xmlns:ietf=\"http://www.ietf.org\" xmlns:pl=\"http://test.test\">self::pl:policy1</dsig:XPath>\n  </dsig:Transform>\n  <dsig:Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"/>\n</dsig:Transforms></Config>"));
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assertions.assertNotNull((Object)this.config.getString(key), (String)("No value for " + key));
        }
    }

    @Test
    public void testSetPropertyExisting() {
        this.config.addProperty(" test/expression/xpath", (Object)"failure");
        this.config.setProperty(KEY, (Object)VALUE);
        Assertions.assertEquals((Object)VALUE, (Object)this.config.getString(KEY));
    }

    @Test
    public void testSetPropertyNewAttribute() {
        String keyAttr = "test/expression/xpath/@attr";
        this.config.addProperty(" test/expression/xpath", (Object)"test");
        this.config.setProperty("test/expression/xpath/@attr", (Object)VALUE);
        Assertions.assertEquals((Object)VALUE, (Object)this.config.getString("test/expression/xpath/@attr"));
    }

    @Test
    public void testSetPropertyNewKey() {
        this.config.setProperty(KEY, (Object)VALUE);
        Assertions.assertEquals((Object)VALUE, (Object)this.config.getString(KEY));
    }

    @Test
    public void testSetPropertyPartlyExisting() {
        String testKey = "test/expression/xpath/sub";
        this.config.addProperty(" test/expression/xpath", (Object)"test");
        this.config.setProperty("test/expression/xpath/sub", (Object)VALUE);
        Assertions.assertEquals((Object)VALUE, (Object)this.config.getString("test/expression/xpath/sub"));
    }
}

