/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.web;

import java.applet.Applet;
import java.util.Properties;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.TestAbstractConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.web.AppletConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAppletConfiguration
extends TestAbstractConfiguration {
    boolean supportsApplet;

    @Override
    protected AbstractConfiguration getConfiguration() {
        MapConfiguration config;
        final Properties parameters = new Properties();
        parameters.setProperty("key1", "value1");
        parameters.setProperty("key2", "value2");
        parameters.setProperty("list", "value1, value2");
        parameters.setProperty("listesc", "value1\\,value2");
        if (this.supportsApplet) {
            Applet applet = new Applet(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getParameter(String key) {
                    return parameters.getProperty(key);
                }

                @Override
                public String[][] getParameterInfo() {
                    return new String[][]{{"key1", "String", ""}, {"key2", "String", ""}, {"list", "String[]", ""}, {"listesc", "String", ""}};
                }
            };
            config = new AppletConfiguration(applet);
        } else {
            config = new MapConfiguration(parameters);
        }
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        return config;
    }

    @Override
    protected AbstractConfiguration getEmptyConfiguration() {
        if (this.supportsApplet) {
            return new AppletConfiguration(new Applet());
        }
        return new BaseConfiguration();
    }

    @BeforeEach
    public void setUp() throws Exception {
        try {
            new Applet();
            this.supportsApplet = true;
        }
        catch (Exception ex) {
            this.supportsApplet = false;
        }
    }

    @Override
    @Test
    public void testAddPropertyDirect() {
        if (this.supportsApplet) {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testAddPropertyDirect());
        }
    }

    @Override
    @Test
    public void testClearProperty() {
        if (this.supportsApplet) {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testClearProperty());
        }
    }
}

