/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationMap;
import org.apache.commons.configuration2.TestAbstractConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.web.ServletRequestConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestServletRequestConfiguration
extends TestAbstractConfiguration {
    private ServletRequestConfiguration createConfiguration(Configuration base) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getParameterMap()).thenAnswer(invocation -> new ConfigurationMap(base));
        Mockito.when((Object)request.getParameterValues((String)ArgumentMatchers.any())).thenAnswer(invocation -> {
            String key = (String)invocation.getArgument(0, String.class);
            return base.getStringArray(key);
        });
        ServletRequestConfiguration config = new ServletRequestConfiguration((ServletRequest)request);
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        return config;
    }

    @Override
    protected AbstractConfiguration getConfiguration() {
        BaseConfiguration configuration = new BaseConfiguration();
        configuration.setProperty("key1", (Object)"value1");
        configuration.setProperty("key2", (Object)"value2");
        configuration.addProperty("list", (Object)"value1");
        configuration.addProperty("list", (Object)"value2");
        configuration.addProperty("listesc", (Object)"value1\\,value2");
        return this.createConfiguration((Configuration)configuration);
    }

    @Override
    protected AbstractConfiguration getEmptyConfiguration() {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getParameter((String)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)request.getParameterMap()).thenAnswer(invocation -> new HashMap());
        return new ServletRequestConfiguration((ServletRequest)request);
    }

    @Override
    @Test
    public void testAddPropertyDirect() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testAddPropertyDirect());
    }

    @Override
    @Test
    public void testClearProperty() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testClearProperty());
    }

    @Test
    public void testListWithEscapedElements() {
        String[] values = new String[]{"test1", "test2\\,test3", "test4\\,test5"};
        String listKey = "test.list";
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("test.list", (Object)values);
        Assertions.assertEquals((int)values.length, (int)config.getList("test.list").size());
        ServletRequestConfiguration c = this.createConfiguration((Configuration)config);
        List v = c.getList("test.list");
        ArrayList<String> expected = new ArrayList<String>();
        for (String value : values) {
            expected.add(value.replace("\\", ""));
        }
        Assertions.assertEquals(expected, (Object)v);
    }
}

