/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.event;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.junit.Assert;

public abstract class AbstractEventListenerTestImpl<T extends Event>
implements EventListener<T> {
    private final Object expectedSource;
    private final List<T> events;

    protected AbstractEventListenerTestImpl(Object source) {
        this.expectedSource = source;
        this.events = new LinkedList<T>();
    }

    public void onEvent(T event) {
        this.events.add(event);
    }

    public void checkEventCount(int minEvents) {
        Assert.assertTrue((String)"Too view events received", (this.events.size() >= minEvents ? 1 : 0) != 0);
    }

    public T nextEvent(EventType<?> expectedType) {
        Assert.assertFalse((String)"Too few events received", (boolean)this.events.isEmpty());
        Event e = (Event)this.events.remove(0);
        if (this.expectedSource != null) {
            Assert.assertEquals((String)"Wrong event source", (Object)this.expectedSource, (Object)e.getSource());
        }
        Assert.assertEquals((String)"Wrong event type", expectedType, (Object)e.getEventType());
        return (T)e;
    }

    public void skipToLast(EventType<?> type) {
        while (this.events.size() > 1) {
            Event e = (Event)this.events.remove(0);
            Assert.assertTrue((String)"Found end event in details", (type != e.getEventType() ? 1 : 0) != 0);
        }
    }

    public void done() {
        Assert.assertTrue((String)"Too many events received", (boolean)this.events.isEmpty());
    }
}

