/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.net.URL;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.FileSystemLocationStrategy;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFileSystemLocationStrategy {
    private FileSystemLocationStrategy strategy;

    @Before
    public void setUp() throws Exception {
        this.strategy = new FileSystemLocationStrategy();
    }

    @Test
    public void testLocate() {
        FileSystem fs = (FileSystem)EasyMock.createMock(FileSystem.class);
        URL url = ConfigurationAssert.getTestURL("test.xml");
        String basePath = "testBasePath";
        String fileName = "testFileName.txt";
        EasyMock.expect((Object)fs.locateFromURL("testBasePath", "testFileName.txt")).andReturn((Object)url);
        EasyMock.replay((Object[])new Object[]{fs});
        FileLocator locator = FileLocatorUtils.fileLocator().basePath("testBasePath").fileName("testFileName.txt").fileSystem(FileLocatorUtils.DEFAULT_FILE_SYSTEM).sourceURL(ConfigurationAssert.getTestURL("test.properties")).create();
        Assert.assertSame((String)"Wrong result", (Object)url, (Object)this.strategy.locate(fs, locator));
        EasyMock.verify((Object[])new Object[]{fs});
    }
}

