/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.junit.Assert;

public class InterpolationTestHelper {
    public static void testGetInterpolator(AbstractConfiguration config) {
        config.addProperty("var", (Object)"${echo:testVar}");
        ConfigurationInterpolator interpol = config.getInterpolator();
        interpol.registerLookup("echo", varName -> "Value of variable " + varName);
        Assert.assertEquals((String)"Wrong value of echo variable", (Object)"Value of variable testVar", (Object)config.getString("var"));
    }

    public static Configuration testInterpolatedConfiguration(AbstractConfiguration config) {
        config.setProperty("applicationRoot", (Object)"/home/applicationRoot");
        config.setProperty("db", (Object)"${applicationRoot}/db/hypersonic");
        config.setProperty("inttest.interpol", (Object)"${unknown.property}");
        config.setProperty("intkey.code", (Object)"${const:java.awt.event.KeyEvent.VK_CANCEL}");
        config.setProperty("inttest.sysprop", (Object)"${sys:java.version}");
        config.setProperty("inttest.numvalue", (Object)"3\\,1415");
        config.setProperty("inttest.value", (Object)"${inttest.numvalue}");
        config.setProperty("inttest.list", (Object)"${db}");
        config.addProperty("inttest.list", (Object)"${inttest.value}");
        Configuration c = config.interpolatedConfiguration();
        Assert.assertEquals((String)"Property not replaced", (Object)"/home/applicationRoot/db/hypersonic", (Object)c.getProperty("db"));
        Assert.assertEquals((String)"Const variable not replaced", (long)3L, (long)c.getInt("intkey.code"));
        Assert.assertEquals((String)"Sys property not replaced", (Object)System.getProperty("java.version"), (Object)c.getProperty("inttest.sysprop"));
        Assert.assertEquals((String)"Delimiter value not replaced", (Object)"3,1415", (Object)c.getProperty("inttest.value"));
        List lst = (List)c.getProperty("inttest.list");
        Assert.assertEquals((String)"Wrong number of list elements", (long)2L, (long)lst.size());
        Assert.assertEquals((String)"List element 0 not replaced", (Object)"/home/applicationRoot/db/hypersonic", lst.get(0));
        Assert.assertEquals((String)"List element 1 not replaced", (Object)"3,1415", lst.get(1));
        Assert.assertEquals((String)"Unresolvable variable not found", (Object)"${unknown.property}", (Object)c.getProperty("inttest.interpol"));
        return c;
    }

    public static void testInterpolation(Configuration config) {
        config.setProperty("applicationRoot", (Object)"/home/applicationRoot");
        config.setProperty("db", (Object)"${applicationRoot}/db/hypersonic");
        String unInterpolatedValue = "${applicationRoot2}/db/hypersonic";
        config.setProperty("dbFailedInterpolate", (Object)"${applicationRoot2}/db/hypersonic");
        String dbProp = "/home/applicationRoot/db/hypersonic";
        Assert.assertEquals((String)"Checking interpolated variable", (Object)"/home/applicationRoot/db/hypersonic", (Object)config.getString("db"));
        Assert.assertEquals((String)"lookup fails, leave variable as is", (Object)config.getString("dbFailedInterpolate"), (Object)"${applicationRoot2}/db/hypersonic");
        config.setProperty("arrayInt", (Object)"${applicationRoot}/1");
        String[] arrayInt = config.getStringArray("arrayInt");
        Assert.assertEquals((String)"check first entry was interpolated", (Object)"/home/applicationRoot/1", (Object)arrayInt[0]);
        config.addProperty("path", Arrays.asList("/temp", "C:\\Temp", "/usr/local/tmp"));
        config.setProperty("path.current", (Object)"${path}");
        Assert.assertEquals((String)"Interpolation with multi-valued property", (Object)"/temp", (Object)config.getString("path.current"));
    }

    public static void testInterpolationConstants(Configuration config) {
        config.addProperty("key.code", (Object)"${const:java.awt.event.KeyEvent.VK_CANCEL}");
        Assert.assertEquals((String)"Wrong value of constant variable", (long)3L, (long)config.getInt("key.code"));
        Assert.assertEquals((String)"Wrong value when fetching constant from cache", (long)3L, (long)config.getInt("key.code"));
    }

    public static void testInterpolationEnvironment(Configuration config) {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> e : env.entrySet()) {
            config.addProperty("prop" + e.getKey(), (Object)("${env:" + e.getKey() + "}"));
        }
        for (Map.Entry<String, String> e : env.entrySet()) {
            Assert.assertEquals((String)("Wrong value for environment property " + e.getKey()), (Object)e.getValue(), (Object)config.getString("prop" + e.getKey()));
        }
    }

    public static void testInterpolationEscaped(Configuration config) {
        config.addProperty("var", (Object)"x");
        config.addProperty("escVar", (Object)"Use the variable $${${var}}.");
        Assert.assertEquals((String)"Wrong escaped variable", (Object)"Use the variable ${x}.", (Object)config.getString("escVar"));
    }

    public static void testInterpolationLocalhost(Configuration config) {
        int i;
        String[] localhostKeys = new String[]{"name", "canonical-name", "address"};
        String[] localhostValues = null;
        try {
            localhostValues = new String[]{InetAddress.getLocalHost().getHostName(), InetAddress.getLocalHost().getCanonicalHostName(), InetAddress.getLocalHost().getHostAddress()};
        }
        catch (UnknownHostException e) {
            junitx.framework.Assert.fail((Throwable)e);
        }
        for (i = 0; i < localhostKeys.length; ++i) {
            config.addProperty("prop" + i, (Object)("${localhost:" + localhostKeys[i] + "}"));
        }
        for (i = 0; i < localhostKeys.length; ++i) {
            Assert.assertEquals((String)("Wrong value for system property " + localhostKeys[i]), (Object)localhostValues[i], (Object)config.getString("prop" + i));
        }
    }

    public static void testInterpolationLoop(Configuration config) {
        config.setProperty("test.a", (Object)"${test.b}");
        config.setProperty("test.b", (Object)"${test.a}");
        try {
            config.getString("test.a");
            Assert.fail((String)"IllegalStateException should have been thrown for looped property references");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void testInterpolationSubset(Configuration config) {
        config.addProperty("test.a", (Object)42);
        config.addProperty("test.b", (Object)"${test.a}");
        Assert.assertEquals((String)"Wrong interpolated value", (long)42L, (long)config.getInt("test.b"));
        Configuration subset = config.subset("test");
        Assert.assertEquals((String)"Wrong string property", (Object)"42", (Object)subset.getString("b"));
        Assert.assertEquals((String)"Wrong int property", (long)42L, (long)subset.getInt("b"));
    }

    public static void testInterpolationSystemProperties(Configuration config) {
        int i;
        String[] sysProperties = new String[]{"java.version", "java.vendor", "os.name", "java.class.path"};
        for (i = 0; i < sysProperties.length; ++i) {
            config.addProperty("prop" + i, (Object)("${sys:" + sysProperties[i] + "}"));
        }
        for (i = 0; i < sysProperties.length; ++i) {
            Assert.assertEquals((String)("Wrong value for system property " + sysProperties[i]), (Object)System.getProperty(sysProperties[i]), (Object)config.getString("prop" + i));
        }
    }

    public static void testInterpolationUnknownProperty(Configuration config) {
        config.addProperty("test.interpol", (Object)"${unknown.property}");
        Assert.assertEquals((String)"Wrong interpolated unknown property", (Object)"${unknown.property}", (Object)config.getString("test.interpol"));
    }

    public static void testMultipleInterpolation(Configuration config) {
        config.setProperty("test.base-level", (Object)"/base-level");
        config.setProperty("test.first-level", (Object)"${test.base-level}/first-level");
        config.setProperty("test.second-level", (Object)"${test.first-level}/second-level");
        config.setProperty("test.third-level", (Object)"${test.second-level}/third-level");
        String expectedValue = "/base-level/first-level/second-level/third-level";
        Assert.assertEquals((Object)config.getString("test.third-level"), (Object)"/base-level/first-level/second-level/third-level");
    }
}

