/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.ConfigurationLookup;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationLookup {
    private static final String VAR = "testVariable";
    private static final Object VALUE = "SomeTestValue";

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoConfig() {
        new ConfigurationLookup(null);
    }

    @Test
    public void testLookupComplex() {
        int count = 5;
        BaseConfiguration conf = new BaseConfiguration();
        for (int i = 0; i < 5; ++i) {
            conf.addProperty(VAR, (Object)(String.valueOf(VALUE) + i));
        }
        ConfigurationLookup lookup = new ConfigurationLookup((ImmutableConfiguration)conf);
        Collection col = (Collection)lookup.lookup(VAR);
        Assert.assertEquals((String)"Wrong number of elements", (long)5L, (long)col.size());
        Iterator it = col.iterator();
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("Wrong element at " + i), (Object)(String.valueOf(VALUE) + i), it.next());
        }
    }

    @Test
    public void testLookupNotFound() {
        BaseConfiguration conf = new BaseConfiguration();
        ConfigurationLookup lookup = new ConfigurationLookup((ImmutableConfiguration)conf);
        Assert.assertNull((String)"Got a value", (Object)lookup.lookup(VAR));
    }

    @Test
    public void testLookupNotFoundEx() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setThrowExceptionOnMissing(true);
        ConfigurationLookup lookup = new ConfigurationLookup((ImmutableConfiguration)conf);
        Assert.assertNull((String)"Got a value", (Object)lookup.lookup(VAR));
    }

    @Test
    public void testLookupSuccess() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.addProperty(VAR, VALUE);
        ConfigurationLookup lookup = new ConfigurationLookup((ImmutableConfiguration)conf);
        Assert.assertEquals((String)"Wrong result", (Object)VALUE, (Object)lookup.lookup(VAR));
    }
}

