/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import jakarta.mail.internet.InternetAddress;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import junitx.framework.ArrayAssert;
import junitx.framework.ListAssert;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.DataConfiguration;
import org.apache.commons.configuration2.convert.ConversionHandler;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConversionException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDataConfiguration {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private DataConfiguration conf;

    private static Date expectedDate() throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        return format.parse("2004-01-01");
    }

    @Before
    public void setUp() throws Exception {
        BaseConfiguration baseConfig = new BaseConfiguration();
        baseConfig.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        this.conf = new DataConfiguration((Configuration)baseConfig);
        this.conf.addProperty("empty", (Object)"");
        this.conf.addProperty("boolean.list1", (Object)"true");
        this.conf.addProperty("boolean.list1", (Object)"false");
        this.conf.addProperty("boolean.list2", (Object)"true, false");
        this.conf.addProperty("boolean.list3", (Object)Boolean.TRUE);
        this.conf.addProperty("boolean.list3", (Object)Boolean.FALSE);
        this.conf.addPropertyDirect("boolean.list4", (Object)new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        this.conf.addPropertyDirect("boolean.list5", (Object)new boolean[]{true, false});
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        booleans.add(Boolean.TRUE);
        booleans.add(Boolean.FALSE);
        this.conf.addProperty("boolean.list6", booleans);
        this.conf.addProperty("boolean.string", (Object)"true");
        this.conf.addProperty("boolean.object", (Object)Boolean.TRUE);
        this.conf.addProperty("boolean.list.interpolated", (Object)"${boolean.string},false");
        this.conf.addProperty("byte.list1", (Object)"1");
        this.conf.addProperty("byte.list1", (Object)"2");
        this.conf.addProperty("byte.list2", (Object)"1, 2");
        this.conf.addProperty("byte.list3", (Object)Byte.valueOf("1"));
        this.conf.addProperty("byte.list3", (Object)Byte.valueOf("2"));
        this.conf.addPropertyDirect("byte.list4", (Object)new Byte[]{Byte.valueOf("1"), Byte.valueOf("2")});
        this.conf.addPropertyDirect("byte.list5", (Object)new byte[]{1, 2});
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        bytes.add(Byte.valueOf("1"));
        bytes.add(Byte.valueOf("2"));
        this.conf.addProperty("byte.list6", bytes);
        this.conf.addProperty("byte.string", (Object)"1");
        this.conf.addProperty("byte.object", (Object)Byte.valueOf("1"));
        this.conf.addProperty("byte.list.interpolated", (Object)"${byte.string},2");
        this.conf.addProperty("short.list1", (Object)"1");
        this.conf.addProperty("short.list1", (Object)"2");
        this.conf.addProperty("short.list2", (Object)"1, 2");
        this.conf.addProperty("short.list3", (Object)Short.valueOf("1"));
        this.conf.addProperty("short.list3", (Object)Short.valueOf("2"));
        this.conf.addPropertyDirect("short.list4", (Object)new Short[]{Short.valueOf("1"), Short.valueOf("2")});
        this.conf.addPropertyDirect("short.list5", (Object)new short[]{1, 2});
        ArrayList<Short> shorts = new ArrayList<Short>();
        shorts.add(Short.valueOf("1"));
        shorts.add(Short.valueOf("2"));
        this.conf.addProperty("short.list6", shorts);
        this.conf.addProperty("short.string", (Object)"1");
        this.conf.addProperty("short.object", (Object)Short.valueOf("1"));
        this.conf.addProperty("short.list.interpolated", (Object)"${short.string},2");
        this.conf.addProperty("integer.list1", (Object)"1");
        this.conf.addProperty("integer.list1", (Object)"2");
        this.conf.addProperty("integer.list2", (Object)"1, 2");
        this.conf.addProperty("integer.list3", (Object)Integer.valueOf("1"));
        this.conf.addProperty("integer.list3", (Object)Integer.valueOf("2"));
        this.conf.addPropertyDirect("integer.list4", (Object)new Integer[]{Integer.valueOf("1"), Integer.valueOf("2")});
        this.conf.addPropertyDirect("integer.list5", (Object)new int[]{1, 2});
        ArrayList<Integer> integers = new ArrayList<Integer>();
        integers.add(Integer.valueOf("1"));
        integers.add(Integer.valueOf("2"));
        this.conf.addProperty("integer.list6", integers);
        this.conf.addProperty("integer.string", (Object)"1");
        this.conf.addProperty("integer.object", (Object)Integer.valueOf("1"));
        this.conf.addProperty("integer.list.interpolated", (Object)"${integer.string},2");
        this.conf.addProperty("long.list1", (Object)"1");
        this.conf.addProperty("long.list1", (Object)"2");
        this.conf.addProperty("long.list2", (Object)"1, 2");
        this.conf.addProperty("long.list3", (Object)Long.valueOf("1"));
        this.conf.addProperty("long.list3", (Object)Long.valueOf("2"));
        this.conf.addPropertyDirect("long.list4", (Object)new Long[]{Long.valueOf("1"), Long.valueOf("2")});
        this.conf.addPropertyDirect("long.list5", (Object)new long[]{1L, 2L});
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(Long.valueOf("1"));
        longs.add(Long.valueOf("2"));
        this.conf.addProperty("long.list6", longs);
        this.conf.addProperty("long.string", (Object)"1");
        this.conf.addProperty("long.object", (Object)Long.valueOf("1"));
        this.conf.addProperty("long.list.interpolated", (Object)"${long.string},2");
        this.conf.addProperty("float.list1", (Object)"1");
        this.conf.addProperty("float.list1", (Object)"2");
        this.conf.addProperty("float.list2", (Object)"1, 2");
        this.conf.addProperty("float.list3", (Object)Float.valueOf("1"));
        this.conf.addProperty("float.list3", (Object)Float.valueOf("2"));
        this.conf.addPropertyDirect("float.list4", (Object)new Float[]{Float.valueOf("1"), Float.valueOf("2")});
        this.conf.addPropertyDirect("float.list5", (Object)new float[]{1.0f, 2.0f});
        ArrayList<Float> floats = new ArrayList<Float>();
        floats.add(Float.valueOf("1"));
        floats.add(Float.valueOf("2"));
        this.conf.addProperty("float.list6", floats);
        this.conf.addProperty("float.string", (Object)"1");
        this.conf.addProperty("float.object", (Object)Float.valueOf("1"));
        this.conf.addProperty("float.list.interpolated", (Object)"${float.string},2");
        this.conf.addProperty("double.list1", (Object)"1");
        this.conf.addProperty("double.list1", (Object)"2");
        this.conf.addProperty("double.list2", (Object)"1, 2");
        this.conf.addProperty("double.list3", (Object)Double.valueOf("1"));
        this.conf.addProperty("double.list3", (Object)Double.valueOf("2"));
        this.conf.addPropertyDirect("double.list4", (Object)new Double[]{Double.valueOf("1"), Double.valueOf("2")});
        this.conf.addPropertyDirect("double.list5", (Object)new double[]{1.0, 2.0});
        ArrayList<Double> doubles = new ArrayList<Double>();
        doubles.add(Double.valueOf("1"));
        doubles.add(Double.valueOf("2"));
        this.conf.addProperty("double.list6", doubles);
        this.conf.addProperty("double.string", (Object)"1");
        this.conf.addProperty("double.object", (Object)Double.valueOf("1"));
        this.conf.addProperty("double.list.interpolated", (Object)"${double.string},2");
        this.conf.addProperty("biginteger.list1", (Object)"1");
        this.conf.addProperty("biginteger.list1", (Object)"2");
        this.conf.addProperty("biginteger.list2", (Object)"1, 2");
        this.conf.addProperty("biginteger.list3", (Object)new BigInteger("1"));
        this.conf.addProperty("biginteger.list3", (Object)new BigInteger("2"));
        this.conf.addPropertyDirect("biginteger.list4", (Object)new BigInteger[]{new BigInteger("1"), new BigInteger("2")});
        ArrayList<BigInteger> bigintegers = new ArrayList<BigInteger>();
        bigintegers.add(new BigInteger("1"));
        bigintegers.add(new BigInteger("2"));
        this.conf.addProperty("biginteger.list6", bigintegers);
        this.conf.addProperty("biginteger.string", (Object)"1");
        this.conf.addProperty("biginteger.object", (Object)new BigInteger("1"));
        this.conf.addProperty("biginteger.list.interpolated", (Object)"${biginteger.string},2");
        this.conf.addProperty("bigdecimal.list1", (Object)"1");
        this.conf.addProperty("bigdecimal.list1", (Object)"2");
        this.conf.addProperty("bigdecimal.list2", (Object)"1, 2");
        this.conf.addProperty("bigdecimal.list3", (Object)new BigDecimal("1"));
        this.conf.addProperty("bigdecimal.list3", (Object)new BigDecimal("2"));
        this.conf.addPropertyDirect("bigdecimal.list4", (Object)new BigDecimal[]{new BigDecimal("1"), new BigDecimal("2")});
        ArrayList<BigDecimal> bigdecimals = new ArrayList<BigDecimal>();
        bigdecimals.add(new BigDecimal("1"));
        bigdecimals.add(new BigDecimal("2"));
        this.conf.addProperty("bigdecimal.list6", bigdecimals);
        this.conf.addProperty("bigdecimal.string", (Object)"1");
        this.conf.addProperty("bigdecimal.object", (Object)new BigDecimal("1"));
        this.conf.addProperty("bigdecimal.list.interpolated", (Object)"${bigdecimal.string},2");
        String uri1 = "http://jakarta.apache.org";
        String uri2 = "http://www.apache.org";
        this.conf.addProperty("uri.string", (Object)"http://jakarta.apache.org");
        this.conf.addProperty("uri.string.interpolated", (Object)"${uri.string}");
        this.conf.addProperty("uri.object", (Object)new URI("http://jakarta.apache.org"));
        this.conf.addProperty("uri.list1", (Object)"http://jakarta.apache.org");
        this.conf.addProperty("uri.list1", (Object)"http://www.apache.org");
        this.conf.addProperty("uri.list2", (Object)"http://jakarta.apache.org, http://www.apache.org");
        this.conf.addProperty("uri.list3", (Object)new URI("http://jakarta.apache.org"));
        this.conf.addProperty("uri.list3", (Object)new URI("http://www.apache.org"));
        this.conf.addPropertyDirect("uri.list4", (Object)new URI[]{new URI("http://jakarta.apache.org"), new URI("http://www.apache.org")});
        ArrayList<URI> uris = new ArrayList<URI>();
        uris.add(new URI("http://jakarta.apache.org"));
        uris.add(new URI("http://www.apache.org"));
        this.conf.addProperty("uri.list6", uris);
        this.conf.addProperty("uri.list.interpolated", (Object)"${uri.string},http://www.apache.org");
        String url1 = "http://jakarta.apache.org";
        String url2 = "http://www.apache.org";
        this.conf.addProperty("url.string", (Object)"http://jakarta.apache.org");
        this.conf.addProperty("url.string.interpolated", (Object)"${url.string}");
        this.conf.addProperty("url.object", (Object)new URL("http://jakarta.apache.org"));
        this.conf.addProperty("url.list1", (Object)"http://jakarta.apache.org");
        this.conf.addProperty("url.list1", (Object)"http://www.apache.org");
        this.conf.addProperty("url.list2", (Object)"http://jakarta.apache.org, http://www.apache.org");
        this.conf.addProperty("url.list3", (Object)new URL("http://jakarta.apache.org"));
        this.conf.addProperty("url.list3", (Object)new URL("http://www.apache.org"));
        this.conf.addPropertyDirect("url.list4", (Object)new URL[]{new URL("http://jakarta.apache.org"), new URL("http://www.apache.org")});
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new URL("http://jakarta.apache.org"));
        urls.add(new URL("http://www.apache.org"));
        this.conf.addProperty("url.list6", urls);
        this.conf.addProperty("url.list.interpolated", (Object)"${url.string},http://www.apache.org");
        this.conf.addProperty("locale.string", (Object)"fr");
        this.conf.addProperty("locale.string.interpolated", (Object)"${locale.string}");
        this.conf.addProperty("locale.object", (Object)Locale.FRENCH);
        this.conf.addProperty("locale.list1", (Object)"fr");
        this.conf.addProperty("locale.list1", (Object)"de");
        this.conf.addProperty("locale.list2", (Object)"fr, de");
        this.conf.addProperty("locale.list3", (Object)Locale.FRENCH);
        this.conf.addProperty("locale.list3", (Object)Locale.GERMAN);
        this.conf.addPropertyDirect("locale.list4", (Object)new Locale[]{Locale.FRENCH, Locale.GERMAN});
        ArrayList<Locale> locales = new ArrayList<Locale>();
        locales.add(Locale.FRENCH);
        locales.add(Locale.GERMAN);
        this.conf.addProperty("locale.list6", locales);
        this.conf.addProperty("locale.list.interpolated", (Object)"${locale.string},de");
        String color1 = "FF0000";
        String color2 = "0000FF";
        this.conf.addProperty("color.string", (Object)"FF0000");
        this.conf.addProperty("color.string.interpolated", (Object)"${color.string}");
        this.conf.addProperty("color.object", (Object)Color.red);
        this.conf.addProperty("color.list1", (Object)"FF0000");
        this.conf.addProperty("color.list1", (Object)"0000FF");
        this.conf.addProperty("color.list2", (Object)"FF0000, 0000FF");
        this.conf.addProperty("color.list3", (Object)Color.red);
        this.conf.addProperty("color.list3", (Object)Color.blue);
        this.conf.addPropertyDirect("color.list4", (Object)new Color[]{Color.red, Color.blue});
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(Color.red);
        colors.add(Color.blue);
        this.conf.addProperty("color.list6", colors);
        this.conf.addProperty("color.list.interpolated", (Object)"${color.string},0000FF");
        String pattern = DATE_PATTERN;
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        this.conf.setProperty("org.apache.commons.configuration.format.date", (Object)DATE_PATTERN);
        Date date1 = format.parse("2004-01-01");
        Date date2 = format.parse("2004-12-31");
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        this.conf.addProperty("date.string", (Object)"2004-01-01");
        this.conf.addProperty("date.string.interpolated", (Object)"${date.string}");
        this.conf.addProperty("date.object", (Object)date1);
        this.conf.addProperty("date.list1", (Object)"2004-01-01");
        this.conf.addProperty("date.list1", (Object)"2004-12-31");
        this.conf.addProperty("date.list2", (Object)"2004-01-01, 2004-12-31");
        this.conf.addProperty("date.list3", (Object)date1);
        this.conf.addProperty("date.list3", (Object)date2);
        this.conf.addPropertyDirect("date.list4", (Object)new Date[]{date1, date2});
        this.conf.addPropertyDirect("date.list5", (Object)new Calendar[]{calendar1, calendar2});
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.add(date1);
        dates.add(date2);
        this.conf.addProperty("date.list6", dates);
        this.conf.addProperty("date.list.interpolated", (Object)"${date.string},2004-12-31");
        this.conf.addPropertyDirect("date.list7", (Object)new String[]{"2004-01-01", "2004-12-31"});
        this.conf.addProperty("calendar.string", (Object)"2004-01-01");
        this.conf.addProperty("calendar.string.interpolated", (Object)"${calendar.string}");
        this.conf.addProperty("calendar.object", (Object)calendar1);
        this.conf.addProperty("calendar.list1", (Object)"2004-01-01");
        this.conf.addProperty("calendar.list1", (Object)"2004-12-31");
        this.conf.addProperty("calendar.list2", (Object)"2004-01-01, 2004-12-31");
        this.conf.addProperty("calendar.list3", (Object)calendar1);
        this.conf.addProperty("calendar.list3", (Object)calendar2);
        this.conf.addPropertyDirect("calendar.list4", (Object)new Calendar[]{calendar1, calendar2});
        this.conf.addPropertyDirect("calendar.list5", (Object)new Date[]{date1, date2});
        ArrayList<Date> calendars = new ArrayList<Date>();
        calendars.add(date1);
        calendars.add(date2);
        this.conf.addProperty("calendar.list6", calendars);
        this.conf.addProperty("calendar.list.interpolated", (Object)"${calendar.string},2004-12-31");
        this.conf.addPropertyDirect("calendar.list7", (Object)new String[]{"2004-01-01", "2004-12-31"});
        this.conf.addProperty("ip.string", (Object)"127.0.0.1");
        this.conf.addProperty("ip.string.interpolated", (Object)"${ip.string}");
        this.conf.addProperty("ip.object", (Object)InetAddress.getByName("127.0.0.1"));
        this.conf.addProperty("email.string", (Object)"dev@test.org");
        this.conf.addProperty("email.string.interpolated", (Object)"${email.string}");
        this.conf.addProperty("email.object", (Object)new InternetAddress("dev@test.org"));
    }

    @Test
    public void testClearProperty() {
        String key = "test.property";
        this.conf.addProperty("test.property", (Object)"someValue");
        this.conf.clearProperty("test.property");
        Assert.assertFalse((String)"Property still found", (boolean)this.conf.containsKey("test.property"));
    }

    @Test
    public void testClearPropertyDirect() {
        String key = "test.property";
        this.conf.addProperty("test.property", (Object)"someValue");
        this.conf.clearPropertyDirect("test.property");
        Assert.assertFalse((String)"Property still found", (boolean)this.conf.containsKey("test.property"));
    }

    @Test
    public void testClearPropertyDirectNoAbstractConf() {
        Configuration wrapped = (Configuration)EasyMock.createMock(Configuration.class);
        String key = "test.property";
        wrapped.clearProperty("test.property");
        EasyMock.replay((Object[])new Object[]{wrapped});
        this.conf = new DataConfiguration(wrapped);
        this.conf.clearPropertyDirect("test.property");
        EasyMock.verify((Object[])new Object[]{wrapped});
    }

    @Test
    public void testContainsKey() {
        BaseConfiguration baseconf = new BaseConfiguration();
        DataConfiguration conf = new DataConfiguration((Configuration)baseconf);
        Assert.assertFalse((boolean)conf.containsKey("foo"));
        baseconf.setProperty("foo", (Object)"bar");
        Assert.assertTrue((boolean)conf.containsKey("foo"));
    }

    @Test
    public void testConversionException() throws Exception {
        this.conf.addProperty("key1", new Object());
        this.conf.addProperty("key2", (Object)"xxxxxx");
        try {
            this.conf.getBooleanArray("key1");
            Assert.fail((String)"getBooleanArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getBooleanArray("key2");
            Assert.fail((String)"getBooleanArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getBooleanList("key1");
            Assert.fail((String)"getBooleanList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getBooleanList("key2");
            Assert.fail((String)"getBooleanList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getByteArray("key1");
            Assert.fail((String)"getByteArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getByteArray("key2");
            Assert.fail((String)"getByteArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getByteList("key1");
            Assert.fail((String)"getByteList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getByteList("key2");
            Assert.fail((String)"getByteList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getShortArray("key1");
            Assert.fail((String)"getShortArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getShortArray("key2");
            Assert.fail((String)"getShortArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getShortList("key1");
            Assert.fail((String)"getShortList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getShortList("key2");
            Assert.fail((String)"getShortList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getIntArray("key1");
            Assert.fail((String)"getIntArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getIntArray("key2");
            Assert.fail((String)"getIntArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getIntegerList("key1");
            Assert.fail((String)"getIntegerList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getIntegerList("key2");
            Assert.fail((String)"getIntegerList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getLongArray("key1");
            Assert.fail((String)"getLongArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getLongArray("key2");
            Assert.fail((String)"getLongArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getLongList("key1");
            Assert.fail((String)"getLongList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getLongList("key2");
            Assert.fail((String)"getLongList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getFloatArray("key1");
            Assert.fail((String)"getFloatArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getFloatArray("key2");
            Assert.fail((String)"getFloatArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getFloatList("key1");
            Assert.fail((String)"getFloatList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getFloatList("key2");
            Assert.fail((String)"getFloatList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getDoubleArray("key1");
            Assert.fail((String)"getDoubleArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getDoubleArray("key2");
            Assert.fail((String)"getDoubleArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getDoubleList("key1");
            Assert.fail((String)"getDoubleList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getDoubleList("key2");
            Assert.fail((String)"getDoubleList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getBigIntegerArray("key1");
            Assert.fail((String)"getBigIntegerArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getBigIntegerArray("key2");
            Assert.fail((String)"getBigIntegerArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getBigIntegerList("key1");
            Assert.fail((String)"getBigIntegerList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getBigIntegerList("key2");
            Assert.fail((String)"getBigIntegerList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getBigDecimalArray("key1");
            Assert.fail((String)"getBigDecimalArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getBigDecimalArray("key2");
            Assert.fail((String)"getBigDecimalArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getBigDecimalList("key1");
            Assert.fail((String)"getBigDecimalList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getBigDecimalList("key2");
            Assert.fail((String)"getBigDecimalList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getURLArray("key1");
            Assert.fail((String)"getURLArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getURLArray("key2");
            Assert.fail((String)"getURLArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getURLList("key1");
            Assert.fail((String)"getURLList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getURLList("key2");
            Assert.fail((String)"getURLList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getLocaleArray("key1");
            Assert.fail((String)"getLocaleArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getLocaleArray("key2");
            Assert.fail((String)"getLocaleArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getLocaleList("key1");
            Assert.fail((String)"getLocaleList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getLocaleList("key2");
            Assert.fail((String)"getLocaleList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getColorArray("key1");
            Assert.fail((String)"getColorArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getColorArray("key2");
            Assert.fail((String)"getColorArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getColorList("key1");
            Assert.fail((String)"getColorList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getColorList("key2");
            Assert.fail((String)"getColorList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getDateArray("key1");
            Assert.fail((String)"getDateArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getDate("key1", DATE_PATTERN);
            Assert.fail((String)"getDate didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getDate("key2", DATE_PATTERN);
            Assert.fail((String)"getDate didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getDateArray("key2");
            Assert.fail((String)"getDateArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getDateList("key1");
            Assert.fail((String)"getDateList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getDateList("key2");
            Assert.fail((String)"getDateList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getCalendar("key1", DATE_PATTERN);
            Assert.fail((String)"getCalendar didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getCalendar("key2", DATE_PATTERN);
            Assert.fail((String)"getCalendar didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getCalendarArray("key1");
            Assert.fail((String)"getCalendarArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getCalendarArray("key2");
            Assert.fail((String)"getCalendarArray didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getCalendarList("key1");
            Assert.fail((String)"getCalendarList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.getCalendarList("key2");
            Assert.fail((String)"getCalendarList didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.get(InetAddress.class, "key1");
            Assert.fail((String)"getInetAddress didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            this.conf.get(InternetAddress.class, "key1");
            Assert.fail((String)"getInternetAddress didn't throw a ConversionException");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    @Test
    public void testConversionExceptionCause() {
        try {
            this.conf.get(Integer.TYPE, "uri.string");
            Assert.fail((String)"No conversion exception thrown!");
        }
        catch (ConversionException cex) {
            Assert.assertTrue((String)"Wrong cause", (boolean)(cex.getCause() instanceof NumberFormatException));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetArrayInvalidDefaultType() {
        this.conf.getArray(Boolean.class, "unknownkey", (Object)new URL[0]);
    }

    @Test
    public void testGetBigDecimalArray() {
        Object[] defaultValue = new BigDecimal[]{new BigDecimal("2"), new BigDecimal("1")};
        ArrayAssert.assertEquals((Object[])defaultValue, (Object[])this.conf.getBigDecimalArray("bigdecimal.list", (BigDecimal[])defaultValue));
        Object[] expected = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("2")};
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list1"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list2"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list3"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list4"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list6"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigDecimalArray("bigdecimal.list.interpolated"));
        ArrayAssert.assertEquals((Object[])new BigDecimal[]{new BigDecimal("1")}, (Object[])this.conf.getBigDecimalArray("bigdecimal.string"));
        ArrayAssert.assertEquals((Object[])new BigDecimal[]{new BigDecimal("1")}, (Object[])this.conf.getBigDecimalArray("bigdecimal.object"));
        ArrayAssert.assertEquals((Object[])new BigDecimal[0], (Object[])this.conf.getBigDecimalArray("empty"));
    }

    @Test
    public void testGetBigDecimalList() {
        ListAssert.assertEquals(null, (List)this.conf.getBigDecimalList("bigdecimal.list", null));
        ArrayList<BigDecimal> expected = new ArrayList<BigDecimal>();
        expected.add(new BigDecimal("1"));
        expected.add(new BigDecimal("2"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigDecimalList("bigdecimal.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigDecimalList("bigdecimal.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigDecimalList("bigdecimal.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigDecimalList("bigdecimal.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigDecimalList("bigdecimal.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigDecimalList("bigdecimal.list.interpolated"));
        expected = new ArrayList();
        expected.add(new BigDecimal("1"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigDecimalList("bigdecimal.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigDecimalList("bigdecimal.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getBigDecimalList("empty"));
    }

    @Test
    public void testGetBigIntegerArray() {
        Object[] defaultValue = new BigInteger[]{new BigInteger("2"), new BigInteger("1")};
        ArrayAssert.assertEquals((Object[])defaultValue, (Object[])this.conf.getBigIntegerArray("biginteger.list", (BigInteger[])defaultValue));
        Object[] expected = new BigInteger[]{new BigInteger("1"), new BigInteger("2")};
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list1"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list2"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list3"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list4"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list6"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getBigIntegerArray("biginteger.list.interpolated"));
        ArrayAssert.assertEquals((Object[])new BigInteger[]{new BigInteger("1")}, (Object[])this.conf.getBigIntegerArray("biginteger.string"));
        ArrayAssert.assertEquals((Object[])new BigInteger[]{new BigInteger("1")}, (Object[])this.conf.getBigIntegerArray("biginteger.object"));
        ArrayAssert.assertEquals((Object[])new BigInteger[0], (Object[])this.conf.getBigIntegerArray("empty"));
    }

    @Test
    public void testGetBigIntegerList() {
        List bigIntegerList = this.conf.getBigIntegerList("biginteger.list", null);
        ListAssert.assertEquals(null, (List)bigIntegerList);
        ArrayList<BigInteger> expected = new ArrayList<BigInteger>();
        expected.add(new BigInteger("1"));
        expected.add(new BigInteger("2"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigIntegerList("biginteger.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigIntegerList("biginteger.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigIntegerList("biginteger.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigIntegerList("biginteger.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigIntegerList("biginteger.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigIntegerList("biginteger.list.interpolated"));
        expected = new ArrayList();
        expected.add(new BigInteger("1"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigIntegerList("biginteger.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getBigIntegerList("biginteger.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getBigIntegerList("empty"));
    }

    @Test
    public void testGetBooleanArray() {
        boolean[] defaultValue = new boolean[]{false, true};
        ArrayAssert.assertEquals((boolean[])defaultValue, (boolean[])this.conf.getBooleanArray("boolean.list", defaultValue));
        boolean[] expected = new boolean[]{true, false};
        ArrayAssert.assertEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list1"));
        ArrayAssert.assertEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list2"));
        ArrayAssert.assertEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list3"));
        ArrayAssert.assertEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list4"));
        ArrayAssert.assertEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list5"));
        ArrayAssert.assertEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list6"));
        ArrayAssert.assertEquals((boolean[])expected, (boolean[])this.conf.getBooleanArray("boolean.list.interpolated"));
        ArrayAssert.assertEquals((boolean[])new boolean[]{true}, (boolean[])this.conf.getBooleanArray("boolean.string"));
        ArrayAssert.assertEquals((boolean[])new boolean[]{true}, (boolean[])this.conf.getBooleanArray("boolean.object"));
        ArrayAssert.assertEquals((boolean[])new boolean[0], (boolean[])this.conf.getBooleanArray("empty"));
    }

    @Test
    public void testGetBooleanList() {
        ListAssert.assertEquals(null, (List)this.conf.getBooleanList("boolean.list", null));
        ArrayList<Boolean> expected = new ArrayList<Boolean>();
        expected.add(Boolean.TRUE);
        expected.add(Boolean.FALSE);
        ListAssert.assertEquals(expected, (List)this.conf.getBooleanList("boolean.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getBooleanList("boolean.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getBooleanList("boolean.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getBooleanList("boolean.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getBooleanList("boolean.list5"));
        ListAssert.assertEquals(expected, (List)this.conf.getBooleanList("boolean.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getBooleanList("boolean.list.interpolated"));
        expected = new ArrayList();
        expected.add(Boolean.TRUE);
        ListAssert.assertEquals(expected, (List)this.conf.getBooleanList("boolean.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getBooleanList("boolean.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getBooleanList("empty"));
    }

    @Test
    public void testGetByteArray() {
        byte[] defaultValue = new byte[]{1, 2};
        ArrayAssert.assertEquals((byte[])defaultValue, (byte[])this.conf.getByteArray("byte.list", defaultValue));
        byte[] expected = new byte[]{1, 2};
        ArrayAssert.assertEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list1"));
        ArrayAssert.assertEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list2"));
        ArrayAssert.assertEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list3"));
        ArrayAssert.assertEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list4"));
        ArrayAssert.assertEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list5"));
        ArrayAssert.assertEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list6"));
        ArrayAssert.assertEquals((byte[])expected, (byte[])this.conf.getByteArray("byte.list.interpolated"));
        ArrayAssert.assertEquals((byte[])new byte[]{1}, (byte[])this.conf.getByteArray("byte.string"));
        ArrayAssert.assertEquals((byte[])new byte[]{1}, (byte[])this.conf.getByteArray("byte.object"));
        ArrayAssert.assertEquals((byte[])new byte[0], (byte[])this.conf.getByteArray("empty"));
    }

    @Test
    public void testGetByteList() {
        ListAssert.assertEquals(null, (List)this.conf.getByteList("byte.list", null));
        ArrayList<Byte> expected = new ArrayList<Byte>();
        expected.add(Byte.valueOf("1"));
        expected.add(Byte.valueOf("2"));
        ListAssert.assertEquals(expected, (List)this.conf.getByteList("byte.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getByteList("byte.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getByteList("byte.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getByteList("byte.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getByteList("byte.list5"));
        ListAssert.assertEquals(expected, (List)this.conf.getByteList("byte.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getByteList("byte.list.interpolated"));
        expected = new ArrayList();
        expected.add(Byte.valueOf("1"));
        ListAssert.assertEquals(expected, (List)this.conf.getByteList("byte.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getByteList("byte.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getByteList("empty"));
    }

    @Test
    public void testGetCalendar() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        Calendar defaultValue = Calendar.getInstance();
        defaultValue.setTime(new Date());
        Assert.assertEquals((Object)defaultValue, (Object)this.conf.getCalendar("calendar", defaultValue));
        Assert.assertNull((String)"non null object for a missing key", (Object)this.conf.getCalendar("unknownkey", DATE_PATTERN));
        this.conf.setThrowExceptionOnMissing(true);
        try {
            this.conf.getCalendar("unknownkey", DATE_PATTERN);
            Assert.fail((String)"NoSuchElementException should be thrown for missing properties");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Calendar expected = Calendar.getInstance();
        expected.setTime(format.parse("2004-01-01"));
        Assert.assertEquals((Object)expected, (Object)this.conf.getCalendar("calendar.string"));
        Assert.assertEquals((Object)expected, (Object)this.conf.getCalendar("calendar.string", DATE_PATTERN));
        Assert.assertEquals((Object)expected, (Object)this.conf.getCalendar("calendar.object"));
        Assert.assertEquals((Object)expected, (Object)this.conf.getCalendar("date.object"));
        Assert.assertEquals((Object)expected, (Object)this.conf.getCalendar("calendar.string.interpolated"));
    }

    @Test
    public void testGetCalendarArray() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        Date date1 = format.parse("2004-01-01");
        Date date2 = format.parse("2004-12-31");
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        Object[] defaultValue = new Calendar[]{calendar2, calendar1};
        ArrayAssert.assertEquals((Object[])defaultValue, (Object[])this.conf.getCalendarArray("calendar.list", (Calendar[])defaultValue));
        Object[] expected = new Calendar[]{calendar1, calendar2};
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list1"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list2"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list3"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list4"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list5"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list6"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getCalendarArray("calendar.list.interpolated"));
        ArrayAssert.assertEquals((Object[])new Calendar[]{calendar1}, (Object[])this.conf.getCalendarArray("calendar.string"));
        ArrayAssert.assertEquals((Object[])new Calendar[]{calendar1}, (Object[])this.conf.getCalendarArray("calendar.object"));
        ArrayAssert.assertEquals((Object[])new Calendar[0], (Object[])this.conf.getCalendarArray("empty"));
    }

    @Test
    public void testGetCalendarArrayWithFormat() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        Date date1 = format.parse("01/01/2004");
        Date date2 = format.parse("12/31/2004");
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        Object[] expected = new Calendar[]{calendar1, calendar2};
        this.conf.addProperty("calendar.format", (Object)"01/01/2004");
        this.conf.addProperty("calendar.format", (Object)"12/31/2004");
        ArrayAssert.assertEquals((String)"Wrong calendars with format", (Object[])expected, (Object[])this.conf.getCalendarArray("calendar.format", "MM/dd/yyyy"));
    }

    @Test
    public void testGetCalendarList() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        Date date1 = format.parse("2004-01-01");
        Date date2 = format.parse("2004-12-31");
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        List nullList = null;
        ListAssert.assertEquals(null, (List)this.conf.getCalendarList("calendar.list", nullList));
        ArrayList<Calendar> expected = new ArrayList<Calendar>();
        expected.add(calendar1);
        expected.add(calendar2);
        ListAssert.assertEquals(expected, (List)this.conf.getCalendarList("calendar.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getList(Calendar.class, "calendar.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getCalendarList("calendar.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getCalendarList("calendar.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getCalendarList("calendar.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getCalendarList("calendar.list5"));
        ListAssert.assertEquals(expected, (List)this.conf.getCalendarList("calendar.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getList(Calendar.class, "calendar.list7"));
        ListAssert.assertEquals(expected, (List)this.conf.getCalendarList("calendar.list.interpolated"));
        expected = new ArrayList();
        expected.add(calendar1);
        ListAssert.assertEquals(expected, (List)this.conf.getCalendarList("date.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getCalendarList("date.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getCalendarList("empty"));
    }

    @Test
    public void testGetColor() {
        this.conf.setProperty("color", (Object)"FF0000");
        Assert.assertEquals((String)"color", (Object)Color.red, (Object)this.conf.getColor("color"));
        this.conf.setProperty("color", (Object)"#00FF00");
        Assert.assertEquals((String)"color", (Object)Color.green, (Object)this.conf.getColor("color"));
        this.conf.setProperty("color", (Object)"#01030507");
        Color color = this.conf.getColor("color");
        Assert.assertNotNull((String)"null color", (Object)color);
        Assert.assertEquals((String)"red", (long)1L, (long)color.getRed());
        Assert.assertEquals((String)"green", (long)3L, (long)color.getGreen());
        Assert.assertEquals((String)"blue", (long)5L, (long)color.getBlue());
        Assert.assertEquals((String)"alpha", (long)7L, (long)color.getAlpha());
        Assert.assertEquals((Object)Color.red, (Object)this.conf.getColor("color.string.interpolated"));
        Assert.assertEquals((Object)Color.cyan, (Object)this.conf.getColor("unknownkey", Color.cyan));
    }

    @Test
    public void testGetColorArray() throws Exception {
        Object[] defaultValue = new Color[]{Color.red, Color.blue};
        ArrayAssert.assertEquals((Object[])defaultValue, (Object[])this.conf.getColorArray("color.list", (Color[])defaultValue));
        Object[] expected = new Color[]{Color.red, Color.blue};
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list1"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list2"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list3"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list4"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list6"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getColorArray("color.list.interpolated"));
        ArrayAssert.assertEquals((Object[])new Color[]{Color.red}, (Object[])this.conf.getColorArray("color.string"));
        ArrayAssert.assertEquals((Object[])new Color[]{Color.red}, (Object[])this.conf.getColorArray("color.object"));
        ArrayAssert.assertEquals((Object[])new Color[0], (Object[])this.conf.getColorArray("empty"));
    }

    @Test
    public void testGetColorList() throws Exception {
        ListAssert.assertEquals(null, (List)this.conf.getColorList("color.list", null));
        ArrayList<Color> expected = new ArrayList<Color>();
        expected.add(Color.red);
        expected.add(Color.blue);
        ListAssert.assertEquals(expected, (List)this.conf.getColorList("color.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getColorList("color.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getColorList("color.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getColorList("color.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getColorList("color.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getColorList("color.list.interpolated"));
        expected = new ArrayList();
        expected.add(Color.red);
        ListAssert.assertEquals(expected, (List)this.conf.getColorList("color.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getColorList("color.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getColorList("empty"));
    }

    @Test
    public void testGetConfiguration() {
        BaseConfiguration baseconf = new BaseConfiguration();
        DataConfiguration conf = new DataConfiguration((Configuration)baseconf);
        Assert.assertEquals((String)"base configuration", (Object)baseconf, (Object)conf.getConfiguration());
    }

    @Test
    public void testGetDate() throws Exception {
        Date expected = TestDataConfiguration.expectedDate();
        Date defaultValue = new Date();
        Assert.assertEquals((Object)defaultValue, (Object)this.conf.getDate("date", defaultValue));
        Assert.assertNull((String)"non null object for a missing key", (Object)this.conf.getDate("unknownkey", DATE_PATTERN));
        this.conf.setThrowExceptionOnMissing(true);
        try {
            this.conf.getDate("unknownkey", DATE_PATTERN);
            Assert.fail((String)"NoSuchElementException should be thrown for missing properties");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertEquals((Object)expected, (Object)this.conf.getDate("date.string"));
        Assert.assertEquals((Object)expected, (Object)this.conf.getDate("date.string", DATE_PATTERN));
        Assert.assertEquals((Object)expected, (Object)this.conf.getDate("date.object"));
        Assert.assertEquals((Object)expected, (Object)this.conf.getDate("calendar.object"));
        Assert.assertEquals((Object)expected, (Object)this.conf.getDate("date.string.interpolated"));
    }

    @Test
    public void testGetDateArray() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        Date date1 = format.parse("2004-01-01");
        Date date2 = format.parse("2004-12-31");
        Object[] defaultValue = new Date[]{date2, date1};
        ArrayAssert.assertEquals((Object[])defaultValue, (Object[])this.conf.getDateArray("date.list", (Date[])defaultValue));
        Object[] expected = new Date[]{date1, date2};
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list1"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list2"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list3"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list4"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list5"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list6"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getDateArray("date.list.interpolated"));
        ArrayAssert.assertEquals((Object[])new Date[]{date1}, (Object[])this.conf.getDateArray("date.string"));
        ArrayAssert.assertEquals((Object[])new Date[]{date1}, (Object[])this.conf.getDateArray("date.object"));
        ArrayAssert.assertEquals((Object[])new Date[0], (Object[])this.conf.getDateArray("empty"));
    }

    @Test
    public void testGetDateArrayWithFormat() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        Date date1 = format.parse("01/01/2004");
        Date date2 = format.parse("12/31/2004");
        Object[] expected = new Date[]{date1, date2};
        this.conf.addProperty("date.format", (Object)"01/01/2004");
        this.conf.addProperty("date.format", (Object)"12/31/2004");
        ArrayAssert.assertEquals((String)"Wrong dates with format", (Object[])expected, (Object[])this.conf.getDateArray("date.format", "MM/dd/yyyy"));
    }

    @Test
    public void testGetDateList() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        Date date1 = format.parse("2004-01-01");
        Date date2 = format.parse("2004-12-31");
        List nullList = null;
        ListAssert.assertEquals(null, (List)this.conf.getDateList("date.list", nullList));
        ArrayList<Date> expected = new ArrayList<Date>();
        expected.add(date1);
        expected.add(date2);
        ListAssert.assertEquals(expected, (List)this.conf.getDateList("date.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getList(Date.class, "date.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getDateList("date.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getDateList("date.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getDateList("date.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getDateList("date.list5"));
        ListAssert.assertEquals(expected, (List)this.conf.getDateList("date.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getList(Date.class, "date.list7"));
        ListAssert.assertEquals(expected, (List)this.conf.getDateList("date.list.interpolated"));
        expected = new ArrayList();
        expected.add(date1);
        ListAssert.assertEquals(expected, (List)this.conf.getDateList("date.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getDateList("date.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getDateList("empty"));
    }

    @Test
    public void testGetDateNoFormatPropertyConversionHandler() throws Exception {
        this.conf.clearProperty("org.apache.commons.configuration.format.date");
        DefaultConversionHandler handler = new DefaultConversionHandler();
        handler.setDateFormat(DATE_PATTERN);
        this.conf.setConversionHandler((ConversionHandler)handler);
        Assert.assertEquals((String)"Wrong result", (Object)TestDataConfiguration.expectedDate(), (Object)this.conf.getDate("date.string"));
    }

    @Test
    public void testGetDateNoFormatPropertyDirectlySpecified() throws Exception {
        this.conf.clearProperty("org.apache.commons.configuration.format.date");
        Assert.assertEquals((String)"Wrong result", (Object)TestDataConfiguration.expectedDate(), (Object)this.conf.getDate("date.string", DATE_PATTERN));
    }

    @Test
    public void testGetDoubleArray() {
        double[] defaultValue = new double[]{2.0, 1.0};
        ArrayAssert.assertEquals((double[])defaultValue, (double[])this.conf.getDoubleArray("double.list", defaultValue), (double)0.0);
        double[] expected = new double[]{1.0, 2.0};
        ArrayAssert.assertEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list1"), (double)0.0);
        ArrayAssert.assertEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list2"), (double)0.0);
        ArrayAssert.assertEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list3"), (double)0.0);
        ArrayAssert.assertEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list4"), (double)0.0);
        ArrayAssert.assertEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list5"), (double)0.0);
        ArrayAssert.assertEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list6"), (double)0.0);
        ArrayAssert.assertEquals((double[])expected, (double[])this.conf.getDoubleArray("double.list.interpolated"), (double)0.0);
        ArrayAssert.assertEquals((double[])new double[]{1.0}, (double[])this.conf.getDoubleArray("double.string"), (double)0.0);
        ArrayAssert.assertEquals((double[])new double[]{1.0}, (double[])this.conf.getDoubleArray("double.object"), (double)0.0);
        ArrayAssert.assertEquals((double[])new double[0], (double[])this.conf.getDoubleArray("empty"), (double)0.0);
    }

    @Test
    public void testGetDoubleList() {
        ListAssert.assertEquals(null, (List)this.conf.getDoubleList("double.list", null));
        ArrayList<Double> expected = new ArrayList<Double>();
        expected.add(Double.valueOf("1"));
        expected.add(Double.valueOf("2"));
        ListAssert.assertEquals(expected, (List)this.conf.getDoubleList("double.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getDoubleList("double.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getDoubleList("double.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getDoubleList("double.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getDoubleList("double.list5"));
        ListAssert.assertEquals(expected, (List)this.conf.getDoubleList("double.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getDoubleList("double.list.interpolated"));
        expected = new ArrayList();
        expected.add(Double.valueOf("1"));
        ListAssert.assertEquals(expected, (List)this.conf.getDoubleList("double.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getDoubleList("double.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getDoubleList("empty"));
    }

    @Test
    public void testGetFloatArray() {
        float[] defaultValue = new float[]{2.0f, 1.0f};
        ArrayAssert.assertEquals((float[])defaultValue, (float[])this.conf.getFloatArray("float.list", defaultValue), (float)0.0f);
        float[] expected = new float[]{1.0f, 2.0f};
        ArrayAssert.assertEquals((float[])expected, (float[])this.conf.getFloatArray("float.list1"), (float)0.0f);
        ArrayAssert.assertEquals((float[])expected, (float[])this.conf.getFloatArray("float.list2"), (float)0.0f);
        ArrayAssert.assertEquals((float[])expected, (float[])this.conf.getFloatArray("float.list3"), (float)0.0f);
        ArrayAssert.assertEquals((float[])expected, (float[])this.conf.getFloatArray("float.list4"), (float)0.0f);
        ArrayAssert.assertEquals((float[])expected, (float[])this.conf.getFloatArray("float.list5"), (float)0.0f);
        ArrayAssert.assertEquals((float[])expected, (float[])this.conf.getFloatArray("float.list6"), (float)0.0f);
        ArrayAssert.assertEquals((float[])expected, (float[])this.conf.getFloatArray("float.list.interpolated"), (float)0.0f);
        ArrayAssert.assertEquals((float[])new float[]{1.0f}, (float[])this.conf.getFloatArray("float.string"), (float)0.0f);
        ArrayAssert.assertEquals((float[])new float[]{1.0f}, (float[])this.conf.getFloatArray("float.object"), (float)0.0f);
        ArrayAssert.assertEquals((float[])new float[0], (float[])this.conf.getFloatArray("empty"), (float)0.0f);
    }

    @Test
    public void testGetFloatList() {
        ListAssert.assertEquals(null, (List)this.conf.getFloatList("float.list", null));
        ArrayList<Float> expected = new ArrayList<Float>();
        expected.add(Float.valueOf("1"));
        expected.add(Float.valueOf("2"));
        ListAssert.assertEquals(expected, (List)this.conf.getFloatList("float.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getFloatList("float.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getFloatList("float.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getFloatList("float.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getFloatList("float.list5"));
        ListAssert.assertEquals(expected, (List)this.conf.getFloatList("float.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getFloatList("float.list.interpolated"));
        expected = new ArrayList();
        expected.add(Float.valueOf("1"));
        ListAssert.assertEquals(expected, (List)this.conf.getFloatList("float.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getFloatList("float.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getFloatList("empty"));
    }

    @Test
    public void testGetInetAddress() throws Exception {
        InetAddress expected = InetAddress.getByName("127.0.0.1");
        Assert.assertEquals((Object)expected, (Object)this.conf.get(InetAddress.class, "ip.string"));
        Assert.assertEquals((Object)expected, (Object)this.conf.get(InetAddress.class, "ip.object"));
        Assert.assertEquals((Object)expected, (Object)this.conf.get(InetAddress.class, "ip.string.interpolated"));
    }

    @Test(expected=ConversionException.class)
    public void testGetInetAddressInvalidType() {
        this.conf.setProperty("ip.unknownhost", (Object)"foo");
        this.conf.get(InetAddress.class, "ip.unknownhost");
    }

    @Test
    public void testGetIntegerArray() {
        int[] defaultValue = new int[]{2, 1};
        ArrayAssert.assertEquals((int[])defaultValue, (int[])this.conf.getIntArray("integer.list", defaultValue));
        int[] expected = new int[]{1, 2};
        ArrayAssert.assertEquals((int[])expected, (int[])this.conf.getIntArray("integer.list1"));
        ArrayAssert.assertEquals((int[])expected, (int[])this.conf.getIntArray("integer.list2"));
        ArrayAssert.assertEquals((int[])expected, (int[])this.conf.getIntArray("integer.list3"));
        ArrayAssert.assertEquals((int[])expected, (int[])this.conf.getIntArray("integer.list4"));
        ArrayAssert.assertEquals((int[])expected, (int[])this.conf.getIntArray("integer.list5"));
        ArrayAssert.assertEquals((int[])expected, (int[])this.conf.getIntArray("integer.list6"));
        ArrayAssert.assertEquals((int[])expected, (int[])this.conf.getIntArray("integer.list.interpolated"));
        ArrayAssert.assertEquals((int[])new int[]{1}, (int[])this.conf.getIntArray("integer.string"));
        ArrayAssert.assertEquals((int[])new int[]{1}, (int[])this.conf.getIntArray("integer.object"));
        ArrayAssert.assertEquals((int[])new int[0], (int[])this.conf.getIntArray("empty"));
    }

    @Test
    public void testGetIntegerList() {
        ListAssert.assertEquals(null, (List)this.conf.getIntegerList("integer.list", null));
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(Integer.valueOf("1"));
        expected.add(Integer.valueOf("2"));
        ListAssert.assertEquals(expected, (List)this.conf.getIntegerList("integer.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getIntegerList("integer.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getIntegerList("integer.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getIntegerList("integer.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getIntegerList("integer.list5"));
        ListAssert.assertEquals(expected, (List)this.conf.getIntegerList("integer.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getIntegerList("integer.list.interpolated"));
        expected = new ArrayList();
        expected.add(Integer.valueOf("1"));
        ListAssert.assertEquals(expected, (List)this.conf.getIntegerList("integer.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getIntegerList("integer.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getIntegerList("empty"));
    }

    @Test
    public void testGetInternetAddress() throws Exception {
        InternetAddress expected = new InternetAddress("dev@test.org");
        Assert.assertEquals((Object)expected, (Object)this.conf.get(expected.getClass(), "email.string"));
        Assert.assertEquals((Object)expected, (Object)this.conf.get(expected.getClass(), "email.object"));
        Assert.assertEquals((Object)expected, (Object)this.conf.get(expected.getClass(), "email.string.interpolated"));
        this.conf.setProperty("email.invalid", (Object)"dev@test@org");
        try {
            this.conf.get(expected.getClass(), "email.invalid");
            Assert.fail((String)"ConversionException should be thrown for invalid emails");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    @Test(expected=ConversionException.class)
    public void testGetInternetAddressInvalidType() throws Exception {
        InternetAddress expected = new InternetAddress("dev@test.org");
        this.conf.setProperty("email.invalid", (Object)"dev@test@org");
        this.conf.get(expected.getClass(), "email.invalid");
    }

    @Test(expected=ConversionException.class)
    public void testGetInvalidType() {
        this.conf.get(Boolean.class, "url.object", null);
    }

    @Test
    public void testGetKeys() {
        BaseConfiguration baseconf = new BaseConfiguration();
        DataConfiguration conf = new DataConfiguration((Configuration)baseconf);
        baseconf.setProperty("foo", (Object)"bar");
        Iterator it = conf.getKeys();
        Assert.assertTrue((String)"the iterator is empty", (boolean)it.hasNext());
        Assert.assertEquals((String)"unique key", (Object)"foo", it.next());
        Assert.assertFalse((String)"the iterator is not exhausted", (boolean)it.hasNext());
    }

    @Test
    public void testGetLocale() {
        this.conf.setProperty("locale", (Object)"fr");
        Assert.assertEquals((String)"language", (Object)new Locale("fr", ""), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"fr__POSIX");
        Assert.assertEquals((String)"language + variant", (Object)new Locale("fr", "", "POSIX"), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"_FR");
        Assert.assertEquals((String)"country", (Object)new Locale("", "FR"), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"_FR_WIN");
        Assert.assertEquals((String)"country + variant", (Object)new Locale("", "FR", "WIN"), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"fr_FR");
        Assert.assertEquals((String)"language + country", (Object)new Locale("fr", "FR"), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"fr_FR_MAC");
        Assert.assertEquals((String)"language + country + variant", (Object)new Locale("fr", "FR", "MAC"), (Object)this.conf.getLocale("locale"));
        this.conf.setProperty("locale", (Object)"fr");
        Assert.assertEquals((String)"Existing key with default value", (Object)Locale.FRENCH, (Object)this.conf.getLocale("locale", Locale.GERMAN));
        Assert.assertEquals((String)"Missing key with default value", (Object)Locale.GERMAN, (Object)this.conf.getLocale("localeNotInConfig", Locale.GERMAN));
        Assert.assertEquals((Object)Locale.FRENCH, (Object)this.conf.getLocale("locale.string.interpolated"));
    }

    @Test
    public void testGetLocaleArray() throws Exception {
        Object[] defaultValue = new Locale[]{Locale.GERMAN, Locale.FRENCH};
        ArrayAssert.assertEquals((Object[])defaultValue, (Object[])this.conf.getLocaleArray("locale.list", (Locale[])defaultValue));
        Object[] expected = new Locale[]{Locale.FRENCH, Locale.GERMAN};
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list1"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list2"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list3"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list4"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list6"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getLocaleArray("locale.list.interpolated"));
        ArrayAssert.assertEquals((Object[])new Locale[]{Locale.FRENCH}, (Object[])this.conf.getLocaleArray("locale.string"));
        ArrayAssert.assertEquals((Object[])new Locale[]{Locale.FRENCH}, (Object[])this.conf.getLocaleArray("locale.object"));
        ArrayAssert.assertEquals((Object[])new Locale[0], (Object[])this.conf.getLocaleArray("empty"));
    }

    @Test
    public void testGetLocaleList() throws Exception {
        ListAssert.assertEquals(null, (List)this.conf.getLocaleList("locale.list", null));
        ArrayList<Locale> expected = new ArrayList<Locale>();
        expected.add(Locale.FRENCH);
        expected.add(Locale.GERMAN);
        ListAssert.assertEquals(expected, (List)this.conf.getLocaleList("locale.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getLocaleList("locale.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getLocaleList("locale.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getLocaleList("locale.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getLocaleList("locale.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getLocaleList("locale.list.interpolated"));
        expected = new ArrayList();
        expected.add(Locale.FRENCH);
        ListAssert.assertEquals(expected, (List)this.conf.getLocaleList("locale.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getLocaleList("locale.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getLocaleList("empty"));
    }

    @Test
    public void testGetLongArray() {
        long[] defaultValue = new long[]{2L, 1L};
        ArrayAssert.assertEquals((long[])defaultValue, (long[])this.conf.getLongArray("long.list", defaultValue));
        long[] expected = new long[]{1L, 2L};
        ArrayAssert.assertEquals((long[])expected, (long[])this.conf.getLongArray("long.list1"));
        ArrayAssert.assertEquals((long[])expected, (long[])this.conf.getLongArray("long.list2"));
        ArrayAssert.assertEquals((long[])expected, (long[])this.conf.getLongArray("long.list3"));
        ArrayAssert.assertEquals((long[])expected, (long[])this.conf.getLongArray("long.list4"));
        ArrayAssert.assertEquals((long[])expected, (long[])this.conf.getLongArray("long.list5"));
        ArrayAssert.assertEquals((long[])expected, (long[])this.conf.getLongArray("long.list6"));
        ArrayAssert.assertEquals((long[])expected, (long[])this.conf.getLongArray("long.list.interpolated"));
        ArrayAssert.assertEquals((long[])new long[]{1L}, (long[])this.conf.getLongArray("long.string"));
        ArrayAssert.assertEquals((long[])new long[]{1L}, (long[])this.conf.getLongArray("long.object"));
        ArrayAssert.assertEquals((long[])new long[0], (long[])this.conf.getLongArray("empty"));
    }

    @Test
    public void testGetLongList() {
        ListAssert.assertEquals(null, (List)this.conf.getLongList("long.list", null));
        ArrayList<Long> expected = new ArrayList<Long>();
        expected.add(Long.valueOf("1"));
        expected.add(Long.valueOf("2"));
        ListAssert.assertEquals(expected, (List)this.conf.getLongList("long.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getLongList("long.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getLongList("long.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getLongList("long.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getLongList("long.list5"));
        ListAssert.assertEquals(expected, (List)this.conf.getLongList("long.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getLongList("long.list.interpolated"));
        expected = new ArrayList();
        expected.add(Long.valueOf("1"));
        ListAssert.assertEquals(expected, (List)this.conf.getLongList("long.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getLongList("long.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getLongList("empty"));
    }

    @Test(expected=ConversionException.class)
    public void testGetPrimitiveArrayInvalidType() {
        this.conf.getArray(Boolean.TYPE, "calendar.list4");
    }

    @Test
    public void testGetPropertyWithoutConversion() {
        String key = "test.str";
        String value = "someTestValue";
        this.conf.addProperty("test.str", (Object)"someTestValue");
        Assert.assertEquals((String)"Wrong result", (Object)"someTestValue", (Object)this.conf.get(String.class, "test.str"));
    }

    @Test
    public void testGetShortArray() {
        short[] defaultValue = new short[]{2, 1};
        ArrayAssert.assertEquals((short[])defaultValue, (short[])this.conf.getShortArray("short.list", defaultValue));
        short[] expected = new short[]{1, 2};
        ArrayAssert.assertEquals((short[])expected, (short[])this.conf.getShortArray("short.list1"));
        ArrayAssert.assertEquals((short[])expected, (short[])this.conf.getShortArray("short.list2"));
        ArrayAssert.assertEquals((short[])expected, (short[])this.conf.getShortArray("short.list3"));
        ArrayAssert.assertEquals((short[])expected, (short[])this.conf.getShortArray("short.list4"));
        ArrayAssert.assertEquals((short[])expected, (short[])this.conf.getShortArray("short.list5"));
        ArrayAssert.assertEquals((short[])expected, (short[])this.conf.getShortArray("short.list6"));
        ArrayAssert.assertEquals((short[])expected, (short[])this.conf.getShortArray("short.list.interpolated"));
        ArrayAssert.assertEquals((short[])new short[]{1}, (short[])this.conf.getShortArray("short.string"));
        ArrayAssert.assertEquals((short[])new short[]{1}, (short[])this.conf.getShortArray("short.object"));
        ArrayAssert.assertEquals((short[])new short[0], (short[])this.conf.getShortArray("empty"));
    }

    @Test
    public void testGetShortList() {
        ListAssert.assertEquals(null, (List)this.conf.getShortList("short.list", null));
        ArrayList<Short> expected = new ArrayList<Short>();
        expected.add(Short.valueOf("1"));
        expected.add(Short.valueOf("2"));
        ListAssert.assertEquals(expected, (List)this.conf.getShortList("short.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getShortList("short.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getShortList("short.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getShortList("short.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getShortList("short.list5"));
        ListAssert.assertEquals(expected, (List)this.conf.getShortList("short.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getShortList("short.list.interpolated"));
        expected = new ArrayList();
        expected.add(Short.valueOf("1"));
        ListAssert.assertEquals(expected, (List)this.conf.getShortList("short.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getShortList("short.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getShortList("empty"));
    }

    @Test
    public void testGetUnknown() {
        Assert.assertNull((String)"non null object for a missing key", (Object)this.conf.get(Object.class, "unknownkey"));
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetUnknownException() {
        this.conf.setThrowExceptionOnMissing(true);
        this.conf.get(Object.class, "unknownkey");
    }

    @Test
    public void testGetURI() throws Exception {
        URI defaultValue = new URI("http://www.google.com");
        Assert.assertEquals((Object)defaultValue, (Object)this.conf.getURI("url", defaultValue));
        URI expected = new URI("http://jakarta.apache.org");
        Assert.assertEquals((Object)expected, (Object)this.conf.getURI("uri.string"));
        Assert.assertEquals((Object)expected, (Object)this.conf.getURI("uri.object"));
        Assert.assertEquals((Object)expected, (Object)this.conf.getURI("uri.string.interpolated"));
    }

    @Test
    public void testGetURIArray() throws Exception {
        Object[] defaultValue = new URI[]{new URI("http://www.apache.org"), new URI("http://jakarta.apache.org")};
        ArrayAssert.assertEquals((Object[])defaultValue, (Object[])this.conf.getURIArray("url.list", (URI[])defaultValue));
        Object[] expected = new URI[]{new URI("http://jakarta.apache.org"), new URI("http://www.apache.org")};
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list1"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list2"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list3"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list4"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list6"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURIArray("uri.list.interpolated"));
        ArrayAssert.assertEquals((Object[])new URI[]{new URI("http://jakarta.apache.org")}, (Object[])this.conf.getURIArray("uri.string"));
        ArrayAssert.assertEquals((Object[])new URI[]{new URI("http://jakarta.apache.org")}, (Object[])this.conf.getURIArray("uri.object"));
        ArrayAssert.assertEquals((Object[])new URI[0], (Object[])this.conf.getURIArray("empty"));
    }

    @Test
    public void testGetURIList() throws Exception {
        ListAssert.assertEquals(null, (List)this.conf.getURIList("uri.list", null));
        ArrayList<URI> expected = new ArrayList<URI>();
        expected.add(new URI("http://jakarta.apache.org"));
        expected.add(new URI("http://www.apache.org"));
        ListAssert.assertEquals(expected, (List)this.conf.getURIList("uri.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getURIList("uri.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getURIList("uri.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getURIList("uri.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getURIList("uri.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getURIList("uri.list.interpolated"));
        expected = new ArrayList();
        expected.add(new URI("http://jakarta.apache.org"));
        ListAssert.assertEquals(expected, (List)this.conf.getURIList("uri.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getURIList("uri.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getURIList("empty"));
    }

    @Test
    public void testGetURL() throws Exception {
        URL defaultValue = new URL("http://www.google.com");
        Assert.assertEquals((Object)defaultValue, (Object)this.conf.getURL("url", defaultValue));
        URL expected = new URL("http://jakarta.apache.org");
        Assert.assertEquals((Object)expected, (Object)this.conf.getURL("url.string"));
        Assert.assertEquals((Object)expected, (Object)this.conf.getURL("url.object"));
        Assert.assertEquals((Object)expected, (Object)this.conf.getURL("url.string.interpolated"));
    }

    @Test
    public void testGetURLArray() throws Exception {
        Object[] defaultValue = new URL[]{new URL("http://www.apache.org"), new URL("http://jakarta.apache.org")};
        ArrayAssert.assertEquals((Object[])defaultValue, (Object[])this.conf.getURLArray("url.list", (URL[])defaultValue));
        Object[] expected = new URL[]{new URL("http://jakarta.apache.org"), new URL("http://www.apache.org")};
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list1"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list2"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list3"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list4"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list6"));
        ArrayAssert.assertEquals((Object[])expected, (Object[])this.conf.getURLArray("url.list.interpolated"));
        ArrayAssert.assertEquals((Object[])new URL[]{new URL("http://jakarta.apache.org")}, (Object[])this.conf.getURLArray("url.string"));
        ArrayAssert.assertEquals((Object[])new URL[]{new URL("http://jakarta.apache.org")}, (Object[])this.conf.getURLArray("url.object"));
        ArrayAssert.assertEquals((Object[])new URL[0], (Object[])this.conf.getURLArray("empty"));
    }

    @Test
    public void testGetURLList() throws Exception {
        ListAssert.assertEquals(null, (List)this.conf.getURLList("url.list", null));
        ArrayList<URL> expected = new ArrayList<URL>();
        expected.add(new URL("http://jakarta.apache.org"));
        expected.add(new URL("http://www.apache.org"));
        ListAssert.assertEquals(expected, (List)this.conf.getURLList("url.list1"));
        ListAssert.assertEquals(expected, (List)this.conf.getURLList("url.list2"));
        ListAssert.assertEquals(expected, (List)this.conf.getURLList("url.list3"));
        ListAssert.assertEquals(expected, (List)this.conf.getURLList("url.list4"));
        ListAssert.assertEquals(expected, (List)this.conf.getURLList("url.list6"));
        ListAssert.assertEquals(expected, (List)this.conf.getURLList("url.list.interpolated"));
        expected = new ArrayList();
        expected.add(new URL("http://jakarta.apache.org"));
        ListAssert.assertEquals(expected, (List)this.conf.getURLList("url.string"));
        ListAssert.assertEquals(expected, (List)this.conf.getURLList("url.object"));
        ListAssert.assertEquals(new ArrayList(), (List)this.conf.getURLList("empty"));
    }

    @Test
    public void testIsEmpty() {
        BaseConfiguration baseconf = new BaseConfiguration();
        DataConfiguration conf = new DataConfiguration((Configuration)baseconf);
        Assert.assertTrue((String)"not empty", (boolean)conf.isEmpty());
        baseconf.setProperty("foo", (Object)"bar");
        Assert.assertFalse((String)"empty", (boolean)conf.isEmpty());
    }
}

