/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Iterator;
import org.apache.commons.configuration2.EnvironmentConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestEnvironmentConfiguration {
    private EnvironmentConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = new EnvironmentConfiguration();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddProperty() {
        this.config.addProperty("JAVA_HOME", (Object)"C:\\java");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClear() {
        this.config.clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testClearProperty() {
        String key = (String)this.config.getKeys().next();
        this.config.clearProperty(key);
    }

    @Test
    public void testInit() {
        boolean found = false;
        Assert.assertFalse((String)"No properties found", (boolean)this.config.isEmpty());
        Iterator it = this.config.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertTrue((String)("Key not found: " + key), (boolean)this.config.containsKey(key));
            Assert.assertNotNull((String)("No value for property " + key), (Object)this.config.getString(key));
            found = true;
        }
        Assert.assertTrue((String)"No property keys returned", (boolean)found);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetProperty() {
        this.config.setProperty("JAVA_HOME", (Object)"C:\\java");
    }
}

