/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestImmutableConfiguration {
    private static final String TEST_FILE = "test.properties";

    private static PropertiesConfiguration createTestConfig() throws ConfigurationException {
        return (PropertiesConfiguration)new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(ConfigurationAssert.getTestFile(TEST_FILE))}).getConfiguration();
    }

    private static Set<String> fetchKeys(Iterator<String> it) {
        HashSet<String> keys = new HashSet<String>();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        return keys;
    }

    @Test
    public void testExceptionHandling() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        String property = "nonExistingProperty";
        config.setThrowExceptionOnMissing(true);
        ImmutableConfiguration ic = ConfigurationUtils.unmodifiableConfiguration((Configuration)config);
        try {
            ic.getString("nonExistingProperty");
            Assert.fail((String)"Exception for missing property not thrown!");
        }
        catch (NoSuchElementException e) {
            Assert.assertThat((String)"Wrong message", (Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"nonExistingProperty"));
        }
    }

    @Test
    public void testImmutableSubset() throws ConfigurationException {
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)TestImmutableConfiguration.createTestConfig());
        ImmutableConfiguration subset = conf.immutableSubset("test");
        Assert.assertFalse((String)"No content", (boolean)subset.isEmpty());
        Assert.assertEquals((String)"Wrong value", (long)1000000L, (long)subset.getLong("long"));
    }

    @Test
    public void testUnmodifiableConfigurationAccess() throws ConfigurationException {
        PropertiesConfiguration confOrg = TestImmutableConfiguration.createTestConfig();
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)confOrg);
        Assert.assertFalse((String)"Empty", (boolean)conf.isEmpty());
        Iterator it = confOrg.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertTrue((String)("Key not contained: " + key), (boolean)conf.containsKey(key));
            Assert.assertEquals((String)("Wrong value for " + key), (Object)confOrg.getProperty(key), (Object)conf.getProperty(key));
        }
    }

    @Test(expected=ClassCastException.class)
    public void testUnmodifiableConfigurationCast() throws ConfigurationException {
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)TestImmutableConfiguration.createTestConfig());
        Configuration mutableConf = (Configuration)conf;
        mutableConf.clear();
    }

    @Test
    public void testUnmodifiableConfigurationIterate() throws ConfigurationException {
        PropertiesConfiguration confOrg = TestImmutableConfiguration.createTestConfig();
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)confOrg);
        Assert.assertEquals((String)"Different keys", TestImmutableConfiguration.fetchKeys(confOrg.getKeys()), TestImmutableConfiguration.fetchKeys(conf.getKeys()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnmodifiableConfigurationIteratorRemove() throws ConfigurationException {
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)TestImmutableConfiguration.createTestConfig());
        Iterator it = conf.getKeys();
        it.next();
        it.remove();
    }

    @Test
    public void testUnmodifiableConfigurationLiveUpdate() throws ConfigurationException {
        PropertiesConfiguration confOrg = TestImmutableConfiguration.createTestConfig();
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)confOrg);
        String key = "new.property";
        String value = "new value";
        confOrg.addProperty("new.property", (Object)"new value");
        Assert.assertEquals((String)"Value not set", (Object)"new value", (Object)conf.getString("new.property"));
    }

    @Test(expected=NullPointerException.class)
    public void testUnmodifiableConfigurationNull() {
        ConfigurationUtils.unmodifiableConfiguration(null);
    }

    @Test
    public void testUnmodifiableConfigurationOtherTypes() throws ConfigurationException {
        ImmutableConfiguration conf = ConfigurationUtils.unmodifiableConfiguration((Configuration)TestImmutableConfiguration.createTestConfig());
        Assert.assertEquals((String)"Wrong byte", (long)10L, (long)conf.getByte("test.byte"));
        Assert.assertTrue((String)"Wrong boolean", (boolean)conf.getBoolean("test.boolean"));
        Assert.assertEquals((String)"Wrong double", (double)10.25, (double)conf.getDouble("test.double"), (double)0.05);
        Assert.assertEquals((String)"Wrong float", (double)20.25, (double)conf.getFloat("test.float"), (double)0.05);
        Assert.assertEquals((String)"Wrong int", (long)10L, (long)conf.getInt("test.integer"));
        Assert.assertEquals((String)"Wrong long", (long)1000000L, (long)conf.getLong("test.long"));
        Assert.assertEquals((String)"Wrong short", (long)1L, (long)conf.getShort("test.short"));
    }

    @Test
    public void testUnmodifiableHierarchicalConfiguration() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        String key = "test";
        conf.addProperty("test", (Object)Boolean.TRUE);
        ImmutableHierarchicalConfiguration ihc = ConfigurationUtils.unmodifiableConfiguration((HierarchicalConfiguration)conf);
        Assert.assertTrue((String)"Property not found", (boolean)ihc.getBoolean("test"));
        Assert.assertEquals((String)"Wrong max index", (long)0L, (long)ihc.getMaxIndex("test"));
    }
}

