/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.StrictConfigurationComparator;
import org.apache.commons.configuration2.TestAbstractConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestMapConfiguration
extends TestAbstractConfiguration {
    private static final String KEY = "key1";
    private static final String SPACE_VALUE = "   Value with whitespace  ";
    private static final String TRIM_VALUE = "   Value with whitespace  ".trim();

    @Override
    protected AbstractConfiguration getConfiguration() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY, "value1");
        map.put("key2", "value2");
        map.put("list", "value1, value2");
        map.put("listesc", "value1\\,value2");
        MapConfiguration config = new MapConfiguration(map);
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        return config;
    }

    @Override
    protected AbstractConfiguration getEmptyConfiguration() {
        return new MapConfiguration(new HashMap());
    }

    @Test
    public void testAddProperty() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.addProperty(KEY, (Object)TRIM_VALUE);
        config.addProperty(KEY, (Object)"anotherValue");
        List values = config.getList(KEY);
        Assert.assertEquals((String)"Wrong number of values", (long)3L, (long)values.size());
    }

    @Test
    public void testClone() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        MapConfiguration copy = (MapConfiguration)config.clone();
        StrictConfigurationComparator comp = new StrictConfigurationComparator();
        Assert.assertTrue((String)"Configurations are not equal", (boolean)comp.compare((Configuration)config, (Configuration)copy));
    }

    @Test
    public void testCloneInterpolation() {
        String keyAnswer = "answer";
        String keyValue = "value";
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.addProperty("answer", (Object)"The answer is ${value}.");
        config.addProperty("value", (Object)42);
        MapConfiguration clone = (MapConfiguration)config.clone();
        clone.setProperty("value", (Object)43);
        Assert.assertEquals((String)"Wrong interpolation in original", (Object)"The answer is 42.", (Object)config.getString("answer"));
        Assert.assertEquals((String)"Wrong interpolation in clone", (Object)"The answer is 43.", (Object)clone.getString("answer"));
    }

    @Test
    public void testCloneModify() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.addEventListener(ConfigurationEvent.ANY, (EventListener)new EventListenerTestImpl(config));
        MapConfiguration copy = (MapConfiguration)config.clone();
        Assert.assertTrue((String)"Event listeners were copied", (boolean)copy.getEventListeners(ConfigurationEvent.ANY).isEmpty());
        config.addProperty("cloneTest", (Object)Boolean.TRUE);
        Assert.assertFalse((String)"Map not decoupled", (boolean)copy.containsKey("cloneTest"));
        copy.clearProperty(KEY);
        Assert.assertEquals((String)"Map not decoupled (2)", (Object)"value1", (Object)config.getString(KEY));
    }

    @Test
    public void testGetMap() {
        HashMap map = new HashMap();
        MapConfiguration conf = new MapConfiguration(map);
        Assert.assertEquals(map, (Object)conf.getMap());
    }

    @Test
    public void testGetPropertyTrim() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.getMap().put(KEY, SPACE_VALUE);
        Assert.assertEquals((String)"Wrong trimmed value", (Object)TRIM_VALUE, (Object)config.getProperty(KEY));
    }

    @Test
    public void testGetPropertyTrimDisabled() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.getMap().put(KEY, SPACE_VALUE);
        config.setTrimmingDisabled(true);
        Assert.assertEquals((String)"Wrong trimmed value", (Object)SPACE_VALUE, (Object)config.getProperty(KEY));
    }

    @Test
    public void testGetPropertyTrimNoSplit() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.getMap().put(KEY, SPACE_VALUE);
        config.setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
        Assert.assertEquals((String)"Wrong trimmed value", (Object)SPACE_VALUE, (Object)config.getProperty(KEY));
    }
}

