/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLPropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class TestXMLPropertiesConfiguration {
    private static final String TEST_PROPERTIES_FILE = "test.properties.xml";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    private static XMLPropertiesConfiguration load(String fileName) throws ConfigurationException {
        XMLPropertiesConfiguration conf = new XMLPropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)conf);
        handler.load(fileName);
        return conf;
    }

    @Test
    public void testDOMLoad() throws Exception {
        URL location = ConfigurationAssert.getTestURL(TEST_PROPERTIES_FILE);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        dBuilder.setEntityResolver((publicId, systemId) -> new InputSource(this.getClass().getClassLoader().getResourceAsStream("properties.dtd")));
        File file = new File(location.toURI());
        Document doc = dBuilder.parse(file);
        XMLPropertiesConfiguration conf = new XMLPropertiesConfiguration(doc.getDocumentElement());
        Assert.assertEquals((String)"header", (Object)"Description of the property list", (Object)conf.getHeader());
        Assert.assertFalse((String)"The configuration is empty", (boolean)conf.isEmpty());
        Assert.assertEquals((String)"'key1' property", (Object)"value1", (Object)conf.getProperty("key1"));
        Assert.assertEquals((String)"'key2' property", (Object)"value2", (Object)conf.getProperty("key2"));
        Assert.assertEquals((String)"'key3' property", (Object)"value3", (Object)conf.getProperty("key3"));
    }

    @Test
    public void testDOMSave() throws Exception {
        XMLPropertiesConfiguration conf = TestXMLPropertiesConfiguration.load(TEST_PROPERTIES_FILE);
        conf.addProperty("key4", (Object)"value4");
        conf.clearProperty("key2");
        conf.setHeader("Description of the new property list");
        File saveFile = this.folder.newFile("test2.properties.xml");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.newDocument();
        conf.save(document, (Node)document);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(saveFile);
        transformer.transform(source, result);
        XMLPropertiesConfiguration conf2 = TestXMLPropertiesConfiguration.load(saveFile.getAbsolutePath());
        Assert.assertEquals((String)"header", (Object)"Description of the new property list", (Object)conf2.getHeader());
        Assert.assertFalse((String)"The configuration is empty", (boolean)conf2.isEmpty());
        Assert.assertEquals((String)"'key1' property", (Object)"value1", (Object)conf2.getProperty("key1"));
        Assert.assertEquals((String)"'key3' property", (Object)"value3", (Object)conf2.getProperty("key3"));
        Assert.assertEquals((String)"'key4' property", (Object)"value4", (Object)conf2.getProperty("key4"));
    }

    @Test
    public void testLoad() throws Exception {
        XMLPropertiesConfiguration conf = TestXMLPropertiesConfiguration.load(TEST_PROPERTIES_FILE);
        Assert.assertEquals((String)"header", (Object)"Description of the property list", (Object)conf.getHeader());
        Assert.assertFalse((String)"The configuration is empty", (boolean)conf.isEmpty());
        Assert.assertEquals((String)"'key1' property", (Object)"value1", (Object)conf.getProperty("key1"));
        Assert.assertEquals((String)"'key2' property", (Object)"value2", (Object)conf.getProperty("key2"));
        Assert.assertEquals((String)"'key3' property", (Object)"value3", (Object)conf.getProperty("key3"));
    }

    @Test
    public void testSave() throws Exception {
        XMLPropertiesConfiguration conf = TestXMLPropertiesConfiguration.load(TEST_PROPERTIES_FILE);
        conf.addProperty("key4", (Object)"value4");
        conf.clearProperty("key2");
        conf.setHeader("Description of the new property list");
        File saveFile = this.folder.newFile("test2.properties.xml");
        FileHandler saveHandler = new FileHandler((FileBased)conf);
        saveHandler.save(saveFile);
        XMLPropertiesConfiguration conf2 = TestXMLPropertiesConfiguration.load(saveFile.getAbsolutePath());
        Assert.assertEquals((String)"header", (Object)"Description of the new property list", (Object)conf2.getHeader());
        Assert.assertFalse((String)"The configuration is empty", (boolean)conf2.isEmpty());
        Assert.assertEquals((String)"'key1' property", (Object)"value1", (Object)conf2.getProperty("key1"));
        Assert.assertEquals((String)"'key3' property", (Object)"value3", (Object)conf2.getProperty("key3"));
        Assert.assertEquals((String)"'key4' property", (Object)"value4", (Object)conf2.getProperty("key4"));
    }
}

