/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.beanutils.BeanCreationContext;
import org.apache.commons.configuration2.beanutils.BeanCreationTestBean;
import org.apache.commons.configuration2.beanutils.BeanCreationTestBeanWithListChild;
import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.BeanDeclarationTestImpl;
import org.apache.commons.configuration2.beanutils.BeanFactory;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.beanutils.DefaultBeanFactory;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBeanHelper {
    private static final String TEST_STRING = "testString";
    private static final int TEST_INT = 42;
    private static final String TEST_FACTORY = "testFactory";
    private BeanHelper helper;

    private void checkBean(BeanCreationTestBean bean) {
        Assert.assertEquals((String)"Wrong string property", (Object)TEST_STRING, (Object)bean.getStringValue());
        Assert.assertEquals((String)"Wrong int property", (long)42L, (long)bean.getIntValue());
        BeanCreationTestBean buddy = bean.getBuddy();
        Assert.assertNotNull((String)"Buddy was not set", (Object)buddy);
        Assert.assertEquals((String)"Wrong string property in buddy", (Object)"Another test string", (Object)buddy.getStringValue());
        Assert.assertEquals((String)"Wrong int property in buddy", (long)100L, (long)buddy.getIntValue());
    }

    private void checkBean(BeanCreationTestBeanWithListChild bean) {
        Assert.assertEquals((String)"Wrong string property", (Object)TEST_STRING, (Object)bean.getStringValue());
        Assert.assertEquals((String)"Wrong int property", (long)42L, (long)bean.getIntValue());
        List<BeanCreationTestBean> children = bean.getChildren();
        Assert.assertNotNull((String)"Children were not set", children);
        Assert.assertEquals((String)"Wrong number of children created", (long)children.size(), (long)2L);
        Assert.assertNotNull((String)"First child was set as null", (Object)children.get(0));
        Assert.assertNotNull((String)"Second child was set as null", (Object)children.get(1));
    }

    private BeanDeclarationTestImpl createChildBean(String name) {
        BeanDeclarationTestImpl childBean = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties2 = new HashMap<String, Object>();
        properties2.put("stringValue", name + " Another test string");
        properties2.put("intValue", 100);
        childBean.setBeanProperties(properties2);
        childBean.setBeanClassName(BeanCreationTestBean.class.getName());
        return childBean;
    }

    @Before
    public void setUp() throws Exception {
        this.helper = new BeanHelper((BeanFactory)new TestBeanFactory());
    }

    private BeanDeclarationTestImpl setUpBeanDeclaration() {
        BeanDeclarationTestImpl data = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("stringValue", TEST_STRING);
        properties.put("intValue", String.valueOf(42));
        data.setBeanProperties(properties);
        BeanDeclarationTestImpl buddyData = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties2 = new HashMap<String, Object>();
        properties2.put("stringValue", "Another test string");
        properties2.put("intValue", 100);
        buddyData.setBeanProperties(properties2);
        buddyData.setBeanClassName(BeanCreationTestBean.class.getName());
        HashMap<String, Object> nested = new HashMap<String, Object>();
        nested.put("buddy", buddyData);
        data.setNestedBeanDeclarations(nested);
        return data;
    }

    private BeanDeclarationTestImpl setUpBeanDeclarationWithListChild() {
        BeanDeclarationTestImpl data = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("stringValue", TEST_STRING);
        properties.put("intValue", String.valueOf(42));
        data.setBeanProperties(properties);
        ArrayList<BeanDeclarationTestImpl> childData = new ArrayList<BeanDeclarationTestImpl>();
        childData.add(this.createChildBean("child1"));
        childData.add(this.createChildBean("child2"));
        HashMap<String, Object> nested = new HashMap<String, Object>();
        nested.put("children", childData);
        data.setNestedBeanDeclarations(nested);
        return data;
    }

    @Test
    public void testCopyProperties() throws Exception {
        PropertiesConfiguration src = new PropertiesConfiguration();
        src.setHeader("TestHeader");
        src.setFooter("TestFooter");
        LazyDynaBean dest = new LazyDynaBean();
        BeanHelper.copyProperties((Object)dest, (Object)src);
        Assert.assertEquals((String)"Wrong footer property", (Object)"TestFooter", (Object)dest.get("footer"));
        Assert.assertEquals((String)"Wrong header property", (Object)"TestHeader", (Object)dest.get("header"));
    }

    @Test
    public void testCreateBean() {
        TestBeanFactory factory = new TestBeanFactory();
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)factory);
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(BeanCreationTestBean.class.getName());
        this.checkBean((BeanCreationTestBean)this.helper.createBean((BeanDeclaration)data, null));
        Assert.assertNull((String)"A parameter was passed", (Object)factory.parameter);
        Assert.assertEquals((String)"Factory not called", (long)1L, (long)factory.getCreateBeanCount());
    }

    @Test
    public void testCreateBeanWithDefaultClass() {
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        this.checkBean((BeanCreationTestBean)this.helper.createBean((BeanDeclaration)data, BeanCreationTestBean.class));
    }

    @Test
    public void testCreateBeanWithDefaultFactory() {
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanClassName(BeanCreationTestBean.class.getName());
        this.checkBean((BeanCreationTestBean)this.helper.createBean((BeanDeclaration)data, null));
        TestBeanFactory factory = (TestBeanFactory)this.helper.getDefaultBeanFactory();
        Assert.assertTrue((String)"Factory not called", (factory.getCreateBeanCount() > 0 ? 1 : 0) != 0);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCreateBeanWithException() {
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(this.getClass().getName());
        this.helper.createBean((BeanDeclaration)data, null);
    }

    @Test
    public void testCreateBeanWithFactoryDefaultClass() {
        TestBeanFactory factory = new TestBeanFactory();
        factory.supportsDefaultClass = true;
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)factory);
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        this.checkBean((BeanCreationTestBean)this.helper.createBean((BeanDeclaration)data, null));
        Assert.assertEquals((String)"Factory not called", (long)1L, (long)factory.getCreateBeanCount());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCreateBeanWithInvalidClass() {
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName("non.existing.ClassName");
        this.helper.createBean((BeanDeclaration)data, null);
    }

    @Test
    public void testCreateBeanWithListChildBean() {
        TestBeanFactory factory = new TestBeanFactory();
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)factory);
        BeanDeclarationTestImpl data = this.setUpBeanDeclarationWithListChild();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(BeanCreationTestBeanWithListChild.class.getName());
        this.checkBean((BeanCreationTestBeanWithListChild)this.helper.createBean((BeanDeclaration)data, null));
        Assert.assertNull((String)"A parameter was passed", (Object)factory.parameter);
        Assert.assertEquals((String)"Factory not called", (long)1L, (long)factory.getCreateBeanCount());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCreateBeanWithNoClass() {
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        this.helper.createBean((BeanDeclaration)data, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateBeanWithNullDeclaration() {
        this.helper.createBean(null);
    }

    @Test
    public void testCreateBeanWithParameter() {
        Integer param = 42;
        TestBeanFactory factory = new TestBeanFactory();
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)factory);
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(BeanCreationTestBean.class.getName());
        this.checkBean((BeanCreationTestBean)this.helper.createBean((BeanDeclaration)data, null, (Object)param));
        Assert.assertSame((String)"Wrong parameter", (Object)param, (Object)factory.parameter);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCreateBeanWithUnknownFactory() {
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.setBeanFactoryName(TEST_FACTORY);
        data.setBeanClassName(BeanCreationTestBean.class.getName());
        this.helper.createBean((BeanDeclaration)data, null);
    }

    @Test
    public void testCreateWrapDynaBean() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        DynaBean bean = BeanHelper.createWrapDynaBean((Object)config);
        String value = "TestFooter";
        bean.set("footer", (Object)"TestFooter");
        Assert.assertEquals((String)"Property not set", (Object)"TestFooter", (Object)config.getFooter());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateWrapDynaBeanNull() {
        BeanHelper.createWrapDynaBean(null);
    }

    @Test
    public void testDefaultBeanFactory() {
        this.helper = new BeanHelper();
        Assert.assertSame((String)"Wrong default bean factory", (Object)DefaultBeanFactory.INSTANCE, (Object)this.helper.getDefaultBeanFactory());
    }

    @Test
    public void testDefaultInstance() {
        Assert.assertSame((String)"Wrong factory for default instance", (Object)DefaultBeanFactory.INSTANCE, (Object)BeanHelper.INSTANCE.getDefaultBeanFactory());
    }

    @Test
    public void testDeregisterBeanFactory() {
        TestBeanFactory factory = new TestBeanFactory();
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)factory);
        Assert.assertSame((String)"Could not deregister factory", (Object)factory, (Object)this.helper.deregisterBeanFactory(TEST_FACTORY));
        Assert.assertTrue((String)"List of factories is not empty", (boolean)this.helper.registeredFactoryNames().isEmpty());
    }

    @Test
    public void testDeregisterBeanFactoryNonExisting() {
        Assert.assertNull((String)"deregistering non existing factory", (Object)this.helper.deregisterBeanFactory(TEST_FACTORY));
    }

    @Test
    public void testDeregisterBeanFactoryNull() {
        Assert.assertNull((String)"deregistering null factory", (Object)this.helper.deregisterBeanFactory(null));
    }

    @Test
    public void testInitBean() {
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        BeanCreationTestBean bean = new BeanCreationTestBean();
        this.helper.initBean((Object)bean, (BeanDeclaration)data);
        this.checkBean(bean);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testInitBeanWithInvalidProperty() {
        BeanDeclarationTestImpl data = this.setUpBeanDeclaration();
        data.getBeanProperties().put("nonExistingProperty", Boolean.TRUE);
        this.helper.initBean((Object)new BeanCreationTestBean(), (BeanDeclaration)data);
    }

    @Test
    public void testInitBeanWithNoData() {
        BeanDeclarationTestImpl data = new BeanDeclarationTestImpl();
        BeanCreationTestBean bean = new BeanCreationTestBean();
        this.helper.initBean((Object)bean, (BeanDeclaration)data);
        Assert.assertNull((String)"Wrong string property", (Object)bean.getStringValue());
        Assert.assertEquals((String)"Wrong int property", (long)0L, (long)bean.getIntValue());
        Assert.assertNull((String)"Buddy was set", (Object)bean.getBuddy());
    }

    @Test
    public void testInitWithBeanFactory() {
        BeanFactory factory = (BeanFactory)EasyMock.createMock(BeanFactory.class);
        EasyMock.replay((Object[])new Object[]{factory});
        this.helper = new BeanHelper(factory);
        Assert.assertSame((String)"Wrong default bean factory", (Object)factory, (Object)this.helper.getDefaultBeanFactory());
    }

    @Test
    public void testRegisterBeanFactory() {
        this.helper.registerBeanFactory(TEST_FACTORY, (BeanFactory)new TestBeanFactory());
        Assert.assertEquals((String)"Wrong number of registered factories", (long)1L, (long)this.helper.registeredFactoryNames().size());
        Assert.assertTrue((String)"Test factory is not contained", (boolean)this.helper.registeredFactoryNames().contains(TEST_FACTORY));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterBeanFactoryNull() {
        this.helper.registerBeanFactory(TEST_FACTORY, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterBeanFactoryNullName() {
        this.helper.registerBeanFactory(null, (BeanFactory)new TestBeanFactory());
    }

    @Test
    public void testRegisteredFactoriesEmptyForNewInstance() {
        Assert.assertTrue((String)"List of registered factories is not empty", (boolean)this.helper.registeredFactoryNames().isEmpty());
    }

    private class TestBeanFactory
    implements BeanFactory {
        Object parameter;
        boolean supportsDefaultClass;
        private int createBeanCount;

        private TestBeanFactory() {
        }

        public Object createBean(BeanCreationContext bcc) {
            ++this.createBeanCount;
            this.parameter = bcc.getParameter();
            if (BeanCreationTestBean.class.equals((Object)bcc.getBeanClass())) {
                BeanCreationTestBean bean = new BeanCreationTestBean();
                TestBeanHelper.this.helper.initBean((Object)bean, bcc.getBeanDeclaration());
                return bean;
            }
            if (BeanCreationTestBeanWithListChild.class.equals((Object)bcc.getBeanClass())) {
                BeanCreationTestBeanWithListChild bean = new BeanCreationTestBeanWithListChild();
                TestBeanHelper.this.helper.initBean((Object)bean, bcc.getBeanDeclaration());
                return bean;
            }
            throw new IllegalArgumentException("Unsupported class: " + bcc.getBeanClass());
        }

        public int getCreateBeanCount() {
            return this.createBeanCount;
        }

        public Class<?> getDefaultBeanClass() {
            return this.supportsDefaultClass ? BeanCreationTestBean.class : null;
        }
    }
}

