/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.CombinedBeanDeclaration;
import org.apache.commons.configuration2.beanutils.ConstructorArg;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestCombinedBeanDeclaration {
    private BeanDeclaration[] declarations;

    private CombinedBeanDeclaration createCombinedDeclaration() {
        this.declarations = new BeanDeclaration[3];
        for (int i = 0; i < this.declarations.length; ++i) {
            this.declarations[i] = (BeanDeclaration)EasyMock.createMock(BeanDeclaration.class);
        }
        return new CombinedBeanDeclaration(this.declarations);
    }

    private BeanDeclaration decl(int idx) {
        return this.declarations[idx];
    }

    private void replay() {
        if (this.declarations != null) {
            EasyMock.replay((Object[])this.declarations);
        }
    }

    @Test
    public void testGetBeanClassNameDefined() {
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        EasyMock.expect((Object)this.decl(0).getBeanClassName()).andReturn(null);
        EasyMock.expect((Object)this.decl(1).getBeanClassName()).andReturn((Object)this.getClass().getName());
        this.replay();
        Assert.assertEquals((String)"Wrong bean class", (Object)this.getClass().getName(), (Object)cd.getBeanClassName());
        this.verify();
    }

    @Test
    public void testGetBeanClassNameUndefined() {
        CombinedBeanDeclaration cd = new CombinedBeanDeclaration(new BeanDeclaration[0]);
        Assert.assertNull((String)"Got a bean class name", (Object)cd.getBeanClassName());
    }

    @Test
    public void testGetBeanFactoryNameDefined() {
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        String name = "someTestBeanFactory";
        EasyMock.expect((Object)this.decl(0).getBeanFactoryName()).andReturn(null);
        EasyMock.expect((Object)this.decl(1).getBeanFactoryName()).andReturn((Object)"someTestBeanFactory");
        this.replay();
        Assert.assertEquals((String)"Wrong factory name", (Object)"someTestBeanFactory", (Object)cd.getBeanFactoryName());
        this.verify();
    }

    @Test
    public void testGetBeanFactoryNameUndefined() {
        CombinedBeanDeclaration cd = new CombinedBeanDeclaration(new BeanDeclaration[0]);
        Assert.assertNull((String)"Got a factory name", (Object)cd.getBeanFactoryName());
    }

    @Test
    public void testGetBeanFactoryParameterDefined() {
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        Object param = new Object();
        EasyMock.expect((Object)this.decl(0).getBeanFactoryParameter()).andReturn(null);
        EasyMock.expect((Object)this.decl(1).getBeanFactoryParameter()).andReturn(param);
        this.replay();
        Assert.assertSame((String)"Wrong parameter", (Object)param, (Object)cd.getBeanFactoryParameter());
        this.verify();
    }

    @Test
    public void testGetBeanFactoryParameterUndefined() {
        CombinedBeanDeclaration cd = new CombinedBeanDeclaration(new BeanDeclaration[0]);
        Assert.assertNull((String)"Got a factory parameter", (Object)cd.getBeanFactoryParameter());
    }

    @Test
    public void testGetBeanProperties() {
        HashMap<String, String> props1 = new HashMap<String, String>();
        HashMap<String, String> props2 = new HashMap<String, String>();
        HashMap<String, String> props3 = new HashMap<String, String>();
        props1.put("param1", "value1");
        props1.put("param2", "value2");
        props2.put("param2", "othervalue");
        props2.put("param3", "value3");
        props3.put("param1", "differentvalue");
        props3.put("param4", "value4");
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        EasyMock.expect((Object)this.decl(0).getBeanProperties()).andReturn(props1);
        EasyMock.expect((Object)this.decl(1).getBeanProperties()).andReturn(props2);
        EasyMock.expect((Object)this.decl(2).getBeanProperties()).andReturn(props3);
        this.replay();
        Map props = cd.getBeanProperties();
        Assert.assertEquals((String)"Wrong number of properties", (long)4L, (long)props.size());
        for (int i = 1; i <= 4; ++i) {
            Assert.assertEquals((String)"Wrong property", (Object)("value" + i), props.get("param" + i));
        }
        this.verify();
    }

    @Test
    public void testGetBeanPropertiesNull() {
        BeanDeclaration child = (BeanDeclaration)EasyMock.createMock(BeanDeclaration.class);
        EasyMock.expect((Object)child.getBeanProperties()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{child});
        CombinedBeanDeclaration cd = new CombinedBeanDeclaration(new BeanDeclaration[]{child});
        Assert.assertTrue((String)"Got bean properties", (boolean)cd.getBeanProperties().isEmpty());
    }

    @Test
    public void testGetConstructorArgsDefined() {
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        List<ConstructorArg> args = Arrays.asList(ConstructorArg.forValue((Object)42));
        EasyMock.expect((Object)this.decl(0).getConstructorArgs()).andReturn(null);
        EasyMock.expect((Object)this.decl(1).getConstructorArgs()).andReturn(args);
        this.replay();
        Assert.assertSame((String)"Wrong constructor arguments", args, (Object)cd.getConstructorArgs());
        this.verify();
    }

    @Test
    public void testGetConstructorArgsUndefined() {
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        EasyMock.expect((Object)this.decl(0).getConstructorArgs()).andReturn(null);
        EasyMock.expect((Object)this.decl(1).getConstructorArgs()).andReturn(new ArrayList());
        EasyMock.expect((Object)this.decl(2).getConstructorArgs()).andReturn(null);
        this.replay();
        Assert.assertTrue((String)"Got constructor arguments", (boolean)cd.getConstructorArgs().isEmpty());
        this.verify();
    }

    @Test
    public void testGetNestedBeanDeclarations() {
        HashMap<String, String> decls1 = new HashMap<String, String>();
        HashMap<String, String> decls2 = new HashMap<String, String>();
        HashMap<String, String> decls3 = new HashMap<String, String>();
        decls1.put("param1", "value1");
        decls1.put("param2", "value2");
        decls2.put("param2", "othervalue");
        decls2.put("param3", "value3");
        decls3.put("param1", "differentvalue");
        decls3.put("param4", "value4");
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        EasyMock.expect((Object)this.decl(0).getNestedBeanDeclarations()).andReturn(decls1);
        EasyMock.expect((Object)this.decl(1).getNestedBeanDeclarations()).andReturn(decls2);
        EasyMock.expect((Object)this.decl(2).getNestedBeanDeclarations()).andReturn(decls3);
        this.replay();
        Map decls = cd.getNestedBeanDeclarations();
        Assert.assertEquals((String)"Wrong number of declarations", (long)4L, (long)decls.size());
        for (int i = 1; i <= 4; ++i) {
            Assert.assertEquals((String)"Wrong declaration", (Object)("value" + i), decls.get("param" + i));
        }
        this.verify();
    }

    @Test
    public void testGetNestedBeanDeclarationsNull() {
        BeanDeclaration child = (BeanDeclaration)EasyMock.createMock(BeanDeclaration.class);
        EasyMock.expect((Object)child.getNestedBeanDeclarations()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{child});
        CombinedBeanDeclaration cd = new CombinedBeanDeclaration(new BeanDeclaration[]{child});
        Assert.assertTrue((String)"Got bean declarations", (boolean)cd.getNestedBeanDeclarations().isEmpty());
    }

    private void verify() {
        if (this.declarations != null) {
            EasyMock.verify((Object[])this.declarations);
        }
    }
}

